/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.XmKeyCert;
import Xm.JavaUtils.XmKeyStoreException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class XmKeyStoreHelper {
    private KeyStore m_store = null;

    public void load(String filename, String password) throws XmKeyStoreException, NullPointerException {
        if (password == null) {
            throw new NullPointerException();
        }
        String local = "XmKeyStoreHelper.load(" + (filename != null ? filename : "null") + ", " + password + "): ";
        FileInputStream input = null;
        try {
            if (filename != null) {
                input = new FileInputStream(filename);
            }
            try {
                KeyStore store = KeyStore.getInstance("JKS", "SUN");
                try {
                    store.load(input, password.toCharArray());
                    this.m_store = store;
                }
                catch (IOException ex) {
                    throw new XmKeyStoreException(local + ex.toString());
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new XmKeyStoreException(local + ex.toString());
                }
                catch (CertificateException ex) {
                    throw new XmKeyStoreException(local + ex.toString());
                }
            }
            catch (KeyStoreException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
            catch (NoSuchProviderException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
        }
        catch (FileNotFoundException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public void store(String filename, String password) throws XmKeyStoreException, NullPointerException {
        if (filename == null || password == null) {
            throw new NullPointerException();
        }
        this.AssertStore();
        String local = "XmKeyStoreHelper.store(" + filename + ", " + password + "): ";
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(filename);
            try {
                this.m_store.store(output, password.toCharArray());
            }
            catch (KeyStoreException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
            catch (IOException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
            catch (CertificateException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
        }
        catch (FileNotFoundException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public void setKeyCert(XmKeyCert keyCert) throws XmKeyStoreException, NullPointerException {
        if (keyCert == null) {
            throw new NullPointerException();
        }
        this.AssertStore();
        String local = "XmKeyStoreHelper.setKeyCert: ";
        if (keyCert.alias() == null) {
            throw new XmKeyStoreException(local + "keyCert.alias is null");
        }
        if (keyCert.password() == null) {
            throw new XmKeyStoreException(local + "keyCert.password is null");
        }
        if (keyCert.key() == null) {
            throw new XmKeyStoreException(local + "keyCert.key is null");
        }
        if (keyCert.cert() == null) {
            throw new XmKeyStoreException(local + "keyCert.cert is null");
        }
        Certificate[] certs = new Certificate[]{keyCert.cert()};
        try {
            this.m_store.setKeyEntry(keyCert.alias(), keyCert.key(), keyCert.password().toCharArray(), certs);
        }
        catch (KeyStoreException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
    }

    public void setCert(XmKeyCert keyCert) throws XmKeyStoreException, NullPointerException {
        if (keyCert == null) {
            throw new NullPointerException();
        }
        this.AssertStore();
        String local = "XmKeyStoreHelper.setCert: ";
        if (keyCert.alias() == null) {
            throw new XmKeyStoreException(local + "keyCert.alias is null");
        }
        if (keyCert.cert() == null) {
            throw new XmKeyStoreException(local + "keyCert.cert is null");
        }
        try {
            this.m_store.setCertificateEntry(keyCert.alias(), keyCert.cert());
        }
        catch (KeyStoreException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
    }

    private void AssertStore() throws XmKeyStoreException {
        if (this.m_store == null) {
            throw new XmKeyStoreException("XmKeyStoreHelper.AssertStore: store is not loaded");
        }
    }
}

