/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.XmKeyStoreException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class XmKeyCert {
    private String m_alias;
    private String m_password;
    private PrivateKey m_key;
    private Certificate m_cert;

    public XmKeyCert(String alias, String password) {
        this.m_alias = alias;
        this.m_password = password;
        this.m_key = null;
        this.m_cert = null;
    }

    public void loadPrivateKey(String filename) throws NullPointerException, XmKeyStoreException {
        if (filename == null) {
            throw new NullPointerException();
        }
        this.m_key = XmKeyCert.getKeyFromFile(filename);
    }

    public void loadPrivateKey(byte[] key) throws NullPointerException, XmKeyStoreException {
        if (key == null) {
            throw new NullPointerException();
        }
        this.m_key = XmKeyCert.getKeyFromBytes(key);
    }

    public void loadCert(String filename) throws NullPointerException, XmKeyStoreException {
        if (filename == null) {
            throw new NullPointerException();
        }
        this.m_cert = XmKeyCert.getFirstCertFromFile(filename);
    }

    String alias() {
        return this.m_alias;
    }

    String password() {
        return this.m_password;
    }

    PrivateKey key() {
        return this.m_key;
    }

    Certificate cert() {
        return this.m_cert;
    }

    private static Certificate getFirstCertFromFile(String filename) throws XmKeyStoreException {
        String local = "XmKeyCert.getFirstCertFromFile(" + filename + "): ";
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try {
                FileInputStream fis = new FileInputStream(filename);
                DataInputStream dis = new DataInputStream(fis);
                byte[] bytes = new byte[dis.available()];
                dis.readFully(bytes);
                dis.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                if (bais.available() > 0) {
                    try {
                        return cf.generateCertificate(bais);
                    }
                    catch (CertificateException ex) {
                        throw new XmKeyStoreException(local + ex.toString());
                    }
                }
                throw new XmKeyStoreException(local + "file is empty");
            }
            catch (FileNotFoundException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
            catch (IOException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
        }
        catch (CertificateException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
    }

    private static PrivateKey getKeyFromFile(String filename) throws XmKeyStoreException {
        byte[] bytes = XmKeyCert.getKeyBytesFromDerFile(filename);
        return XmKeyCert.getKeyFromBytes(bytes);
    }

    private static byte[] getKeyBytesFromDerFile(String filename) throws XmKeyStoreException {
        String local = "XmKeyCert.getKeyBytesFromDerFile(" + filename + "): ";
        try {
            FileInputStream fis = new FileInputStream(filename);
            DataInputStream dis = new DataInputStream(fis);
            byte[] bytes = new byte[dis.available()];
            dis.readFully(bytes);
            dis.close();
            if (bytes.length > 0) {
                return bytes;
            }
            throw new XmKeyStoreException(local + "file is empty");
        }
        catch (FileNotFoundException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
        catch (IOException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
    }

    private static PrivateKey getKeyFromBytes(byte[] bytes) throws XmKeyStoreException {
        String local = "XmKeyCert.getKeyFromBytes(byte[" + bytes.length + "]): ";
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec kspec = new PKCS8EncodedKeySpec(bytes);
            try {
                return kf.generatePrivate(kspec);
            }
            catch (InvalidKeySpecException ex) {
                throw new XmKeyStoreException(local + ex.toString());
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XmKeyStoreException(local + ex.toString());
        }
    }
}

