/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

public class Version {
    private String m_version = null;
    private int m_major = 0;
    private int m_minor = 0;
    private int m_pack = 0;
    private int m_build = 0;

    public static Version fromString(String version) throws NullPointerException, IllegalArgumentException {
        int[] numbers = Version.getNumbers(version);
        return new Version(version, numbers[0], numbers[1], numbers[2], numbers[3]);
    }

    public int compareTo(Version anotherVersion) throws NullPointerException {
        if (anotherVersion == null) {
            throw new NullPointerException();
        }
        if (this.equals(anotherVersion)) {
            return 0;
        }
        boolean thisIsGreater = true;
        if (this.m_major == anotherVersion.major()) {
            if (this.m_minor == anotherVersion.minor()) {
                if (this.m_pack == anotherVersion.pack()) {
                    if (this.m_build < anotherVersion.build()) {
                        thisIsGreater = false;
                    }
                } else if (this.m_pack < anotherVersion.pack()) {
                    thisIsGreater = false;
                }
            } else if (this.m_minor < anotherVersion.minor()) {
                thisIsGreater = false;
            }
        } else if (this.m_major < anotherVersion.major()) {
            thisIsGreater = false;
        }
        return thisIsGreater ? 1 : -1;
    }

    public final boolean equals(Object anObject) {
        Version other;
        if (anObject != null && anObject instanceof Version && this.m_major == (other = (Version)anObject).major() && this.m_minor == other.minor() && this.m_pack == other.pack() && this.m_build == other.build()) {
            return true;
        }
        return super.equals(anObject);
    }

    public int hashCode() {
        return this.m_major * 53 + this.m_minor * 37 + this.m_pack * 17 + this.m_build;
    }

    public boolean isBefore(Version other) {
        return this.compareTo(other) == -1;
    }

    public boolean isAfter(Version other) {
        return this.compareTo(other) == 1;
    }

    public int major() {
        return this.m_major;
    }

    public int minor() {
        return this.m_minor;
    }

    public int pack() {
        return this.m_pack;
    }

    public int build() {
        return this.m_build;
    }

    public String toString() {
        return this.m_version;
    }

    private Version() {
    }

    private Version(String version, int major, int minor, int pack, int build) {
        this.m_version = version;
        this.m_major = major;
        this.m_minor = minor;
        this.m_pack = pack;
        this.m_build = build;
    }

    private static int[] getNumbers(String version) throws NullPointerException, IllegalArgumentException {
        if (version == null) {
            throw new NullPointerException();
        }
        int[] versionNumbers = new int[4];
        int index = 0;
        StringBuffer buf = new StringBuffer();
        boolean number = false;
        int len = version.length();
        for (int i = 0; i < len; ++i) {
            char c = version.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    number = true;
                    buf.append(c);
                    break;
                }
                default: {
                    if (!number) break;
                    number = false;
                    versionNumbers[index] = Version.toInt(buf.toString());
                    ++index;
                    buf = new StringBuffer();
                }
            }
            if (index > 3) break;
        }
        if (index == 3 && number) {
            versionNumbers[index] = Version.toInt(buf.toString());
            ++index;
        }
        if (index != 4) {
            throw new IllegalArgumentException();
        }
        return versionNumbers;
    }

    private static int toInt(String string) throws IllegalArgumentException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException();
        }
    }
}

