/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.HostList;
import Xm.JavaUtils.Port;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.TraderHelperOptions;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.FollowOptionHelper;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.LookupPackage.HowManyProps;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.UnknownServiceType;

public class TradingService {
    private static final int MAX_NB_OFFERS = 10;
    private Lookup m_CurrentLookup;
    private ORB m_Orb = null;
    SingletonFileLogger m_FileLogger = SingletonFileLogger.GetInstance();

    public TradingService() {
        this.m_Orb = ORB.init((String[])new String[0], (Properties)System.getProperties());
    }

    public TradingService(ORB Orb) {
        this.m_Orb = Orb;
    }

    public Object QueryFirstReference(String type, TraderHelperOptions options) throws TradingServiceException {
        this.m_FileLogger.LogWriteLowLevel("XMJU18-007", "TradingService::QueryFirstReference...");
        Offer[] offers = this.QueryOffer(type, options, 1, true);
        Object result = offers[0].reference;
        this.m_FileLogger.LogWriteLowLevel("XMJU18-008", "TradingService::QueryFirstReference...Done");
        return result;
    }

    public Object[] QueryAllReferences(String type, TraderHelperOptions options) throws TradingServiceException {
        this.m_FileLogger.LogWriteLowLevel("XMJU18-016", "TradingService::QueryAllReferences...");
        Offer[] offers = this.QueryOffer(type, options, 10, false);
        Object[] results = new Object[offers.length];
        for (int i = 0; i < offers.length; ++i) {
            results[i] = offers[i].reference;
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU18-017", "TradingService::QueryAllReferences...Done");
        return results;
    }

    Offer[] QueryOffer(String type, TraderHelperOptions options, int how_many, boolean throw_if_no_offer) throws TradingServiceException {
        Policy[] policies;
        this.m_FileLogger.LogWriteLowLevel("XMJU18-010", "TradingService::QueryOffer...");
        String pref = "first";
        if (how_many < 1) {
            throw new IllegalArgumentException("You must request at least 1 reference in QueryOffer");
        }
        if (options.getLookInFederation()) {
            Any value1 = this.m_Orb.create_any();
            value1.insert_ulong(1);
            Any value2 = this.m_Orb.create_any();
            FollowOptionHelper.insert((Any)value2, (FollowOption)FollowOption.always);
            policies = new Policy[]{new Policy("hop_count", value1), new Policy("link_follow_rule", value2)};
        } else {
            policies = new Policy[]{};
        }
        SpecifiedProps desired_props = new SpecifiedProps();
        desired_props.__default(HowManyProps.all);
        OfferSeqHolder offers = new OfferSeqHolder();
        OfferIteratorHolder offer_itr = new OfferIteratorHolder();
        PolicyNameSeqHolder limits_applied = new PolicyNameSeqHolder();
        LookupIterator lookup_iterator = new LookupIterator();
        while (true) {
            try {
                Lookup lookup = lookup_iterator.next();
                lookup.query(type, options.getConstraint(), pref, policies, desired_props, how_many, offers, offer_itr, limits_applied);
                if (offer_itr.value != null) {
                    offer_itr.value.destroy();
                }
                if (offers.value != null && offers.value.length > 0) {
                    this.m_FileLogger.LogWriteLowLevel("XMJU18-013", "TradingService::QueryOffer...Done");
                    return offers.value;
                }
                if (throw_if_no_offer) {
                    throw new TradingServiceException("No offer available for this type[" + type + "] and constraint[" + options.getConstraint() + "]", 16);
                }
                return new Offer[0];
            }
            catch (UserException e) {
                this.m_FileLogger.LogWriteLowLevel("XMJU18-011", "TradingService::QueryOffer...Error");
                if (e instanceof UnknownServiceType && !throw_if_no_offer) {
                    return new Offer[0];
                }
                throw new TradingServiceException(e.getMessage(), 256);
            }
            catch (SystemException e) {
                if (lookup_iterator.hasPossibleNext()) {
                    this.m_FileLogger.LogWriteLowLevel("XMJU18-019", "Will try next trader because the following exception occurred: " + e.toString());
                    continue;
                }
                this.m_FileLogger.LogWriteLowLevel("XMJU18-012", "TradingService::QueryOffer...Error");
                throw new TradingServiceException(e.toString(), 65536);
            }
            break;
        }
    }

    private Lookup getCurrentLookup() {
        return this.m_CurrentLookup;
    }

    private void setCurrentLookup(Lookup lookup) {
        this.m_CurrentLookup = lookup;
    }

    public class TradingServiceException
    extends Exception {
        private static final long serialVersionUID = 1843199459651374064L;
        public static final int INTERNAL = 1;
        public static final int LOOKUP_IS_NULL = 3;
        public static final int NO_OFFER = 16;
        public static final int CORBA_USER = 256;
        public static final int CORBA_SYSTEM = 65536;
        private int m_Cause;

        TradingServiceException(String s, int c) {
            super(s);
            this.m_Cause = c;
        }

        public int Cause() {
            return this.m_Cause;
        }
    }

    private final class LookupIterator {
        private HostList.HostListIterator m_HostIterator;
        private boolean m_HasCurrentBeenUsed = false;

        private LookupIterator() {
        }

        private Lookup next() {
            Lookup lookup = TradingService.this.getCurrentLookup();
            if (lookup != null && !this.m_HasCurrentBeenUsed) {
                this.m_HasCurrentBeenUsed = true;
                return lookup;
            }
            TradingService.this.setCurrentLookup(null);
            if (this.m_HostIterator == null) {
                this.m_HostIterator = new HostList().createIterator();
            }
            java.lang.Object to_throw = null;
            while (this.m_HostIterator.hasNext()) {
                String host = this.m_HostIterator.next();
                try {
                    String corbaloc = "corbaloc:iiop:" + host + ":" + Port.TraderPort() + "/TradingService";
                    Object obj = TradingService.this.m_Orb.string_to_object(corbaloc);
                    lookup = LookupHelper.narrow((Object)obj);
                    TradingService.this.setCurrentLookup(lookup);
                    return lookup;
                }
                catch (SystemException e) {
                    SingletonFileLogger.GetInstance().LogWriteLowLevel("XMJU18-018", "ResolveLookup failed with " + host + " - " + e.toString());
                    to_throw = e;
                }
            }
            throw to_throw != null ? to_throw : new BAD_OPERATION("All hosts have been tried");
        }

        synchronized boolean hasPossibleNext() {
            return this.m_HostIterator == null || this.m_HostIterator.hasNext();
        }
    }
}

