/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.JavaUtils.TraderHelperX;
import Xm.JavaUtils.TradingService;
import Xm.JavaUtils.ValidatorI;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;

public class TraderHelper {
    public static final int INFINITE_RETRIES = -1;
    private static final int SLEEP_BETWEEN_RETRIES = 5000;
    private static TraderHelper sm_Singleton;
    private TraderCache m_Cache = new TraderCache();
    private TradingService m_Trader;
    private SingletonFileLogger m_Logger;

    private TraderHelper() {
        this.m_Trader = new TradingService();
        this.m_Logger = SingletonFileLogger.GetInstance();
    }

    public TraderHelper(ORB orb) {
        this.m_Trader = new TradingService(orb);
        this.m_Logger = SingletonFileLogger.GetInstance();
    }

    public static TraderHelper Instance() {
        if (sm_Singleton == null) {
            sm_Singleton = new TraderHelper();
        }
        return sm_Singleton;
    }

    public synchronized void WakeUp() {
        this.notifyAll();
    }

    private synchronized void NoThrowWait(long MillisecondsToWait, ValidatorI DoWait) {
        try {
            if (DoWait.Validate()) {
                this.wait(MillisecondsToWait);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public java.lang.Object CallFirst(Class ObjectClass, Class HelperClass, String MethodName, java.lang.Object[] Arguments, String OfferType, TraderHelperOptions options, int NbRetries, ValidatorI DoCall) throws UserException, TraderHelperX {
        Class[] argument_types = new Class[Arguments != null ? Arguments.length : 0];
        for (int i = 0; i < argument_types.length; ++i) {
            argument_types[i] = Arguments[i].getClass();
        }
        return this.CallFirst(ObjectClass, HelperClass, MethodName, argument_types, Arguments, OfferType, options, NbRetries, DoCall);
    }

    public java.lang.Object CallFirst(Class ObjectClass, Class HelperClass, String MethodName, Class[] ArgumentsClasses, java.lang.Object[] Arguments, String OfferType, TraderHelperOptions options, int NbRetries, ValidatorI DoCall) throws UserException, TraderHelperX {
        Method called_method = null;
        Object remote_object = null;
        try {
            called_method = ObjectClass.getMethod(MethodName, ArgumentsClasses);
        }
        catch (NoSuchMethodException e) {
            StringBuffer args = new StringBuffer();
            for (int i = 0; i < ArgumentsClasses.length; ++i) {
                args.append(ArgumentsClasses[i].getName());
                args.append(", ");
            }
            throw new TraderHelperX(1, "Method '" + MethodName + "' does not exist in class '" + ObjectClass.getName() + "' for the arguments: " + args.toString());
        }
        boolean is_infinite = NbRetries == -1;
        boolean use_cache = true;
        for (int retries_left = Math.max(1, NbRetries); (is_infinite || retries_left > 0) && DoCall.Validate(); --retries_left) {
            try {
                remote_object = this.QueryFirstReference(OfferType, options, HelperClass, use_cache);
                return called_method.invoke((java.lang.Object)remote_object, Arguments);
            }
            catch (IllegalAccessException e) {
                throw new TraderHelperX(1, "Can't access method '" + called_method.getName() + "' on object '" + remote_object.getClass().getName() + "'");
            }
            catch (IllegalArgumentException e) {
                throw new TraderHelperX(1, "Illegal argument passed to method '" + called_method.getName() + "' or the object on which it is executed is not the good type. " + "It should be '" + called_method.getDeclaringClass().getName() + "' but was '" + remote_object.getClass().getName() + "'. Message given by Java: " + e.getMessage());
            }
            catch (TraderHelperX e) {
                switch (e.MinorCause()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw e;
                    }
                }
                this.m_Logger.LogWriteWarning("XMJU22-000", "TraderHelperX: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getTargetException();
                }
                catch (SystemException ex) {
                    this.m_Logger.LogWriteWarning("XMJU22-001", "CORBA.SystemException: " + ex.toString());
                }
                catch (UserException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    this.m_Cache.Erase(OfferType, options.getConstraint());
                    throw new TraderHelperX(0, ex.getMessage());
                }
            }
            use_cache = false;
            this.m_Cache.Erase(OfferType, options.getConstraint());
            this.NoThrowWait(5000L, DoCall);
        }
        if (!DoCall.Validate()) {
            throw new TraderHelperX(2, "Cannot call remote method, incorrect state");
        }
        throw new TraderHelperX(3, NbRetries + " retries have been done, TraderHelper gives up");
    }

    public Object QueryFirstReference(String OfferType, TraderHelperOptions options) throws TraderHelperX {
        try {
            return this.m_Trader.QueryFirstReference(OfferType, options);
        }
        catch (TradingService.TradingServiceException e) {
            throw this.ConvertToTraderHelperX(e);
        }
        catch (SystemException e) {
            throw new TraderHelperX(5, "No trading service could be contacted. Check that all Services are running.");
        }
    }

    private Object QueryFirstReference(String OfferType, TraderHelperOptions options, Class HelperClass, boolean UseCache) throws TraderHelperX {
        Object obj = null;
        if (UseCache) {
            obj = this.m_Cache.Find(OfferType, options.getConstraint());
        }
        if (obj == null) {
            obj = this.QueryFirstReference(OfferType, options);
            if ((obj = this.Narrow(obj, HelperClass)) != null) {
                this.m_Cache.Insert(OfferType, options.getConstraint(), obj);
            } else {
                throw new TraderHelperX(4, "Could not narrow reference obtained from Trader for OfferType: \"" + OfferType + "\" AND Constraint=\"" + options.getConstraint() + "\"");
            }
        }
        return obj;
    }

    private Object Narrow(Object Obj, Class HelperClass) throws TraderHelperX {
        try {
            Method narrow_method = HelperClass.getMethod("narrow", Object.class);
            return (Object)narrow_method.invoke(null, Obj);
        }
        catch (NoSuchMethodException e) {
            throw new TraderHelperX(1, "Method 'narrow' does not exist for the HelperClass you provided: " + HelperClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new TraderHelperX(1, "Can't access method 'narrow' on " + HelperClass.getName());
        }
        catch (IllegalArgumentException e) {
            throw new TraderHelperX(1, "Illegal argument on method 'narrow' on " + HelperClass.getName());
        }
        catch (InvocationTargetException e) {
            Throwable thrown = e.getTargetException();
            throw new TraderHelperX(4, "Unknown exception while calling method 'narrow' on " + HelperClass.getName() + " : " + thrown.toString());
        }
    }

    private TraderHelperX ConvertToTraderHelperX(TradingService.TradingServiceException ex) {
        if ((ex.Cause() & 3) == 3) {
            return new TraderHelperX(5, ex.getMessage());
        }
        if ((ex.Cause() & 0x10) == 16) {
            return new TraderHelperX(6, ex.getMessage());
        }
        if ((ex.Cause() & 0x100) == 256) {
            return new TraderHelperX(7, ex.getMessage());
        }
        if ((ex.Cause() & 0x10000) == 65536) {
            return new TraderHelperX(8, ex.getMessage());
        }
        return new TraderHelperX(0, ex.getMessage());
    }

    class TraderCache {
        private Map<String, Map<String, Object>> m_Cache = new TreeMap<String, Map<String, Object>>();
        public String m_ObjectType;
        public String m_Constraint;

        public synchronized Object Find(String OfferType, String Constraint) {
            Map<String, Object> constraint_to_object = this.m_Cache.get(OfferType);
            if (constraint_to_object != null) {
                return constraint_to_object.get(Constraint);
            }
            return null;
        }

        public synchronized void Insert(String OfferType, String Constraint, Object Object2) {
            Map<String, Object> constraint_to_object = this.m_Cache.get(OfferType);
            if (constraint_to_object == null) {
                constraint_to_object = new TreeMap<String, Object>();
            }
            constraint_to_object.put(Constraint, Object2);
            this.m_Cache.put(OfferType, constraint_to_object);
        }

        public synchronized void Erase(String OfferType, String Constraint) {
            Map<String, Object> constraint_to_object = this.m_Cache.get(OfferType);
            if (constraint_to_object != null) {
                constraint_to_object.remove(Constraint);
                if (constraint_to_object.isEmpty()) {
                    this.m_Cache.remove(OfferType);
                }
            }
        }
    }
}

