/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.CorbaObjectResolver;
import Xm.JavaUtils.TraderHelper;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.JavaUtils.TraderHelperX;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraderCorbaObjectResolver<T extends Object>
implements CorbaObjectResolver<T> {
    private TraderHelper traderHelper;
    private String serviceType;
    private TraderHelperOptions options;
    private Method narrowMethod;

    public TraderCorbaObjectResolver(TraderHelper traderHelper, String serviceType, TraderHelperOptions options, Class<?> interfaceHelperClass) {
        this.traderHelper = traderHelper;
        this.serviceType = serviceType;
        this.options = options;
        this.initNarrowMethod(interfaceHelperClass);
    }

    @Override
    public T resolve() throws CorbaObjectResolver.ResolveException {
        return this.narrow(this.queryTrader(this.serviceType));
    }

    private Object queryTrader(String serviceType) throws CorbaObjectResolver.ResolveException {
        try {
            return this.traderHelper.QueryFirstReference(serviceType, this.options);
        }
        catch (TraderHelperX e) {
            throw new CorbaObjectResolver.ResolveException(e);
        }
    }

    private void initNarrowMethod(Class<?> interfaceHelperClass) {
        try {
            this.narrowMethod = interfaceHelperClass.getMethod("narrow", Object.class);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Invalid helper class", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid helper class", e);
        }
    }

    private T narrow(Object object) {
        try {
            return (T)((Object)this.narrowMethod.invoke(null, object));
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("narrow() failed", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Invalid helper class", e);
        }
    }
}

