/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.AppMonitoring.TrapQueue;
import Xm.AppMonitoring.TrapQueueHelper;
import Xm.JavaUtils.JavaRegistry;
import Xm.JavaUtils.Port;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.SnmpTrap;
import Xm.NamedProperty;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;

public class SnmpTrapSender {
    private SingletonFileLogger logger = SingletonFileLogger.GetInstance();
    private ORB orb;
    private TrapQueue queue;
    private static String corbaloc = "corbaloc:iiop:127.0.0.1:" + Port.SnmpAgentPort() + "/TrapQueue";

    public SnmpTrapSender(ORB orb) {
        this.orb = orb;
    }

    public void sendTrap(SnmpTrap trap) {
        if (trap != null) {
            this.sendTrap(trap.getTrapId(), trap.getProperties());
        }
    }

    public static boolean isSnmpAgentInstalled() {
        return JavaRegistry.IsKeyExists(3, "SYSTEM\\CurrentControlSet\\Services\\SNMP") && JavaRegistry.IsKeyExists(3, "SOFTWARE\\Interstar Technologies\\XMedius\\SNMP");
    }

    private void sendTrap(String trapId, NamedProperty[] properties) {
        String logHeader = "SnmpTrapSender.sendTrap()... ";
        this.logger.LogWriteLowLevel("XMJU29-003", "SnmpTrapSender.sendTrap()... TrapID=" + trapId);
        if (!SnmpTrapSender.isSnmpAgentInstalled()) {
            this.logger.LogWriteLowLevel("XMJU29-005", "SnmpTrapSender.sendTrap()... SNMP Agent is not installed. Trap is not sent.");
            return;
        }
        int retry = 1;
        while (true) {
            try {
                this.getTrapQueue().EnqueueTrap(trapId, properties);
                this.logger.LogWriteLowLevel("XMJU29-004", "SnmpTrapSender.sendTrap()... done");
                return;
            }
            catch (SystemException e) {
                this.resetTrapQueue(null);
                this.logger.LogWriteWarning("XMJU29-001", "SnmpTrapSender.sendTrap()... SystemException: " + SingletonFileLogger.StackTraceOf(e));
                if (retry-- > 0) continue;
                this.logger.LogWriteWarning("XMJU29-002", "SnmpTrapSender.sendTrap()... Giving up sending trap");
                return;
            }
            break;
        }
    }

    private TrapQueue resolveTrapQueue() {
        TrapQueue queue = TrapQueueHelper.narrow(this.orb.string_to_object(corbaloc));
        if (queue == null) {
            throw new RuntimeException("TrapQueueHelper.narrow() returned null reference");
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrapQueue getTrapQueue() {
        TrapQueue queue;
        SnmpTrapSender snmpTrapSender = this;
        synchronized (snmpTrapSender) {
            queue = this.queue;
        }
        if (queue == null) {
            queue = this.resolveTrapQueue();
            this.resetTrapQueue(queue);
        }
        return queue;
    }

    private synchronized void resetTrapQueue(TrapQueue newReference) {
        this.queue = newReference;
    }
}

