/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.SnmpTrapFactory;
import Xm.JavaUtils.SnmpTrapSender;

public class SnmpTrapHelper {
    private static SnmpTrapHelper instance;
    private SnmpTrapFactory factory;
    private SnmpTrapSender sender;

    private SnmpTrapHelper(SnmpTrapFactory factory, SnmpTrapSender sender) {
        this.factory = factory;
        this.sender = sender;
    }

    public static synchronized void init(SnmpTrapFactory factory, SnmpTrapSender sender) {
        if (instance != null) {
            throw new IllegalStateException("Already initialized");
        }
        if (factory == null || sender == null) {
            throw new NullPointerException();
        }
        instance = new SnmpTrapHelper(factory, sender);
    }

    private static synchronized SnmpTrapHelper getInstance() {
        return instance;
    }

    public static void sendPartitionDetectedTrap() {
        SnmpTrapHelper helper = SnmpTrapHelper.getInstance();
        if (helper != null) {
            helper.doSendPartitionDetectedTrap();
        }
    }

    private void doSendPartitionDetectedTrap() {
        this.sender.sendTrap(this.factory.createTrap("partitionDetected"));
    }
}

