/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.DirectoryHelper;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.SnmpTrap;
import Xm.NamedProperty;
import Xm.TypedValue;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.ini4j.IniFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpTrapFactory {
    private SingletonFileLogger logger = SingletonFileLogger.GetInstance();
    private Map<String, TrapDef> trapDefMap = this.loadConfigFile();

    public SnmpTrap createTrap(String trapName) {
        TrapDef trapDef = this.trapDefMap.get(trapName);
        if (trapDef != null) {
            NamedProperty[] props = new NamedProperty[]{new NamedProperty("trapPriority", new TypedValue())};
            props[0].Value.long_value(trapDef.priority);
            return new SnmpTrap(trapDef.oid, props);
        }
        this.logger.LogWriteWarning("XMJU30-002", "Unknown trap: " + trapName);
        return null;
    }

    private static void loadSectionIntoMap(Preferences snmpConfig, Map<String, TrapDef> map, String sectionName, int priority) throws BackingStoreException {
        Preferences section = snmpConfig.node(sectionName);
        for (String trapName : section.keys()) {
            String oid = section.get(trapName, null);
            map.put(trapName, new TrapDef(oid, priority));
        }
    }

    private Map<String, TrapDef> loadConfigFile() {
        File file = new File(DirectoryHelper.GetConfigFolder("SNMPAgent"), "SNMPAgent.ini");
        TreeMap<String, TrapDef> map = new TreeMap<String, TrapDef>();
        try {
            IniFile snmpConfig = new IniFile(file);
            SnmpTrapFactory.loadSectionIntoMap((Preferences)snmpConfig, map, "Information Traps", 4);
            SnmpTrapFactory.loadSectionIntoMap((Preferences)snmpConfig, map, "Warning Traps", 3);
            SnmpTrapFactory.loadSectionIntoMap((Preferences)snmpConfig, map, "Critical Traps", 2);
            SnmpTrapFactory.loadSectionIntoMap((Preferences)snmpConfig, map, "Fatal Error Traps", 1);
            return map;
        }
        catch (BackingStoreException e) {
            this.logger.LogWriteWarning("XMJU30-001", "Failed to read SNMP Agent .ini file (" + file.getAbsolutePath() + ")");
            return null;
        }
    }

    private static class TrapDef {
        final String oid;
        final int priority;

        TrapDef(String oid, int priority) {
            this.oid = oid;
            this.priority = priority;
        }
    }
}

