/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.ConsoleLogger;
import Xm.JavaUtils.JniLogger;
import Xm.JavaUtils.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;

public class SingletonFileLogger {
    private static SingletonFileLogger m_Singleton = new SingletonFileLogger();
    AtomicReference<Logger> logger = new AtomicReference();

    private SingletonFileLogger() {
        this.InitConsole();
    }

    public static SingletonFileLogger GetInstance() {
        return m_Singleton;
    }

    public void InitConsole() {
        this.logger.set(new ConsoleLogger());
    }

    public void InitConsole(int logLevel) {
        this.logger.set(new ConsoleLogger(logLevel));
    }

    public void InitJni() {
        this.logger.set(new JniLogger());
    }

    public void InitNull() {
        this.logger.set(null);
    }

    public void LogWriteLowLevel(String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteLowLevel("", strLogToAdd);
        }
    }

    public void LogWriteNormal(String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteNormal("", strLogToAdd);
        }
    }

    public void LogWriteWarning(String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteWarning("", strLogToAdd);
        }
    }

    public void LogWriteFatalError(String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteFatalError("", strLogToAdd);
        }
    }

    public void LogWriteLowLevel(String strLogCode, String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteLowLevel(strLogCode, strLogToAdd);
        }
    }

    public void LogWriteNormal(String strLogCode, String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteNormal(strLogCode, strLogToAdd);
        }
    }

    public void LogWriteWarning(String strLogCode, String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteWarning(strLogCode, strLogToAdd);
        }
    }

    public void LogWriteFatalError(String strLogCode, String strLogToAdd) {
        Logger logger = this.logger.get();
        if (logger != null) {
            logger.LogWriteFatalError(strLogCode, strLogToAdd);
        }
    }

    public static String StackTraceOf(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

