/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.CorbaInitializer;
import Xm.JavaUtils.EntityHelper.CompanyListHelper;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.JavaUtils.TradingService;
import java.util.HashMap;
import java.util.Map;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public final class ServiceLocator {
    private CompanyListHelper companyList;
    private TradingService trader;
    private CorbaInitializer corbaInitializer;
    private static Map<String, ServiceLocator> sl = new HashMap<String, ServiceLocator>();
    private String jacorbPropFile;
    private String principal;

    public static synchronized ServiceLocator getInstance() {
        return ServiceLocator.getInstance("/jacorb.properties", "WebStatus");
    }

    public static synchronized ServiceLocator getInstance(String jacorbPropFile, String principal) {
        String key = jacorbPropFile + "/" + principal;
        ServiceLocator instance = sl.get(key);
        if (instance == null) {
            instance = new ServiceLocator(jacorbPropFile, principal);
            sl.put(key, instance);
        }
        return instance;
    }

    private ServiceLocator(String jacorbPropFile, String principal) {
        this.jacorbPropFile = jacorbPropFile;
        this.principal = principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorbaInitializer getCorbaInit() throws ServiceUnavailableX {
        if (this.corbaInitializer != null) {
            return this.corbaInitializer;
        }
        ServiceLocator serviceLocator = this;
        synchronized (serviceLocator) {
            if (this.corbaInitializer != null) {
                return this.corbaInitializer;
            }
            this.corbaInitializer = new CorbaInitializer(this.jacorbPropFile, this.principal);
            return this.corbaInitializer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradingService getTrader() throws ServiceUnavailableX {
        if (this.trader != null) {
            return this.trader;
        }
        ServiceLocator serviceLocator = this;
        synchronized (serviceLocator) {
            if (this.trader != null) {
                return this.trader;
            }
            this.trader = new TradingService(this.getCorbaInit().getOrb());
            return this.trader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompanyListHelper getCompanyList() throws ServiceUnavailableX {
        if (this.companyList != null) {
            return this.companyList;
        }
        ServiceLocator serviceLocator = this;
        synchronized (serviceLocator) {
            if (this.companyList != null) {
                return this.companyList;
            }
            CompanyListHelper companyListHelper = new CompanyListHelper(this.getTrader());
            try {
                companyListHelper.ActivateServant(this.getCorbaInit().getOrb(), this.getCorbaInit().getRootPoa());
            }
            catch (ServantAlreadyActive e) {
            }
            catch (WrongPolicy e) {
                throw new ServiceUnavailableX(0, "CompanyListHelper.ActivateServant: WrongPolicy", e);
            }
            companyListHelper.Register();
            this.companyList = companyListHelper;
            return this.companyList;
        }
    }
}

