/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.PolicyApplierException;
import java.util.ArrayList;
import org.omg.CORBA.Any;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerHelper;
import org.omg.CORBA.SetOverrideType;

public class PolicyApplier {
    private ORB orb;
    private ArrayList<Policy> policies;

    public PolicyApplier(ORB orb) {
        this.orb = orb;
        this.policies = new ArrayList();
    }

    public void addTimeoutPolicy(long timeout) {
        Any timeout_value = this.orb.create_any();
        timeout_value.insert_ulonglong(10000000L * timeout);
        try {
            Policy policy = this.orb.create_policy(32, timeout_value);
            this.policies.add(policy);
        }
        catch (PolicyError e) {
            throw new PolicyApplierException(e);
        }
    }

    public Object applyTo(Object obj) {
        return obj._set_policy_override(this.policies.toArray(new Policy[0]), SetOverrideType.ADD_OVERRIDE);
    }

    public void applyToOrb() {
        try {
            PolicyManager policyManager = PolicyManagerHelper.narrow((Object)this.orb.resolve_initial_references("ORBPolicyManager"));
            policyManager.set_policy_overrides(this.policies.toArray(new Policy[0]), SetOverrideType.ADD_OVERRIDE);
        }
        catch (InvalidPolicies e) {
            throw new PolicyApplierException(e);
        }
        catch (InvalidName e) {
            throw new PolicyApplierException(e);
        }
    }
}

