/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.Locale.NameSeqHelper;
import org.jacorb.orb.CDROutputStream;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public class LocaleClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    public String name() {
        return "XmLocaleClientInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        String[] locales = ThreadStorage.getLocales();
        if (locales != null && locales.length > 0) {
            CDROutputStream cdr_out = new CDROutputStream();
            cdr_out.beginEncapsulatedArray();
            NameSeqHelper.write((OutputStream)cdr_out, locales);
            byte[] data = cdr_out.getBufferCopy();
            ServiceContext sc = new ServiceContext(0x1010010, data);
            ri.add_request_service_context(sc, true);
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public static class ThreadStorage {
        private static ThreadLocal<String[]> sm_locales = new ThreadLocal();

        public static void setLocales(String[] locales) {
            sm_locales.set(locales);
        }

        public static void removeLocales() {
            sm_locales.remove();
        }

        public static String[] getLocales() {
            return sm_locales.get();
        }
    }
}

