/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class IdSerializer {
    public static String serialize(String[] items, int startIndex) {
        StringBuffer buffer = new StringBuffer();
        for (int i = startIndex; i < items.length; ++i) {
            buffer.append(items[i].replace("&", "&&").replace("/", "&/"));
            buffer.append("/");
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static String serialize(String[] items) {
        return IdSerializer.serialize(items, 0);
    }

    public static String serialize(String[] items, int startIndex, boolean encode) throws IOException {
        String output = IdSerializer.serialize(items, startIndex);
        if (encode) {
            output = IdSerializer.encode(output);
        }
        return output;
    }

    public static String[] deserialize(String inputString, boolean decode) throws IOException {
        return IdSerializer.deserialize(decode ? IdSerializer.decode(inputString) : inputString);
    }

    public static String[] deserialize(String inputString) {
        ArrayList<String> returnValue = new ArrayList<String>();
        String[] tokens = inputString.split("/", -1);
        String value = "";
        for (String token : tokens) {
            if (IdSerializer.isSeparator(token)) {
                value = value + token;
                returnValue.add(value.replace("&/", "/").replace("&&", "&"));
                value = "";
                continue;
            }
            value = value + token + "/";
        }
        String[] returnArray = new String[returnValue.size()];
        return returnValue.toArray(returnArray);
    }

    public static String encode(String inputString) throws UnsupportedEncodingException {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(inputString.getBytes("UTF-8")).replace("\r", "").replace("\n", "");
    }

    public static String decode(String inputString) throws UnsupportedEncodingException, IOException {
        BASE64Decoder decoder = new BASE64Decoder();
        return new String(decoder.decodeBuffer(inputString), "UTF-8");
    }

    private static boolean isSeparator(String token) {
        int amperCounter = 0;
        for (int i = token.length() - 1; i >= 0 && token.charAt(i) == '&'; --i) {
            ++amperCounter;
        }
        return amperCounter % 2 == 0;
    }
}

