/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

public class FtGroupHelper {
    private byte[] m_data = null;
    private int m_index = 0;
    private byte m_ordering = 0;
    private long m_group_id = 0L;
    private int m_group_version = 0;

    public static FtGroupHelper create() {
        return new FtGroupHelper();
    }

    public void setData(byte[] data, boolean duplicate) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (data == null) {
            throw new NullPointerException();
        }
        if (data.length < 3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (duplicate) {
            int len = data.length;
            this.m_data = new byte[len];
            System.arraycopy(data, 0, this.m_data, 0, len);
        } else {
            this.m_data = data;
        }
        this.m_index = 0;
        this.m_ordering = this.readByte();
        this.readByte();
        this.readByte();
        this.skipByteSeq();
        this.m_group_id = this.readLong();
        this.m_group_version = this.readInt();
    }

    public void resetData() {
        this.m_data = null;
        this.m_index = 0;
        this.m_ordering = 0;
        this.m_group_id = 0L;
        this.m_group_version = 0;
    }

    public long groupId() {
        return this.m_group_id;
    }

    public int groupVersion() {
        return this.m_group_version;
    }

    private FtGroupHelper() {
    }

    private byte readByte() throws ArrayIndexOutOfBoundsException {
        if (this.m_data != null && this.m_index < this.m_data.length) {
            byte b = this.m_data[this.m_index];
            ++this.m_index;
            return b;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int readInt() throws ArrayIndexOutOfBoundsException {
        int modulo = this.m_index % 4;
        if (modulo != 0) {
            this.m_index += 4 - modulo;
        }
        if (this.m_data != null && this.m_index + 3 < this.m_data.length) {
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bytes[i] = this.m_data[this.m_index];
                ++this.m_index;
            }
            return this.bytesToInt(bytes);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public long readLong() throws ArrayIndexOutOfBoundsException {
        int modulo = this.m_index % 8;
        if (modulo != 0) {
            this.m_index += 8 - modulo;
        }
        if (this.m_data != null && this.m_index + 7 < this.m_data.length) {
            byte[] bytes = new byte[8];
            for (int i = 0; i < 8; ++i) {
                bytes[i] = this.m_data[this.m_index];
                ++this.m_index;
            }
            return this.bytesToLong(bytes);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private void skipByteSeq() throws ArrayIndexOutOfBoundsException {
        int len = this.readInt();
        this.m_index += len;
        if (this.m_index > this.m_data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private int bytesToInt(byte[] bytes) throws NullPointerException, IllegalArgumentException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (bytes.length != 4) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        if (this.m_ordering == 1) {
            for (int i = 0; i < 4; ++i) {
                result |= bytes[i] << 8 * i;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                result |= bytes[3 - i] << 8 * i;
            }
        }
        return result;
    }

    private long bytesToLong(byte[] bytes) throws NullPointerException, IllegalArgumentException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (bytes.length != 8) {
            throw new IllegalArgumentException();
        }
        long result = 0L;
        if (this.m_ordering == 1) {
            for (int i = 0; i < 8; ++i) {
                result |= (long)bytes[i] << 8 * i;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                result |= (long)bytes[7 - i] << 8 * i;
            }
        }
        return result;
    }
}

