/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.EntityHelper;

import Xm.Directories.Authentication;
import Xm.Directories.AuthenticationHelper;
import Xm.Directories.DirectoryError;
import Xm.Directories.Lookup;
import Xm.Directories.LookupHelper;
import Xm.Directories.LookupPackage.Result;
import Xm.Directories.NotFound;
import Xm.JavaUtils.ServiceLocator;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.JavaUtils.TradingService;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class UserDirectoriesLookupHelper {
    public static final short MAX_ATTEMPTS = 2;
    TraderResolver<Lookup> lookupResolver = new TraderResolver<Lookup>("DirectoriesLookup"){

        @Override
        Lookup get() throws ServiceUnavailableX {
            return LookupHelper.narrow(this.doGet());
        }
    };
    TraderResolver<Authentication> authenticationResolver = new TraderResolver<Authentication>("DirectoriesAuthentication"){

        @Override
        Authentication get() throws ServiceUnavailableX {
            return AuthenticationHelper.narrow(this.doGet());
        }
    };

    /*
     * Loose catch block
     */
    public boolean authenticate(String userId, String password) throws ServiceUnavailableX {
        Authentication authentication = null;
        int attempt = 0;
        while (true) {
            try {
                authentication = this.authenticationResolver.get();
                return authentication.Authenticate(userId, password);
            }
            catch (SystemException e) {
                this.authenticationResolver.error(e, ++attempt);
                continue;
            }
            break;
        }
        catch (DirectoryError e) {
            throw new ServiceUnavailableX(7, "Exception thrown by server", (Throwable)((java.lang.Object)e));
        }
    }

    /*
     * Loose catch block
     */
    Result queryUsingSmtpAddress(String smtpAddress, String[] profileProperties) throws ServiceUnavailableX, NotFound {
        Lookup lookup = null;
        int attempt = 0;
        while (true) {
            try {
                lookup = this.lookupResolver.get();
                return lookup.QueryUsingSmtpAddress(smtpAddress, profileProperties);
            }
            catch (SystemException e) {
                this.lookupResolver.error(e, ++attempt);
                continue;
            }
            break;
        }
        catch (DirectoryError e) {
            throw new ServiceUnavailableX(7, "Exception thrown by server", (Throwable)((java.lang.Object)e));
        }
    }

    /*
     * Loose catch block
     */
    Result queryUsingNtAccount(String NtAccount2, String[] profilePropertie) throws ServiceUnavailableX, NotFound {
        Lookup lookup = null;
        int attempt = 0;
        while (true) {
            try {
                lookup = this.lookupResolver.get();
                return lookup.QueryUsingNtAccount(NtAccount2, profilePropertie);
            }
            catch (SystemException e) {
                this.lookupResolver.error(e, ++attempt);
                continue;
            }
            break;
        }
        catch (DirectoryError e) {
            throw new ServiceUnavailableX(7, "Exception thrown by server", (Throwable)((java.lang.Object)e));
        }
    }

    /*
     * Loose catch block
     */
    public void changePassword(String userId, String newPassword) throws ServiceUnavailableX {
        Authentication authentication = null;
        int attempt = 0;
        while (true) {
            try {
                authentication = this.authenticationResolver.get();
                authentication.ChangePassword(userId, newPassword);
                return;
            }
            catch (SystemException e) {
                this.authenticationResolver.error(e, ++attempt);
                continue;
            }
            catch (DirectoryError e) {
                throw new ServiceUnavailableX(7, "Exception thrown by server", (Throwable)((java.lang.Object)e));
            }
            break;
        }
        catch (NotFound e) {
            throw new ServiceUnavailableX(7, "The user account is not found", (Throwable)((java.lang.Object)e));
        }
    }

    /*
     * Loose catch block
     */
    public String[] Search(String SiteId2, String[] tokens, int maxCount) throws ServiceUnavailableX {
        Lookup lookup = null;
        int attempt = 0;
        while (true) {
            try {
                lookup = this.lookupResolver.get();
                return lookup.Search(SiteId2, "SmtpAddress", tokens, maxCount);
            }
            catch (SystemException e) {
                this.lookupResolver.error(e, ++attempt);
                continue;
            }
            break;
        }
        catch (DirectoryError e) {
            throw new ServiceUnavailableX(7, "Exception thrown by server", (Throwable)((java.lang.Object)e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TraderResolver<T extends Object> {
        private String offerType;
        private Object object;

        TraderResolver(String OfferType) {
            this.offerType = OfferType;
        }

        abstract T get() throws ServiceUnavailableX;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doGet() throws ServiceUnavailableX {
            TraderResolver traderResolver = this;
            synchronized (traderResolver) {
                if (this.object != null) {
                    return this.object;
                }
            }
            Object new_ref = this.resolve();
            TraderResolver traderResolver2 = this;
            synchronized (traderResolver2) {
                this.object = new_ref;
            }
            return new_ref;
        }

        private Object resolve() throws ServiceUnavailableX {
            TradingService trader_helper = ServiceLocator.getInstance().getTrader();
            try {
                return trader_helper.QueryFirstReference(this.offerType, new TraderHelperOptions());
            }
            catch (TradingService.TradingServiceException e) {
                if ((e.Cause() & 0x10) == 16) {
                    throw new ServiceUnavailableX(7, "Object not found in Trader", e);
                }
                throw new ServiceUnavailableX(1, "Exception from Trader", e);
            }
        }

        synchronized void error(SystemException ex, int attempt) {
            this.object = null;
            if (attempt == 2) {
                throw ex;
            }
        }
    }
}

