/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.EntityHelper;

import Xm.Directories.LookupPackage.Result;
import Xm.Directories.NotFound;
import Xm.JavaUtils.EntityHelper.CompanyConfigHelper;
import Xm.JavaUtils.EntityHelper.IProfileInfo;
import Xm.JavaUtils.EntityHelper.ISiteHelper;
import Xm.JavaUtils.EntityHelper.ProfileInfo;
import Xm.JavaUtils.EntityHelper.UserDirectoriesLookupHelper;
import Xm.JavaUtils.InvalidWebAliasX;
import Xm.JavaUtils.ServiceLocator;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.JavaUtils.TradingService;
import Xm.JdInvalidPropertyX;
import Xm.JdNothingFoundX;
import Xm.JdUnreachableDataBaseX;
import Xm.SiteResolver;
import Xm.SiteResolverHelper;
import Xm.SiteResolverPackage.NonUniqueMatch;
import Xm.SiteResolverPackage.NotReady;
import Xm.SiteResolverPackage.SiteNotFound;
import Xm.TypedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public final class SiteHelper
implements ISiteHelper {
    private UserDirectoriesLookupHelper m_userDirectoriesLookupHelper;
    private Result m_lookupResult;
    private CompanyConfigHelper m_companyConfigHelper;
    private String userId;
    private short type;
    public static final short LOGIN_TYPE_SMTP = 0;
    public static final short LOGIN_TYPE_NTACCOUNT = 1;

    private SiteHelper(UserDirectoriesLookupHelper userDirectoriesLookupHelper, Result lookupResult, String userId, short type) {
        this.m_userDirectoriesLookupHelper = userDirectoriesLookupHelper;
        this.m_lookupResult = lookupResult;
        this.m_companyConfigHelper = new CompanyConfigHelper(lookupResult.SiteId);
        this.type = type;
        this.userId = userId;
    }

    public static SiteHelper createFromSmtpAddress(String smtpAddress) throws JdUnreachableDataBaseX, ServiceUnavailableX, NotFound {
        UserDirectoriesLookupHelper userLookup = new UserDirectoriesLookupHelper();
        Result result = SiteHelper.createUser(userLookup, smtpAddress, (short)0);
        return new SiteHelper(userLookup, result, smtpAddress, 0);
    }

    public static SiteHelper createFromNtAccount(String ntAccount) throws JdUnreachableDataBaseX, ServiceUnavailableX, NotFound {
        UserDirectoriesLookupHelper userLookup = new UserDirectoriesLookupHelper();
        Result result = SiteHelper.createUser(userLookup, ntAccount, (short)1);
        return new SiteHelper(userLookup, result, ntAccount, 1);
    }

    private static Result createUser(UserDirectoriesLookupHelper userLookup, String user, short type) throws NotFound, ServiceUnavailableX {
        Result result = null;
        if (type == 0) {
            result = userLookup.queryUsingSmtpAddress(user, ProfileInfo.PROFILE_PROPERTIES);
        } else if (type == 1) {
            result = userLookup.queryUsingNtAccount(user, ProfileInfo.PROFILE_PROPERTIES);
        }
        return result;
    }

    public boolean matchSiteName(String siteName) throws ServiceUnavailableX {
        try {
            return this.m_companyConfigHelper.getSiteId().equals(this.getSiteGuid(siteName));
        }
        catch (SiteNotFound e) {
            return false;
        }
        catch (NonUniqueMatch e) {
            return false;
        }
    }

    public boolean matchWebAlias(String webAlias) throws ServiceUnavailableX {
        try {
            return this.m_companyConfigHelper.getSiteId().equals(ServiceLocator.getInstance().getCompanyList().GuidFromWebAlias(webAlias));
        }
        catch (InvalidWebAliasX e) {
            return false;
        }
    }

    public String getSmtpAddress() {
        return this.m_lookupResult.SmtpAddress;
    }

    public String getSiteGuid() {
        return this.m_companyConfigHelper.getSiteId();
    }

    public CompanyConfigHelper getCompanyConfig() {
        return this.m_companyConfigHelper;
    }

    public UserDirectoriesLookupHelper getUserDirectoriesLookup() {
        return this.m_userDirectoriesLookupHelper;
    }

    public IProfileInfo getProfileInfo() throws JdUnreachableDataBaseX, ServiceUnavailableX {
        return new ProfileInfo(this.getCompanyConfig(), this.m_lookupResult);
    }

    public void reload() throws NotFound, ServiceUnavailableX {
        this.m_lookupResult = SiteHelper.createUser(this.m_userDirectoriesLookupHelper, this.userId, this.type);
    }

    public String[] getXmlGatewayHosts() throws ServiceUnavailableX {
        return this.getXmlGatewayHosts(null, null);
    }

    public String[] getXmlGatewayHosts(String jacorbProps, String principal) throws ServiceUnavailableX {
        return this.getXmlGatewayHosts(jacorbProps, principal, "XmlGatewaySink");
    }

    public String[] getXmlGatewayHosts(String jacorbProps, String principal, String offerType) throws ServiceUnavailableX {
        try {
            ServiceLocator sl = jacorbProps == null || principal == null ? ServiceLocator.getInstance() : ServiceLocator.getInstance(jacorbProps, principal);
            Object[] references = sl.getTrader().QueryAllReferences(offerType, new TraderHelperOptions("CompanyId == '" + this.getSiteGuid() + "'"));
            ORB orb = sl.getCorbaInit().getOrb();
            String[] result = new String[references.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = orb.object_to_string(references[i]);
            }
            return result;
        }
        catch (TradingService.TradingServiceException e) {
            if ((e.Cause() & 0x10) == 16) {
                return new String[0];
            }
            throw new ServiceUnavailableX(1, e.getMessage());
        }
    }

    public boolean isFaxCompositionFromWebAllowed(IProfileInfo profile) throws ServiceUnavailableX {
        boolean siteIsAllowed = ServiceLocator.getInstance().getCompanyList().isFaxCompositionFromWebAllowed(this.getSiteGuid());
        return siteIsAllowed && "true".equals(profile.getHasRightToFax());
    }

    public boolean isDelegationAllowed() throws JdInvalidPropertyX, JdNothingFoundX, JdUnreachableDataBaseX, ServiceUnavailableX {
        TypedValue[] settings = this.getCompanyConfig().getSiteSettings(new String[]{"Sites,AllowDelegation"});
        return settings.length != 0 && settings[0].boolean_value();
    }

    public String getSiteGuid(String siteName) throws ServiceUnavailableX, SiteNotFound, NonUniqueMatch {
        return SiteHelper.getSiteGuidFrom(siteName);
    }

    public static String getSiteGuidFrom(String siteName) throws ServiceUnavailableX, SiteNotFound, NonUniqueMatch {
        java.lang.Object ex = null;
        SiteResolverCache cache = SiteResolverCache.getInstance();
        for (int i = 0; i < 2; ++i) {
            SiteResolver sr = cache.getSiteResolver();
            try {
                return sr.GetSiteIdByName(siteName);
            }
            catch (SystemException e) {
                ex = e;
            }
            catch (NotReady e) {
                ex = e;
            }
            cache.error(sr);
        }
        throw new ServiceUnavailableX("", (Throwable)ex);
    }

    public String getSiteName(String siteId) throws ServiceUnavailableX, SiteNotFound {
        return SiteHelper.getSiteNameFrom(siteId);
    }

    public static String getSiteNameFrom(String siteId) throws ServiceUnavailableX, SiteNotFound {
        java.lang.Object ex = null;
        SiteResolverCache cache = SiteResolverCache.getInstance();
        for (int i = 0; i < 2; ++i) {
            SiteResolver sr = cache.getSiteResolver();
            try {
                return sr.GetSiteNameById(siteId);
            }
            catch (SystemException e) {
                ex = e;
            }
            catch (NotReady e) {
                ex = e;
            }
            cache.error(sr);
        }
        throw new ServiceUnavailableX("", (Throwable)ex);
    }

    private static class SiteResolverCache {
        private SiteResolver m_resolver = null;
        private static final SiteResolverCache sm_singleton = new SiteResolverCache();

        public static SiteResolverCache getInstance() {
            return sm_singleton;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SiteResolver getSiteResolver() throws ServiceUnavailableX {
            SiteResolverCache siteResolverCache = this;
            synchronized (siteResolverCache) {
                if (this.m_resolver != null) {
                    return this.m_resolver;
                }
            }
            SiteResolver new_ref = SiteResolverCache.resolve();
            SiteResolverCache siteResolverCache2 = this;
            synchronized (siteResolverCache2) {
                this.m_resolver = new_ref;
            }
            return new_ref;
        }

        public synchronized void error(SiteResolver resolver) {
            if (this.m_resolver == resolver) {
                this.m_resolver = null;
            }
        }

        private SiteResolverCache() {
        }

        private static SiteResolver resolve() throws ServiceUnavailableX {
            try {
                TradingService trader = ServiceLocator.getInstance().getTrader();
                Object obj = trader.QueryFirstReference("SiteResolver", new TraderHelperOptions());
                return SiteResolverHelper.narrow(obj);
            }
            catch (TradingService.TradingServiceException e) {
                if ((e.Cause() & 0x10) == 16) {
                    throw new ServiceUnavailableX(3);
                }
                throw new ServiceUnavailableX(1, e.getMessage());
            }
        }
    }
}

