/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.EntityHelper;

import Xm.Directories.LookupPackage.Result;
import Xm.Directories.LookupPackage.SenderInformation;
import Xm.JavaUtils.EntityHelper.BillingCodeInfo;
import Xm.JavaUtils.EntityHelper.CompanyConfigHelper;
import Xm.JavaUtils.EntityHelper.CoverSheetInfo;
import Xm.JavaUtils.EntityHelper.IBillingCodeInfo;
import Xm.JavaUtils.EntityHelper.ICoverSheetInfo;
import Xm.JavaUtils.EntityHelper.IPhonebookInfo;
import Xm.JavaUtils.EntityHelper.IProfileInfo;
import Xm.JavaUtils.EntityHelper.PhonebookInfo;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.JdInvalidPropertyX;
import Xm.JdNothingFoundX;
import Xm.JdUnreachableDataBaseX;
import Xm.Records;
import Xm.TypedValue;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProfileInfo
implements IProfileInfo {
    public static final String[] PROFILE_PROPERTIES = new String[]{"RightToFax", "Profiles,XmlSinkRequiresPassword", "Profiles,XmlPollRequiresPassword", "Profiles,SmtpRequiresPassword", "Profiles,SenderInformationOverwritePolicy", "Profiles,FaxOptionsOverwritePolicy", "FaxSendPriority", "FaxSendPriorityMax", "FaxSendRetries", "FaxSendRetriesMax", "FaxSendResolution", "FaxSendResolutionMax", "NotifOpt,NotifyOnSuccess", "NotifOpt,NotifyOnFailure", "UseBody", "Csid", "FaxHeader", "UserMayAttachCoversheet", "UserMustUseCoverSheet", "DefaultCoverSheet", "DefaultCoverSheetUrl", "SenderBillingCodeRequired", "SenderBillingCodeEnforced", "SenderBillingCodeDisclose", "RecipientBillingCodeRequired", "RecipientBillingCodeEnforced", "Company,TiffEncoding", "NotifOpt,NotifyOnBroadcast"};
    private static final String[] COVERSHEET_PROPERTIES = new String[]{"Name", "File ID"};
    private static final String[] PHONEBOOK_PROPERTIES = new String[]{"Id"};
    private static final String[] BILLINGCODE_PROPERTIES = new String[]{"BillingCode", "SubBillingCode"};
    private String m_SmtpAddress;
    private String m_ProfileId;
    private String m_SenderSalutation;
    private String m_SenderFirstName;
    private String m_SenderLastName;
    private String m_SenderJobTitle;
    private String m_SenderCompany;
    private String m_SenderAddress;
    private String m_SenderCity;
    private String m_SenderState;
    private String m_SenderCountry;
    private String m_SenderZipCode;
    private String m_SenderPhone;
    private String m_SenderFax;
    private String m_SenderCellular;
    private String m_SenderPager;
    private String m_SenderEmail;
    private String m_SenderBillingCode;
    private String m_SenderSubBillingCode;
    private String m_RightToFax;
    private String m_XmlSinkRequiresPassword;
    private String m_XmlPollRequiresPassword;
    private String m_SmtpRequiresPassword;
    private String m_SenderInformationOverwritePolicy;
    private String m_FaxOptionsOverwritePolicy;
    private String m_FaxSendPriority;
    private String m_FaxSendPriorityMax;
    private String m_FaxSendRetries;
    private String m_FaxSendRetriesMax;
    private String m_FaxSendResolution;
    private String m_FaxSendResolutionMax;
    private String m_NotifyOnSuccess;
    private String m_NotifyOnFailure;
    private String m_NotifyOnBroadcast;
    private String m_UseBody;
    private String m_Csid;
    private String m_FaxHeader;
    private String m_UserMayAttachCoverSheet;
    private String m_UserMustUseCoverSheet;
    private String m_DefaultCoverSheet;
    private String m_DefaultCoverSheetUrl;
    private String m_SenderCodeRequired;
    private String m_SenderCodeEnforced;
    private String m_SenderCodeDisclose;
    private String m_RecipientCodeRequired;
    private String m_RecipientCodeEnforced;
    private String m_TiffEncoding;
    private Collection<ICoverSheetInfo> m_CoverSheets;
    private Collection<IPhonebookInfo> m_Phonebooks;
    private Collection<IBillingCodeInfo> m_RecipientBillingCodes;
    private Collection<IBillingCodeInfo> m_SenderBillingCodes;

    ProfileInfo(CompanyConfigHelper companyConfig, Result lookupResult) throws JdUnreachableDataBaseX, ServiceUnavailableX {
        this.m_SmtpAddress = lookupResult.SmtpAddress;
        this.m_ProfileId = lookupResult.ProfileId;
        this.populateSenderInfoFields(lookupResult.SenderInfo);
        this.populateProfileFields(lookupResult.ProfileInfo);
        try {
            this.populateProfileCoverSheets(companyConfig);
            this.populatePhonebooks(companyConfig);
            this.populateProfileBillingCodes(companyConfig);
        }
        catch (JdInvalidPropertyX e) {
            System.err.println("JdInvalidPropertyX for property: " + e.Property);
            e.printStackTrace();
            IllegalArgumentException e2 = new IllegalArgumentException();
            e2.initCause((Throwable)((Object)e));
            throw e2;
        }
    }

    private void populateSenderInfoFields(SenderInformation senderInfo) {
        this.m_SenderSalutation = senderInfo.Salutation;
        this.m_SenderFirstName = senderInfo.FirstName;
        this.m_SenderLastName = senderInfo.LastName;
        this.m_SenderJobTitle = senderInfo.JobTitle;
        this.m_SenderCompany = senderInfo.Company;
        this.m_SenderAddress = senderInfo.Address;
        this.m_SenderCity = senderInfo.City;
        this.m_SenderState = senderInfo.State;
        this.m_SenderCountry = senderInfo.Country;
        this.m_SenderZipCode = senderInfo.ZipCode;
        this.m_SenderPhone = senderInfo.Phone;
        this.m_SenderFax = senderInfo.Fax;
        this.m_SenderCellular = senderInfo.Cellular;
        this.m_SenderPager = senderInfo.Pager;
        this.m_SenderEmail = senderInfo.Email;
        this.m_SenderBillingCode = senderInfo.BillingCode;
        this.m_SenderSubBillingCode = senderInfo.SubBillingCode;
    }

    private void populateProfileFields(TypedValue[] profileValues) {
        int i = 0;
        this.m_RightToFax = this.typedValueToString(profileValues[i++]);
        this.m_XmlSinkRequiresPassword = this.typedValueToString(profileValues[i++]);
        this.m_XmlPollRequiresPassword = this.typedValueToString(profileValues[i++]);
        this.m_SmtpRequiresPassword = this.typedValueToString(profileValues[i++]);
        this.m_SenderInformationOverwritePolicy = this.typedValueToString(profileValues[i++]);
        this.m_FaxOptionsOverwritePolicy = this.typedValueToString(profileValues[i++]);
        this.m_FaxSendPriority = this.typedValueToString(profileValues[i++]);
        this.m_FaxSendPriorityMax = this.typedValueToString(profileValues[i++]);
        this.m_FaxSendRetries = this.typedValueToString(profileValues[i++]);
        this.m_FaxSendRetriesMax = this.typedValueToString(profileValues[i++]);
        this.m_FaxSendResolution = this.typedValueToString(profileValues[i++]);
        this.m_FaxSendResolutionMax = this.typedValueToString(profileValues[i++]);
        this.m_NotifyOnSuccess = this.typedValueToString(profileValues[i++]);
        this.m_NotifyOnFailure = this.typedValueToString(profileValues[i++]);
        this.m_UseBody = this.typedValueToString(profileValues[i++]);
        this.m_Csid = this.typedValueToString(profileValues[i++]);
        this.m_FaxHeader = this.typedValueToString(profileValues[i++]);
        this.m_UserMayAttachCoverSheet = this.typedValueToString(profileValues[i++]);
        this.m_UserMustUseCoverSheet = this.typedValueToString(profileValues[i++]);
        this.m_DefaultCoverSheet = this.typedValueToString(profileValues[i++]);
        this.m_DefaultCoverSheetUrl = this.typedValueToString(profileValues[i++]);
        this.m_SenderCodeRequired = this.typedValueToString(profileValues[i++]);
        this.m_SenderCodeEnforced = this.typedValueToString(profileValues[i++]);
        this.m_SenderCodeDisclose = this.typedValueToString(profileValues[i++]);
        this.m_RecipientCodeRequired = this.typedValueToString(profileValues[i++]);
        this.m_RecipientCodeEnforced = this.typedValueToString(profileValues[i++]);
        this.m_TiffEncoding = this.typedValueToString(profileValues[i++]);
        this.m_NotifyOnBroadcast = this.typedValueToString(profileValues[i++]);
    }

    private String typedValueToString(TypedValue value) {
        switch (value.discriminator().value()) {
            case 2: {
                return value.wstring_value();
            }
            case 3: {
                return value.boolean_value() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            }
            case 1: {
                return Integer.toString(value.long_value());
            }
        }
        throw new IllegalArgumentException("TypedValue type not supported in typedValueToString(): " + value.discriminator().value());
    }

    private void populateProfileCoverSheets(CompanyConfigHelper companyConfig) throws JdUnreachableDataBaseX, JdInvalidPropertyX, ServiceUnavailableX {
        if (this.m_ProfileId == null) {
            throw new IllegalStateException("profileId was not set before call to populateProfileCoverSheets()");
        }
        this.m_CoverSheets = new ArrayList<ICoverSheetInfo>();
        try {
            Records list = companyConfig.getProfileCoverSheets(this.m_ProfileId, COVERSHEET_PROPERTIES);
            int count = list.Columns[0].wstring_column().length;
            for (int i = 0; i < count; ++i) {
                this.m_CoverSheets.add(new CoverSheetInfo(list.Columns[0].wstring_column()[i], list.Columns[1].wstring_column()[i]));
            }
        }
        catch (JdNothingFoundX jdNothingFoundX) {
            // empty catch block
        }
    }

    private void populatePhonebooks(CompanyConfigHelper companyConfig) throws JdUnreachableDataBaseX, JdInvalidPropertyX, ServiceUnavailableX {
        if (this.m_ProfileId == null) {
            throw new IllegalStateException("profileId was not set before call to populateProfileCoverSheets()");
        }
        this.m_Phonebooks = new ArrayList<IPhonebookInfo>();
        try {
            Records list = companyConfig.getProfilePhonebooks(this.m_ProfileId, PHONEBOOK_PROPERTIES);
            int count = list.Columns[0].wstring_column().length;
            for (int i = 0; i < count; ++i) {
                this.m_Phonebooks.add(new PhonebookInfo(list.Columns[0].wstring_column()[i]));
            }
        }
        catch (JdNothingFoundX jdNothingFoundX) {
            // empty catch block
        }
    }

    private void populateProfileBillingCodes(CompanyConfigHelper companyConfig) throws JdUnreachableDataBaseX, JdInvalidPropertyX, ServiceUnavailableX {
        int i;
        int count;
        Records list;
        if (this.m_ProfileId == null) {
            throw new IllegalStateException("profileId was not set before call to populateProfileBillingCodes()");
        }
        this.m_SenderBillingCodes = new ArrayList<IBillingCodeInfo>();
        this.m_RecipientBillingCodes = new ArrayList<IBillingCodeInfo>();
        try {
            list = companyConfig.getSenderBillingCodes(this.m_ProfileId, BILLINGCODE_PROPERTIES);
            count = list.Columns[0].wstring_column().length;
            for (i = 0; i < count; ++i) {
                this.m_SenderBillingCodes.add(new BillingCodeInfo(list.Columns[0].wstring_column()[i], list.Columns[1].wstring_column()[i]));
            }
        }
        catch (JdNothingFoundX e) {
            // empty catch block
        }
        try {
            list = companyConfig.getRecipientBillingCodes(this.m_ProfileId, BILLINGCODE_PROPERTIES);
            count = list.Columns[0].wstring_column().length;
            for (i = 0; i < count; ++i) {
                this.m_RecipientBillingCodes.add(new BillingCodeInfo(list.Columns[0].wstring_column()[i], list.Columns[1].wstring_column()[i]));
            }
        }
        catch (JdNothingFoundX jdNothingFoundX) {
            // empty catch block
        }
    }

    @Override
    public String getSmtpAddress() {
        return this.m_SmtpAddress;
    }

    @Override
    public String getProfileId() {
        return this.m_ProfileId;
    }

    @Override
    public String getHasRightToFax() {
        return this.m_RightToFax;
    }

    @Override
    public String getUseProfileCompanySettings() {
        return Boolean.TRUE.toString();
    }

    @Override
    public String getUseProfilePhoneSettings() {
        return Boolean.TRUE.toString();
    }

    @Override
    public String getSenderInformationOverwritePolicy() {
        return this.m_SenderInformationOverwritePolicy;
    }

    @Override
    public String getFaxOptionsOverwritePolicy() {
        return this.m_FaxOptionsOverwritePolicy;
    }

    @Override
    public String getSenderCompany() {
        return this.m_SenderCompany;
    }

    @Override
    public String getSenderAddress() {
        return this.m_SenderAddress;
    }

    @Override
    public String getSenderCity() {
        return this.m_SenderCity;
    }

    @Override
    public String getSenderState() {
        return this.m_SenderState;
    }

    @Override
    public String getSenderCountry() {
        return this.m_SenderCountry;
    }

    @Override
    public String getSenderZipCode() {
        return this.m_SenderZipCode;
    }

    @Override
    public String getSenderPhone() {
        return this.m_SenderPhone;
    }

    @Override
    public String getSenderFax() {
        return this.m_SenderFax;
    }

    @Override
    public String getFaxSendPriority() {
        return this.m_FaxSendPriority;
    }

    @Override
    public String getFaxSendRetries() {
        return this.m_FaxSendRetries;
    }

    @Override
    public String getFaxSendResolution() {
        return this.m_FaxSendResolution;
    }

    @Override
    public String getNotifyOnSuccess() {
        return this.m_NotifyOnSuccess;
    }

    @Override
    public String getNotifyOnFailed() {
        return this.m_NotifyOnFailure;
    }

    @Override
    public String getNotifyOnBroadcast() {
        return this.m_NotifyOnBroadcast;
    }

    @Override
    public String getUseBody() {
        return this.m_UseBody;
    }

    @Override
    public String getCsid() {
        return this.m_Csid;
    }

    @Override
    public String getFaxHeader() {
        return this.m_FaxHeader;
    }

    @Override
    public String getRequiresPassword() {
        return this.getXmlSinkRequiresPassword();
    }

    @Override
    public String getUserMayAttachCoverSheet() {
        return this.m_UserMayAttachCoverSheet;
    }

    @Override
    public String getUserMustUseCoverSheet() {
        return this.m_UserMustUseCoverSheet;
    }

    @Override
    public String getDefaultCoverSheetName() {
        return this.m_DefaultCoverSheet;
    }

    @Override
    public String getDefaultCoverSheetUrl() {
        return this.m_DefaultCoverSheetUrl;
    }

    @Override
    public String getSenderBillingCodeRequired() {
        return this.m_SenderCodeRequired;
    }

    @Override
    public String getSenderBillingCodeEnforced() {
        return this.m_SenderCodeEnforced;
    }

    @Override
    public String getSenderBillingCodeDisclose() {
        return this.m_SenderCodeDisclose;
    }

    @Override
    public String getRecipientBillingCodeRequired() {
        return this.m_RecipientCodeRequired;
    }

    @Override
    public String getRecipientBillingCodeEnforced() {
        return this.m_RecipientCodeEnforced;
    }

    @Override
    public String getFaxSendPriorityMax() {
        return this.m_FaxSendPriorityMax;
    }

    @Override
    public String getFaxSendRetriesMax() {
        return this.m_FaxSendRetriesMax;
    }

    @Override
    public String getFaxSendResolutionMax() {
        return this.m_FaxSendResolutionMax;
    }

    @Override
    public String getTiffEncoding() {
        return this.m_TiffEncoding;
    }

    @Override
    public Collection<ICoverSheetInfo> getCoverSheets() {
        return this.m_CoverSheets;
    }

    @Override
    public Collection<IPhonebookInfo> getPhonebooks() {
        return this.m_Phonebooks;
    }

    @Override
    public Collection<IBillingCodeInfo> getRecipientBillingCodes() {
        return this.m_RecipientBillingCodes;
    }

    @Override
    public Collection<IBillingCodeInfo> getSenderBillingCodes() {
        return this.m_SenderBillingCodes;
    }

    @Override
    public String getUserMayOverwriteSenderInfo() {
        if (this.m_SenderInformationOverwritePolicy.equalsIgnoreCase("allow")) {
            return "true";
        }
        return "false";
    }

    @Override
    public String getUserMayOverwriteFaxOptions() {
        if (this.m_FaxOptionsOverwritePolicy.equalsIgnoreCase("allow")) {
            return "true";
        }
        return "false";
    }

    @Override
    public String getSmtpRequiresPassword() {
        return this.m_SmtpRequiresPassword;
    }

    @Override
    public String getXmlPollRequiresPassword() {
        return this.m_XmlPollRequiresPassword;
    }

    @Override
    public String getXmlSinkRequiresPassword() {
        return this.m_XmlSinkRequiresPassword;
    }

    @Override
    public String getSenderSalutation() {
        return this.m_SenderSalutation;
    }

    @Override
    public String getSenderFirstName() {
        return this.m_SenderFirstName;
    }

    @Override
    public String getSenderLastName() {
        return this.m_SenderLastName;
    }

    @Override
    public String getSenderTitle() {
        return this.m_SenderJobTitle;
    }

    @Override
    public String getSenderCellular() {
        return this.m_SenderCellular;
    }

    @Override
    public String getSenderPager() {
        return this.m_SenderPager;
    }

    @Override
    public String getSenderEmail() {
        return this.m_SenderEmail;
    }

    @Override
    public String getSenderBillingCodeCode() {
        return this.m_SenderBillingCode;
    }

    @Override
    public String getSenderBillingCodeSubCode() {
        return this.m_SenderSubBillingCode;
    }
}

