/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.EntityHelper;

import Xm.Config;
import Xm.ConfigHelper;
import Xm.InvalidPropertiesX;
import Xm.JavaUtils.EntityHelper.SiteConfig;
import Xm.JavaUtils.InvalidWebAliasX;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.JavaUtils.TradingService;
import Xm.List;
import Xm.ListNotif;
import Xm.ListNotifier;
import Xm.ListNotifierHelper;
import Xm.ListNotifierPOA;
import Xm.Records;
import Xm.StorageException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyListHelper
extends ListNotifierPOA {
    private Map<String, String> m_WebAliasGuidMap;
    private Map<String, SiteConfig> m_GuidSiteConfigMap;
    private boolean m_IsMapUpToDate;
    private List m_CompanyListInterface = null;
    private TradingService m_Trading;
    private int m_RegistrationId;
    private boolean m_IsRegistered;
    private POA m_Poa;
    private boolean m_IsServantActivated;

    public CompanyListHelper(TradingService Trader2) {
        this.m_Trading = Trader2;
        this.m_IsRegistered = false;
        this.m_Poa = null;
        this.m_IsServantActivated = false;
        this.m_WebAliasGuidMap = null;
        this.m_GuidSiteConfigMap = null;
        this.m_IsMapUpToDate = false;
    }

    public void finalize() {
        try {
            if (this.m_IsRegistered) {
                this.UnregisterNotifier(this.m_RegistrationId, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String GuidFromWebAlias(String WebAlias2) throws InvalidWebAliasX, ServiceUnavailableX {
        this.UpdateMap();
        String guid = this.m_WebAliasGuidMap.get(WebAlias2.toLowerCase());
        if (guid == null) {
            throw new InvalidWebAliasX(WebAlias2);
        }
        return guid;
    }

    public boolean DoesCompanyAliasExist(String WebAlias2) throws ServiceUnavailableX {
        this.UpdateMap();
        return this.m_WebAliasGuidMap.containsKey(WebAlias2.toLowerCase());
    }

    public boolean isFaxCompositionFromWebAllowed(String siteGuid) throws ServiceUnavailableX {
        this.UpdateMap();
        SiteConfig config = this.m_GuidSiteConfigMap.get(siteGuid);
        return config != null && config.allowFaxFromWeb;
    }

    public int getNbCompany() throws ServiceUnavailableX {
        this.UpdateMap();
        return this.m_GuidSiteConfigMap.values().size();
    }

    public String GetCompanyListOptions() throws ServiceUnavailableX {
        StringBuffer result = new StringBuffer();
        this.UpdateMap();
        for (SiteConfig config : this.m_GuidSiteConfigMap.values()) {
            result.append("<option value='");
            result.append(config.webAlias);
            result.append("'>");
            result.append(config.displayName);
            result.append("</option>\n");
        }
        System.out.println("CompanyListHelper#GetCompanyList() = " + result.toString());
        return result.toString();
    }

    public Collection<SiteConfig> getCompanyList() throws ServiceUnavailableX {
        this.UpdateMap();
        return this.m_GuidSiteConfigMap.values();
    }

    @Override
    public void TransmitNotification(ListNotif Notification, long SeqNumber) {
        this.m_IsMapUpToDate = false;
    }

    public boolean Register() throws ServiceUnavailableX {
        if (this.m_IsRegistered) {
            return true;
        }
        try {
            this.UpdateReference();
            ListNotifier this_instance = ListNotifierHelper.narrow(this.m_Poa.servant_to_reference((Servant)this));
            this.m_RegistrationId = this.m_CompanyListInterface.RegisterNotifier(this_instance);
            System.out.println("Notifier registered with ConfigManager.");
            this.m_IsRegistered = true;
        }
        catch (UserException e) {
            System.out.println("Register - UserException: " + e.getMessage());
            this.m_CompanyListInterface = null;
        }
        return this.m_IsRegistered;
    }

    public void ActivateServant(ORB Orb, POA Poa) throws ServantAlreadyActive, WrongPolicy {
        if (this.m_IsServantActivated) {
            return;
        }
        this.m_Poa = Poa;
        this.m_Poa.activate_object((Servant)this);
        this.m_IsServantActivated = true;
    }

    private synchronized void UpdateMap() throws ServiceUnavailableX {
        if (this.m_IsMapUpToDate) {
            return;
        }
        HashMap<String, String> alias_guid_map = new HashMap<String, String>();
        HashMap<String, SiteConfig> guid_site_config_map = new HashMap<String, SiteConfig>();
        String[] property_seq = new String[]{"Web Alias", "Guid", "Display Name", "Allow Fax From Web"};
        try {
            Records records = this.GetAllRecords(property_seq);
            int row_count = records.Columns.length == 0 ? 0 : records.Columns[0].wstring_column().length;
            for (int index = 0; index < row_count; ++index) {
                SiteConfig config = new SiteConfig();
                config.webAlias = records.Columns[0].wstring_column()[index].toLowerCase();
                config.siteGuid = records.Columns[1].wstring_column()[index];
                config.displayName = records.Columns[2].wstring_column()[index];
                config.allowFaxFromWeb = records.Columns[3].boolean_column()[index];
                alias_guid_map.put(config.webAlias, config.siteGuid);
                guid_site_config_map.put(config.siteGuid, config);
            }
            this.m_WebAliasGuidMap = alias_guid_map;
            this.m_GuidSiteConfigMap = guid_site_config_map;
            this.m_IsMapUpToDate = true;
        }
        catch (StorageException e) {
            throw new ServiceUnavailableX(5);
        }
        catch (InvalidPropertiesX e) {
            throw new ServiceUnavailableX(5);
        }
    }

    private void UpdateReference() throws ServiceUnavailableX {
        if (this.m_CompanyListInterface == null) {
            String constraint = "Type == 'Companies'";
            try {
                Config config_manager = ConfigHelper.narrow(this.m_Trading.QueryFirstReference("Config", new TraderHelperOptions(constraint)));
                this.m_CompanyListInterface = config_manager.GetListInterface("Company List");
            }
            catch (TradingService.TradingServiceException e) {
                if ((e.Cause() & 0x10) == 16) {
                    throw new ServiceUnavailableX(5);
                }
                throw new ServiceUnavailableX(1, e.getMessage());
            }
            if (this.m_CompanyListInterface == null) {
                throw new ServiceUnavailableX(5);
            }
        }
    }

    private Records GetAllRecords(String[] PropertySeq) throws StorageException, InvalidPropertiesX, ServiceUnavailableX {
        for (int i = 0; i < 2; ++i) {
            this.UpdateReference();
            try {
                return this.m_CompanyListInterface.GetAllRecords(PropertySeq);
            }
            catch (TRANSIENT e) {
            }
            catch (COMM_FAILURE e) {
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                // empty catch block
            }
            this.m_CompanyListInterface = null;
        }
        throw new ServiceUnavailableX(5);
    }

    private void UnregisterNotifier(int RegId, boolean ThrowIfUnavailable) throws ServiceUnavailableX {
        for (int i = 0; i < 2; ++i) {
            this.UpdateReference();
            try {
                this.m_CompanyListInterface.UnregisterNotifier(RegId);
                return;
            }
            catch (TRANSIENT e) {
            }
            catch (COMM_FAILURE e) {
            }
            catch (OBJECT_NOT_EXIST e) {
            }
            catch (StorageException e) {
                // empty catch block
            }
            this.m_CompanyListInterface = null;
        }
        if (ThrowIfUnavailable) {
            throw new ServiceUnavailableX(5);
        }
    }
}

