/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.EntityHelper;

import Xm.CoConfigEro;
import Xm.CoConfigEroHelper;
import Xm.Config;
import Xm.ConfigHelper;
import Xm.InvalidPropertiesX;
import Xm.JavaUtils.ServiceLocator;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.JavaUtils.TradingService;
import Xm.JdInvalidFilterX;
import Xm.JdInvalidFolderX;
import Xm.JdInvalidPropertyX;
import Xm.JdNothingFoundX;
import Xm.JdUnreachableDataBaseX;
import Xm.List;
import Xm.Records;
import Xm.StorageException;
import Xm.TypedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class CompanyConfigHelper {
    private String m_SiteId;
    private volatile CoConfigEro m_CoConfigEro;
    private volatile List m_ProfileList;

    public CompanyConfigHelper(String siteId) {
        this.m_SiteId = siteId;
    }

    String getSiteId() {
        return this.m_SiteId;
    }

    public TypedValue[] getSiteSettings(String[] requestedProperties) throws JdInvalidPropertyX, JdNothingFoundX, JdUnreachableDataBaseX, ServiceUnavailableX {
        try {
            return this.coConfigEro(CacheOption.USE_CACHE).GetSiteSettings(this.m_SiteId, requestedProperties);
        }
        catch (SystemException ex) {
            try {
                return this.coConfigEro(CacheOption.RENEW).GetSiteSettings(this.m_SiteId, requestedProperties);
            }
            catch (SystemException ex2) {
                throw new ServiceUnavailableX(3, ex2.getMessage());
            }
        }
    }

    public Records getProfileCoverSheets(String profileStringifiedId, String[] requestedProperties) throws JdInvalidPropertyX, JdNothingFoundX, JdUnreachableDataBaseX, ServiceUnavailableX {
        try {
            return this.coConfigEro(CacheOption.USE_CACHE).GetProfileCoverSheets(this.m_SiteId, profileStringifiedId, requestedProperties);
        }
        catch (SystemException ex) {
            try {
                return this.coConfigEro(CacheOption.RENEW).GetProfileCoverSheets(this.m_SiteId, profileStringifiedId, requestedProperties);
            }
            catch (SystemException ex2) {
                throw new ServiceUnavailableX(3, ex2.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Records getProfilePhonebooks(String profileStringifiedId, String[] requestedProperties) throws JdInvalidPropertyX, JdNothingFoundX, JdUnreachableDataBaseX, ServiceUnavailableX {
        long recordId = Long.parseLong(profileStringifiedId);
        try {
            try {
                return this.profileList(CacheOption.USE_CACHE).GetListInterface(recordId, "List_Phonebooks").GetAllRecords(requestedProperties);
            }
            catch (SystemException ex) {
                try {
                    return this.profileList(CacheOption.RENEW).GetListInterface(recordId, "List_Phonebooks").GetAllRecords(requestedProperties);
                }
                catch (SystemException ex2) {
                    throw new ServiceUnavailableX(3, ex2.getMessage());
                }
            }
        }
        catch (InvalidPropertiesX ex) {
            throw new JdInvalidPropertyX();
        }
        catch (StorageException ex) {
            throw new ServiceUnavailableX(3, ex.getMessage());
        }
    }

    public Records getSenderBillingCodes(String profileStringifiedId, String[] requestedProperties) throws JdInvalidPropertyX, JdNothingFoundX, JdUnreachableDataBaseX, ServiceUnavailableX {
        try {
            return this.coConfigEro(CacheOption.USE_CACHE).GetSenderBillingCodes(this.m_SiteId, profileStringifiedId, requestedProperties);
        }
        catch (SystemException ex) {
            try {
                return this.coConfigEro(CacheOption.RENEW).GetSenderBillingCodes(this.m_SiteId, profileStringifiedId, requestedProperties);
            }
            catch (SystemException ex2) {
                throw new ServiceUnavailableX(3, ex2.getMessage());
            }
        }
    }

    public Records getRecipientBillingCodes(String profileStringifiedId, String[] requestedProperties) throws JdInvalidPropertyX, JdNothingFoundX, JdUnreachableDataBaseX, ServiceUnavailableX {
        try {
            return this.coConfigEro(CacheOption.USE_CACHE).GetRecipientBillingCodes(this.m_SiteId, profileStringifiedId, requestedProperties);
        }
        catch (SystemException ex) {
            try {
                return this.coConfigEro(CacheOption.RENEW).GetRecipientBillingCodes(this.m_SiteId, profileStringifiedId, requestedProperties);
            }
            catch (SystemException ex2) {
                throw new ServiceUnavailableX(3, ex2.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Records getDestinations(String destinationType, String[] tokens, int maxCount) throws ServiceUnavailableX {
        try {
            try {
                return this.coConfigEro(CacheOption.USE_CACHE).GetDestinations(this.m_SiteId, destinationType, tokens, maxCount, true);
            }
            catch (SystemException ex) {
                try {
                    return this.coConfigEro(CacheOption.RENEW).GetDestinations(this.m_SiteId, destinationType, tokens, maxCount, true);
                }
                catch (SystemException ex2) {
                    throw new ServiceUnavailableX(3, ex2.getMessage());
                }
            }
        }
        catch (JdUnreachableDataBaseX ex) {
            throw new ServiceUnavailableX(3, ex.getMessage());
        }
        catch (JdInvalidFilterX ex) {
            throw new ServiceUnavailableX(3, ex.getMessage());
        }
        catch (JdInvalidFolderX ex) {
            throw new ServiceUnavailableX(3, ex.getMessage());
        }
    }

    private CoConfigEro coConfigEro(CacheOption option) throws ServiceUnavailableX {
        if (this.m_CoConfigEro == null || option == CacheOption.RENEW) {
            this.m_CoConfigEro = this.resolveCoConfigEro();
        }
        return this.m_CoConfigEro;
    }

    private CoConfigEro resolveCoConfigEro() throws ServiceUnavailableX {
        block3: {
            try {
                TradingService trader_helper = ServiceLocator.getInstance().getTrader();
                Object obj = trader_helper.QueryFirstReference("CompanyConfigEffectiveReadOnlyGroup", new TraderHelperOptions());
                CoConfigEro resolved = CoConfigEroHelper.narrow(obj);
                if (resolved != null) {
                    return resolved;
                }
            }
            catch (TradingService.TradingServiceException ex) {
                if ((ex.Cause() & 0x10) == 16) break block3;
                throw new ServiceUnavailableX(1, ex.getMessage());
            }
        }
        throw new ServiceUnavailableX(3);
    }

    private List profileList(CacheOption option) throws ServiceUnavailableX {
        if (this.m_ProfileList == null || option == CacheOption.RENEW) {
            this.m_ProfileList = this.resolveProfileList();
        }
        return this.m_ProfileList;
    }

    private List resolveProfileList() throws ServiceUnavailableX {
        block3: {
            StringBuffer constraint = new StringBuffer();
            constraint.append("Type");
            constraint.append(" == '");
            constraint.append("Company Profiles");
            constraint.append("' and ");
            constraint.append("Guid");
            constraint.append(" == '");
            constraint.append(this.m_SiteId);
            constraint.append("'");
            try {
                TradingService trader_helper = ServiceLocator.getInstance().getTrader();
                Object obj = trader_helper.QueryFirstReference("Config", new TraderHelperOptions(constraint.toString()));
                Config config = ConfigHelper.narrow(obj);
                if (config != null) {
                    return config.GetPrimaryList();
                }
            }
            catch (TradingService.TradingServiceException ex) {
                if ((ex.Cause() & 0x10) == 16) break block3;
                throw new ServiceUnavailableX(1, ex.getMessage());
            }
        }
        throw new ServiceUnavailableX(5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheOption {
        USE_CACHE,
        RENEW;

    }
}

