/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.NullValue;
import Xm.JavaUtils.Database.UpdateStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateStatementBuilder {
    private String m_table;
    private List<String> m_columns;
    private List<Object> m_values;
    private IFilterElement m_whereClauses = null;
    private Map<String, Object> m_properties;

    public UpdateStatementBuilder() {
        this.m_columns = new ArrayList<String>();
        this.m_values = new ArrayList<Object>();
        this.m_properties = new HashMap<String, Object>();
    }

    public UpdateStatementBuilder(UpdateStatement statement) {
        this.m_table = statement.table();
        this.m_columns = statement.columns();
        this.m_values = statement.values();
        this.m_whereClauses = statement.getFilter();
        this.m_properties = statement.cloneProperties();
    }

    public void applyProperties(Map<String, Object> properties) {
        this.m_properties.putAll(properties);
    }

    public void clearValues() {
        this.m_columns.clear();
        this.m_values.clear();
    }

    public void table(String table) {
        this.m_table = table;
    }

    public void addValue(String column, int value) {
        this.m_columns.add(column);
        this.m_values.add(new Integer(value));
    }

    public void addValue(String column, long value) {
        this.m_columns.add(column);
        this.m_values.add(new Long(value));
    }

    public void addValue(String column, boolean value) {
        this.m_columns.add(column);
        this.m_values.add(new Boolean(value));
    }

    public void addValue(String column, String value) {
        if (value == null) {
            this.addNullValue(column);
        } else {
            this.m_columns.add(column);
            this.m_values.add(value);
        }
    }

    public void addNullValue(String column) {
        this.m_columns.add(column);
        this.m_values.add(NullValue.getInstance());
    }

    public void addValue(String column, Object value) {
        if (value == null) {
            this.addNullValue(column);
        } else {
            this.m_columns.add(column);
            this.m_values.add(value);
        }
    }

    public void eraseValue(String column) {
        int index = 0;
        Iterator<String> iter = this.m_columns.iterator();
        while (iter.hasNext()) {
            if (iter.next().equalsIgnoreCase(column)) {
                iter.remove();
                this.m_values.remove(index);
            }
            ++index;
        }
    }

    public void setFilter(IFilterElement filter) {
        this.m_whereClauses = filter;
    }

    public UpdateStatement build() {
        return new UpdateStatement(this.m_table, this.m_columns, this.m_values, this.m_whereClauses, this.m_properties);
    }

    public List<Object> getValues() {
        return this.m_values;
    }

    public IFilterElement getFilter() {
        return this.m_whereClauses;
    }
}

