/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbConnectionFactory;
import Xm.JavaUtils.Database.SqlStatementTransform;
import Xm.JavaUtils.Database.TransformDbConnection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class TransformDbConnectionFactory
implements DbConnectionFactory {
    private DbConnectionFactory m_factory;
    private List<SqlStatementTransform> m_transformers = new LinkedList<SqlStatementTransform>();

    public TransformDbConnectionFactory(DbConnectionFactory factory, SqlStatementTransform ... transformers) {
        this.m_factory = factory;
        for (SqlStatementTransform transform : transformers) {
            this.m_transformers.add(transform);
        }
    }

    public DbConnection create() throws SQLException, DbConnectException {
        return new TransformDbConnection(this.m_factory.create(), this.m_transformers.toArray(new SqlStatementTransform[0]));
    }

    public void add(SqlStatementTransform tranform) {
        this.m_transformers.add(tranform);
    }
}

