/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.ColumnDefinition;
import Xm.JavaUtils.Database.ForeignKeyDefinition;
import Xm.JavaUtils.Database.FullTextDefinition;
import Xm.JavaUtils.Database.IndexDefinition;
import Xm.JavaUtils.Database.UniqueDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinition {
    private String m_name;
    private String m_likeTable;
    private List<String> m_primaryKeys;
    private List<ColumnDefinition> m_columns;
    private List<ForeignKeyDefinition> m_foreignKeys;
    private List<IndexDefinition> m_indexes;
    private List<UniqueDefinition> m_uniques;
    private List<FullTextDefinition> fullTexts;
    private Map<String, ColumnDefinition> columnDefinitions;
    private String engine = null;

    public TableDefinition(String name) {
        this.m_name = name;
        this.m_likeTable = new String();
        this.m_primaryKeys = new ArrayList<String>();
        this.m_columns = new ArrayList<ColumnDefinition>();
        this.m_foreignKeys = new ArrayList<ForeignKeyDefinition>();
        this.m_indexes = new ArrayList<IndexDefinition>();
        this.m_uniques = new ArrayList<UniqueDefinition>();
        this.fullTexts = new ArrayList<FullTextDefinition>();
        this.columnDefinitions = new TreeMap<String, ColumnDefinition>();
    }

    public void setLikeTable(String table) {
        this.m_likeTable = table;
    }

    public void addPrimaryKey(String primaryKey) {
        this.m_primaryKeys.add(primaryKey);
    }

    public void addColumn(ColumnDefinition column) {
        if (this.columnDefinitions.containsKey(column.getName())) {
            throw new IllegalArgumentException("duplicate column: " + column.getName());
        }
        this.columnDefinitions.put(column.getName(), column);
        this.m_columns.add(column);
    }

    public void addForeignKey(ForeignKeyDefinition key) {
        this.m_foreignKeys.add(key);
    }

    public void addIndex(IndexDefinition index) {
        this.m_indexes.add(index);
    }

    public void addUnique(UniqueDefinition unique) {
        this.m_uniques.add(unique);
    }

    public void addFullText(FullTextDefinition fullText) {
        this.fullTexts.add(fullText);
    }

    public String getName() {
        return this.m_name;
    }

    public String getLikeTable() {
        return this.m_likeTable;
    }

    public List<String> getPrimaryKeys() {
        return this.m_primaryKeys;
    }

    public ColumnDefinition getColumnDefinition(String columnName) {
        ColumnDefinition def = this.columnDefinitions.get(columnName);
        if (def == null) {
            throw new IllegalArgumentException("Column not found: " + columnName);
        }
        return def;
    }

    public List<ColumnDefinition> getColumns() {
        return Collections.unmodifiableList(this.m_columns);
    }

    public List<ForeignKeyDefinition> getForeignKeys() {
        return this.m_foreignKeys;
    }

    public List<IndexDefinition> getIndexes() {
        return this.m_indexes;
    }

    public List<UniqueDefinition> getUniques() {
        return this.m_uniques;
    }

    public List<FullTextDefinition> getFullTexts() {
        return this.fullTexts;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }
}

