/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.BatchStatement;
import Xm.JavaUtils.Database.ColumnDefinition;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DeleteStatementBuilder;
import Xm.JavaUtils.Database.InsertStatementBuilder;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.TableDefinition;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemView {
    public static final String TABLE_NAME = "SystemView";
    public static final String COLUMN_NAME_INSTANCE_ID = "InstanceId";
    public static final String COLUMN_NAME_IS_PRIMARY = "IsPrimary";
    public static final String COLUMN_NAME_SEQUENCE_NUMBER = "LastSeqNum";

    public static List<ComponentInstance> getView(DbConnection con) throws SQLException, DbConnectException {
        ArrayList<ComponentInstance> components = new ArrayList<ComponentInstance>();
        SelectStatementBuilder statement = new SelectStatementBuilder();
        statement.addTable(new Table(TABLE_NAME));
        statement.addColumn(COLUMN_NAME_INSTANCE_ID);
        statement.addColumn(COLUMN_NAME_IS_PRIMARY);
        statement.addColumn(COLUMN_NAME_SEQUENCE_NUMBER);
        ResultSet results = con.execute(statement.build());
        while (results.next()) {
            components.add(new ComponentInstance(results.getString(COLUMN_NAME_INSTANCE_ID), results.getBoolean(COLUMN_NAME_IS_PRIMARY), results.getLong(COLUMN_NAME_SEQUENCE_NUMBER)));
        }
        return components;
    }

    public static void setView(DbConnection con, List<ComponentInstance> systemView) throws SQLException, DbConnectException {
        SqlWriteStatement[] statements = new SqlWriteStatement[systemView.size() + 1];
        DeleteStatementBuilder deleteStatement = new DeleteStatementBuilder();
        deleteStatement.addTable(TABLE_NAME);
        statements[0] = deleteStatement.build();
        int batchIndex = 1;
        for (ComponentInstance component : systemView) {
            InsertStatementBuilder insertStatement = new InsertStatementBuilder();
            insertStatement.table(TABLE_NAME);
            insertStatement.addValue(COLUMN_NAME_INSTANCE_ID, component.m_id);
            insertStatement.addValue(COLUMN_NAME_IS_PRIMARY, component.m_isPrimary);
            insertStatement.addValue(COLUMN_NAME_SEQUENCE_NUMBER, component.m_sequenceNumber);
            statements[batchIndex] = insertStatement.build();
            ++batchIndex;
        }
        BatchStatement batchStatements = new BatchStatement(statements, true);
        con.execute(batchStatements);
    }

    public static void updatePrimarySeqNum(List<ComponentInstance> systemView, long SequenceNumber2) {
        for (ComponentInstance componentInstance : systemView) {
            if (!componentInstance.m_isPrimary) continue;
            componentInstance.m_sequenceNumber = SequenceNumber2;
        }
    }

    public static long getSeqNum(List<ComponentInstance> systemView, String instanceId) {
        for (ComponentInstance componentInstance : systemView) {
            if (!componentInstance.m_id.equals(instanceId)) continue;
            return componentInstance.m_sequenceNumber;
        }
        return 0L;
    }

    public static long getLastSeqNumSynchro(DbConnection localCon, DbConnection sourceCon, long localMaxSeqNum, long sourceMaxSeqNum) throws SQLException, DbConnectException {
        List<ComponentInstance> localSystemView = SystemView.getView(localCon);
        SystemView.updatePrimarySeqNum(localSystemView, localMaxSeqNum);
        List<ComponentInstance> sourceSystemView = SystemView.getView(sourceCon);
        SystemView.updatePrimarySeqNum(sourceSystemView, sourceMaxSeqNum);
        return SystemView.getLastSeqNumSynchro(localSystemView, sourceSystemView);
    }

    public static long getLastSeqNumSynchro(List<ComponentInstance> systemViewA, List<ComponentInstance> systemViewB) {
        long lastSeqNumSynchro = 0L;
        block0: for (ComponentInstance componentInstanceA : systemViewA) {
            for (ComponentInstance componentInstanceB : systemViewB) {
                if (!componentInstanceA.m_id.equals(componentInstanceB.m_id)) continue;
                lastSeqNumSynchro = Math.max(lastSeqNumSynchro, Math.min(componentInstanceA.m_sequenceNumber, componentInstanceB.m_sequenceNumber));
                continue block0;
            }
        }
        return lastSeqNumSynchro;
    }

    public static String tableName() {
        return TABLE_NAME;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition table = new TableDefinition(TABLE_NAME);
        table.addPrimaryKey(COLUMN_NAME_INSTANCE_ID);
        table.addColumn(ColumnDefinition.column(COLUMN_NAME_INSTANCE_ID, ColumnDefinition.Type.STRING, ColumnDefinition.NullRestriction.NOT_NULL));
        table.addColumn(ColumnDefinition.column(COLUMN_NAME_IS_PRIMARY, ColumnDefinition.Type.BOOLEAN, ColumnDefinition.NullRestriction.NOT_NULL));
        table.addColumn(ColumnDefinition.column(COLUMN_NAME_SEQUENCE_NUMBER, ColumnDefinition.Type.LONGINT, ColumnDefinition.NullRestriction.NOT_NULL));
        return table;
    }

    public static class ComponentInstance {
        public String m_id;
        public boolean m_isPrimary;
        public long m_sequenceNumber;

        ComponentInstance(String id, Boolean isPrimary, long sequenceNumber) {
            this.m_id = id;
            this.m_isPrimary = isPrimary;
            this.m_sequenceNumber = sequenceNumber;
        }
    }
}

