/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.StatementExecutorPOA;
import Xm.FaultTolerance.StatementExecutorPackage.DataFormatException;
import Xm.FaultTolerance.StatementExecutorPackage.NotPrimary;
import Xm.FaultTolerance.StatementExecutorPackage.RequestExecutionException;
import Xm.JavaUtils.Database.ConnectionUtils;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbConnectionFactory;
import Xm.JavaUtils.Database.SqlStatementExecute;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.ValidatorI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;

public class StatementExecutorImpl
extends StatementExecutorPOA {
    SingletonFileLogger logger = SingletonFileLogger.GetInstance();
    SqlStatementExecute executor;
    ValidatorI isPrimary;
    DbConnectionFactory connectionFactory;

    public StatementExecutorImpl(DbConnectionFactory factory, SqlStatementExecute executor, ValidatorI isPrimary) {
        this.connectionFactory = factory;
        this.executor = executor;
        this.isPrimary = isPrimary;
    }

    public int Execute(byte[] Statement2) throws RequestExecutionException, DataFormatException, NotPrimary {
        if (this.isPrimary.Validate()) {
            return this.doExecute(Statement2);
        }
        this.logger.LogWriteWarning("XMJU25-007", "StatementExecutorImpl.Execute(): Cannot execute request because I am not primary");
        throw new NotPrimary();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doExecute(byte[] Statement2) throws RequestExecutionException, DataFormatException {
        int n;
        String logMessageBase = "StatementExecutorImpl.doExecute()...";
        this.logger.LogWriteLowLevel("XMJU25-003", logMessageBase);
        DbConnection con = null;
        try {
            ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(Statement2));
            SqlWriteStatement statement = (SqlWriteStatement)stream.readObject();
            con = this.connectionFactory.create();
            int result = this.executor.execute(statement, con);
            this.logger.LogWriteLowLevel("XMJU25-004", logMessageBase + "Done");
            n = result;
        }
        catch (IOException e) {
            try {
                this.logger.LogWriteFatalError("XMJU25-001", logMessageBase + "IOException: " + e.getMessage());
                this.logger.LogWriteFatalError("XMJU25-001", SingletonFileLogger.StackTraceOf(e));
                throw new DataFormatException();
                catch (ClassNotFoundException e2) {
                    this.logger.LogWriteFatalError("XMJU25-002", logMessageBase + "ClassNotFoundException: " + e2.getMessage());
                    this.logger.LogWriteFatalError("XMJU25-002", SingletonFileLogger.StackTraceOf(e2));
                    throw new DataFormatException();
                }
                catch (SQLException e3) {
                    this.logger.LogWriteFatalError("XMJU25-005", logMessageBase + "SQLException: " + e3.getMessage());
                    this.logger.LogWriteFatalError("XMJU25-005", SingletonFileLogger.StackTraceOf(e3));
                    throw new RequestExecutionException();
                }
                catch (DbConnectException e4) {
                    this.logger.LogWriteFatalError("XMJU25-006", logMessageBase + "DbConnectException: " + e4.getMessage());
                    this.logger.LogWriteFatalError("XMJU25-006", SingletonFileLogger.StackTraceOf(e4));
                    throw new RequestExecutionException();
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.close(con);
                throw throwable;
            }
        }
        ConnectionUtils.close(con);
        return n;
    }
}

