/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.ComponentInstance;
import Xm.FaultTolerance.ComponentInstancePackage.UnsupportedFacet;
import Xm.FaultTolerance.StatementExecutor;
import Xm.FaultTolerance.StatementExecutorPackage.DataFormatException;
import Xm.FaultTolerance.StatementExecutorPackage.NotPrimary;
import Xm.FaultTolerance.StatementExecutorPackage.RequestExecutionException;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.StatementExecutorHelperI;
import Xm.JavaUtils.SingletonFileLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class StatementExecutorHelper
implements StatementExecutorHelperI {
    StatementExecutor executor;

    StatementExecutorHelper(StatementExecutor executor) {
        this.executor = executor;
    }

    public StatementExecutorHelper(ComponentInstance component) throws UnsupportedFacet {
        this(Xm.FaultTolerance.StatementExecutorHelper.narrow(component.GetFacet("StatementExecutor")));
    }

    static byte[] serialize(SqlWriteStatement statement) throws DataFormatException {
        try {
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(bytestream);
            stream.writeObject(statement);
            return bytestream.toByteArray();
        }
        catch (IOException e) {
            SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU27-001", SingletonFileLogger.StackTraceOf(e));
            throw new DataFormatException();
        }
    }

    public int execute(SqlWriteStatement statement) throws DataFormatException, NotPrimary, RequestExecutionException {
        return this.executor.Execute(StatementExecutorHelper.serialize(statement));
    }
}

