/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.AbstractSqlStatementTransform;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DeleteStatement;
import Xm.JavaUtils.Database.DeleteStatementBuilder;
import Xm.JavaUtils.Database.FunctionCall;
import Xm.JavaUtils.Database.FunctionCallBuilder;
import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.InsertStatementBuilder;
import Xm.JavaUtils.Database.ParameterDefinition;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SeqNumFactory;
import Xm.JavaUtils.Database.SequenceNumberProperty;
import Xm.JavaUtils.Database.SqlStatementTransform;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.UpdateStatement;
import Xm.JavaUtils.Database.UpdateStatementBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStatementAddSeqNum
implements SqlStatementTransform {
    private SeqNumFactory m_factory;

    public SqlStatementAddSeqNum(SeqNumFactory Factory) {
        this.m_factory = Factory;
    }

    private static void processValues(List<Object> values, long sequenceNumber) {
        for (int i = 0; i < values.size(); ++i) {
            if (!(values.get(i) instanceof FunctionCall)) continue;
            values.set(i, SqlStatementAddSeqNum.processFunctionCall((FunctionCall)values.get(i), sequenceNumber));
        }
    }

    private static FunctionCall processFunctionCall(FunctionCall call, long sequenceNumber) {
        for (ParameterDefinition param : call.getFunction().getParameters()) {
            if (!param.getName().equals("SequenceNumber")) continue;
            return new FunctionCallBuilder(call).setParam(param, (Object)sequenceNumber).build();
        }
        return call;
    }

    @Override
    public SqlWriteStatement transform(SqlWriteStatement statement) throws SQLException, DbConnectException {
        Transformer transformer = new Transformer();
        statement.accept(transformer);
        return transformer.getTransformedStatement();
    }

    private class Transformer
    extends AbstractSqlStatementTransform {
        private Transformer() {
        }

        public void visit(UpdateStatement statement) {
            long sequenceNumber = SqlStatementAddSeqNum.this.m_factory.next();
            UpdateStatementBuilder builder = new UpdateStatementBuilder(statement);
            builder.addValue("SequenceNumber", sequenceNumber);
            builder.applyProperties(SequenceNumberProperty.createPropertiesWith(sequenceNumber));
            SqlStatementAddSeqNum.processValues(builder.getValues(), sequenceNumber);
            this.transformedStatement = builder.build();
        }

        public void visit(InsertStatement statement) {
            long sequenceNumber = SqlStatementAddSeqNum.this.m_factory.next();
            InsertStatementBuilder builder = new InsertStatementBuilder(statement);
            SelectStatement select = statement.selectClause();
            if (select != null) {
                SelectStatementBuilder selectBuilder = new SelectStatementBuilder(select);
                selectBuilder.addColumn(sequenceNumber + " AS " + "SequenceNumber");
                List<String> columns = statement.columns();
                if (!columns.isEmpty()) {
                    columns = new ArrayList<String>(columns);
                    columns.add("SequenceNumber");
                }
                builder.setSelectClause(selectBuilder.build(), columns);
            } else {
                SqlStatementAddSeqNum.processValues(builder.getValues(), sequenceNumber);
                SqlStatementAddSeqNum.processValues(builder.getUpdateValues(), sequenceNumber);
                builder.addValue("SequenceNumber", sequenceNumber);
            }
            if (statement.onDuplicateKeyUpdate()) {
                builder.addUpdateValue("SequenceNumber", sequenceNumber);
            }
            builder.applyProperties(SequenceNumberProperty.createPropertiesWith(sequenceNumber));
            this.transformedStatement = builder.build();
        }

        public void visit(DeleteStatement statement) {
            long sequenceNumber = SqlStatementAddSeqNum.this.m_factory.next();
            DeleteStatementBuilder builder = new DeleteStatementBuilder(statement);
            builder.applyProperties(SequenceNumberProperty.createPropertiesWith(sequenceNumber));
            this.transformedStatement = builder.build();
        }
    }
}

