/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.Column;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.Match;
import Xm.JavaUtils.Database.OpAnd;
import Xm.JavaUtils.Database.OpEqual;
import Xm.JavaUtils.Database.OpExists;
import Xm.JavaUtils.Database.OpGreater;
import Xm.JavaUtils.Database.OpGreaterEqual;
import Xm.JavaUtils.Database.OpIn;
import Xm.JavaUtils.Database.OpLess;
import Xm.JavaUtils.Database.OpLessEqual;
import Xm.JavaUtils.Database.OpLike;
import Xm.JavaUtils.Database.OpNot;
import Xm.JavaUtils.Database.OpNotEqual;
import Xm.JavaUtils.Database.OpNull;
import Xm.JavaUtils.Database.OpOr;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SubSelect;
import Xm.JavaUtils.Database.Value;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFilter {
    private SqlFilter() {
    }

    public static Column column(String name) {
        return new Column(name);
    }

    public static Column column(String tableName, String columnName) {
        return new Column(tableName, columnName);
    }

    public static Value value(int value) {
        return new Value(value);
    }

    public static Value value(long value) {
        return new Value(value);
    }

    public static Value value(boolean value) {
        return new Value(value);
    }

    public static Value value(String value) {
        return new Value(value);
    }

    public static Value value(int[] values) {
        return new Value(values);
    }

    public static Value value(long[] values) {
        return new Value(values);
    }

    public static Value value(boolean[] values) {
        return new Value(values);
    }

    public static Value value(String[] values) {
        return new Value(values);
    }

    public static Value value(Object values) {
        return new Value(values);
    }

    public static SubSelect select(SelectStatement statement) {
        return new SubSelect(statement);
    }

    public static OpNull isNull(IFilterElement col) {
        return new OpNull(col);
    }

    public static OpEqual equal(IFilterElement leftOp, IFilterElement rightOp) {
        OpEqual operator = new OpEqual(leftOp, rightOp);
        return operator;
    }

    public static OpNotEqual notEqual(IFilterElement leftOp, IFilterElement rightOp) {
        OpNotEqual operator = new OpNotEqual(leftOp, rightOp);
        return operator;
    }

    public static OpLike like(IFilterElement leftOp, IFilterElement rightOp) {
        OpLike operator = new OpLike(leftOp, rightOp);
        return operator;
    }

    public static OpGreater greater(IFilterElement leftOp, IFilterElement rightOp) {
        OpGreater operator = new OpGreater(leftOp, rightOp);
        return operator;
    }

    public static OpGreaterEqual greaterEqual(IFilterElement leftOp, IFilterElement rightOp) {
        OpGreaterEqual operator = new OpGreaterEqual(leftOp, rightOp);
        return operator;
    }

    public static OpLess less(IFilterElement leftOp, IFilterElement rightOp) {
        OpLess operator = new OpLess(leftOp, rightOp);
        return operator;
    }

    public static OpLessEqual lessEqual(IFilterElement leftOp, IFilterElement rightOp) {
        OpLessEqual operator = new OpLessEqual(leftOp, rightOp);
        return operator;
    }

    public static OpIn in(IFilterElement leftOp, IFilterElement rightOp) {
        OpIn operator = new OpIn(leftOp, rightOp);
        return operator;
    }

    public static OpAnd inRange(IFilterElement op, IFilterElement lowerBound, IFilterElement upperBound) {
        return SqlFilter.and(SqlFilter.greaterEqual(op, lowerBound), SqlFilter.lessEqual(op, upperBound));
    }

    public static OpAnd and(IFilterElement leftOp, IFilterElement rightOp) {
        OpAnd operator = new OpAnd(leftOp, rightOp);
        return operator;
    }

    public static OpAnd and() {
        OpAnd operator = new OpAnd();
        return operator;
    }

    public static OpOr or(IFilterElement leftOp, IFilterElement rightOp) {
        OpOr operator = new OpOr(leftOp, rightOp);
        return operator;
    }

    public static OpOr or() {
        OpOr operator = new OpOr();
        return operator;
    }

    public static OpNot not(IFilterElement op) {
        OpNot operator = new OpNot(op);
        return operator;
    }

    public static OpNot not() {
        OpNot operator = new OpNot();
        return operator;
    }

    public static OpExists exists(IFilterElement op) {
        OpExists operator = new OpExists(op);
        return operator;
    }

    public static IFilterElement orIfNeeded(IFilterElement sequence, IFilterElement element) {
        if (sequence == null) {
            return element;
        }
        return SqlFilter.or(sequence, element);
    }

    public static IFilterElement andIfNeeded(IFilterElement sequence, IFilterElement element) {
        if (sequence == null) {
            return element;
        }
        return SqlFilter.and(sequence, element);
    }

    public static Match match(List<String> columns, String against) {
        return new Match(columns, against);
    }

    public static Match booleanMatch(List<String> columns, String against) {
        return new Match(columns, against, true);
    }
}

