/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DeleteLogger;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SeqNumFactory;
import Xm.JavaUtils.Database.Table;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SeqNumManager
implements SeqNumFactory {
    private long m_CurrentSeqNum = 0L;

    public static long maxSeqNum(DbConnection localConnection) throws SQLException, DbConnectException {
        DatabaseMetaData metaData = localConnection.getMetaData();
        long seqNum = 0L;
        ResultSet columns = metaData.getColumns("", "%", "%", "SequenceNumber");
        while (columns.next()) {
            String tableName = columns.getString("TABLE_NAME");
            if (tableName.startsWith("old_") || tableName.endsWith("_conflicts") || tableName.endsWith("_next_unique_id") || tableName.endsWith("_partition")) continue;
            SelectStatementBuilder select = new SelectStatementBuilder();
            select.addTable(new Table(tableName));
            select.addMax(columns.getString("COLUMN_NAME"));
            ResultSet results = localConnection.execute(select.build());
            if (!results.next()) continue;
            seqNum = Math.max(seqNum, results.getLong(1));
        }
        seqNum = Math.max(seqNum, DeleteLogger.getMaximumEffectiveCleanupSeqNum(localConnection));
        return seqNum;
    }

    public synchronized void init(DbConnection localConnection) throws SQLException, DbConnectException {
        this.m_CurrentSeqNum = SeqNumManager.maxSeqNum(localConnection);
    }

    public synchronized long current() {
        return this.m_CurrentSeqNum;
    }

    public synchronized long next() {
        return ++this.m_CurrentSeqNum;
    }
}

