/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.Column;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.ISource;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.Table;
import java.util.ArrayList;
import java.util.List;

public class SelectStatementBuilder {
    private List<IFilterElement> m_columns;
    private List<ISource> m_tables;
    private List<String> m_orders;
    private List<String> m_unionOrders;
    private List<String> m_groups;
    private int m_beginLimit;
    private int m_maxLimit;
    private int m_unionBeginLimit;
    private int m_unionMaxLimit;
    private boolean m_distinct;
    private SelectStatement m_union;
    private IFilterElement m_filter;

    public SelectStatementBuilder() {
        this.m_columns = new ArrayList<IFilterElement>();
        this.m_tables = new ArrayList<ISource>();
        this.m_orders = new ArrayList<String>();
        this.m_groups = new ArrayList<String>();
        this.m_distinct = false;
        this.m_beginLimit = -1;
        this.m_maxLimit = -1;
        this.m_union = null;
        this.m_unionBeginLimit = -1;
        this.m_unionMaxLimit = -1;
        this.m_unionOrders = new ArrayList<String>();
    }

    public SelectStatementBuilder(SelectStatement statement) {
        this.m_columns = new ArrayList<IFilterElement>(statement.columns());
        this.m_tables = new ArrayList<ISource>(statement.tables());
        this.m_orders = new ArrayList<String>(statement.orders());
        this.m_groups = new ArrayList<String>(statement.groups());
        this.m_distinct = statement.isDistinct();
        this.m_union = statement.getUnion();
        this.m_beginLimit = statement.beginLimit();
        this.m_maxLimit = statement.maxLimit();
        this.m_filter = statement.getFilter();
        this.m_unionBeginLimit = statement.getUnionBeginLimit();
        this.m_unionMaxLimit = statement.getUnionMaxLimit();
        this.m_unionOrders = new ArrayList<String>(statement.getUnionOrders());
    }

    public void addColumn(String column) {
        this.m_columns.add(new Column(column));
    }

    public void addColumn(IFilterElement column) {
        this.m_columns.add(column);
    }

    public void addCount(String column) {
        this.addColumn("COUNT(" + column + ")");
    }

    public void addCount(String column, String alias) {
        this.addColumn("COUNT(" + column + ") AS " + alias);
    }

    public void addMin(String column) {
        this.addColumn("MIN(" + column + ")");
    }

    public void addMax(String column) {
        this.addColumn("MAX(" + column + ")");
    }

    public void addTable(String table) {
        this.m_tables.add(new Table(table));
    }

    public void addTable(ISource table) {
        this.m_tables.add(table);
    }

    public void addOrder(String order) {
        this.m_orders.add(order);
    }

    public void addGroup(String group) {
        this.m_groups.add(group);
    }

    public void setDistinct(boolean value) {
        this.m_distinct = value;
    }

    public void setUnion(SelectStatement value) {
        this.m_union = value;
    }

    public void limit(int maxLimit) {
        this.m_beginLimit = -1;
        this.m_maxLimit = maxLimit;
    }

    public void limit(int beginLimit, int maxLimit) {
        this.m_beginLimit = beginLimit;
        this.m_maxLimit = maxLimit;
    }

    public void setUnionLimit(int unionMaxLimit) {
        this.m_unionBeginLimit = -1;
        this.m_unionMaxLimit = unionMaxLimit;
    }

    public void setUnionLimit(int unionBeginLimit, int unionMaxLimit) {
        this.m_unionBeginLimit = unionBeginLimit;
        this.m_unionMaxLimit = unionMaxLimit;
    }

    public void addUnionOrder(String unionOrder) {
        this.m_unionOrders.add(unionOrder);
    }

    public IFilterElement getFilter() {
        return this.m_filter;
    }

    public void setFilter(IFilterElement filter) {
        this.m_filter = filter;
    }

    public SelectStatement build() {
        return new SelectStatement(this.m_columns, this.m_tables, this.m_groups, this.m_orders, this.m_beginLimit, this.m_maxLimit, this.m_distinct, this.m_union, this.m_unionBeginLimit, this.m_unionMaxLimit, this.m_unionOrders, this.m_filter);
    }
}

