/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.ISource;
import Xm.JavaUtils.Database.SqlStatement;
import Xm.JavaUtils.Database.SqlStatementToString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectStatement
implements SqlStatement {
    private final List<IFilterElement> m_columns;
    private final List<ISource> m_tables;
    private final List<String> m_groups;
    private final List<String> m_orders;
    private final List<String> m_unionOrders;
    private final int m_beginLimit;
    private final int m_maxLimit;
    private final int m_unionBeginLimit;
    private final int m_unionMaxLimit;
    private final boolean m_distinct;
    private final SelectStatement m_union;
    private IFilterElement m_filter;

    public SelectStatement(List<IFilterElement> columns, List<ISource> tables, List<String> groups, List<String> orders, int beginLimit, int maxLimit) {
        this(columns, tables, groups, orders, beginLimit, maxLimit, false, null, -1, -1, null, null);
    }

    public SelectStatement(List<IFilterElement> columns, List<ISource> tables, List<String> groups, List<String> orders, int beginLimit, int maxLimit, boolean distinct) {
        this(columns, tables, groups, orders, beginLimit, maxLimit, distinct, null, -1, -1, null, null);
    }

    public SelectStatement(List<IFilterElement> columns, List<ISource> tables, List<String> groups, List<String> orders, int beginLimit, int maxLimit, boolean distinct, SelectStatement union, int unionbeginLimit, int unionmaxLimit, List<String> unionOrders, IFilterElement filter) {
        this.m_columns = columns == null ? Collections.emptyList() : new ArrayList<IFilterElement>(columns);
        this.m_tables = tables == null ? Collections.emptyList() : new ArrayList<ISource>(tables);
        this.m_orders = orders == null ? Collections.emptyList() : new ArrayList<String>(orders);
        this.m_groups = groups == null ? Collections.emptyList() : new ArrayList<String>(groups);
        this.m_beginLimit = beginLimit;
        this.m_maxLimit = maxLimit;
        this.m_distinct = distinct;
        this.m_union = union;
        this.m_filter = filter;
        this.m_unionOrders = unionOrders == null ? Collections.emptyList() : new ArrayList<String>(unionOrders);
        this.m_unionBeginLimit = unionbeginLimit;
        this.m_unionMaxLimit = unionmaxLimit;
    }

    public List<IFilterElement> columns() {
        return Collections.unmodifiableList(this.m_columns);
    }

    public List<ISource> tables() {
        return Collections.unmodifiableList(this.m_tables);
    }

    public List<String> groups() {
        return Collections.unmodifiableList(this.m_groups);
    }

    public List<String> orders() {
        return Collections.unmodifiableList(this.m_orders);
    }

    public List<String> getUnionOrders() {
        return Collections.unmodifiableList(this.m_unionOrders);
    }

    public int beginLimit() {
        return this.m_beginLimit;
    }

    public int maxLimit() {
        return this.m_maxLimit;
    }

    public int getUnionBeginLimit() {
        return this.m_unionBeginLimit;
    }

    public int getUnionMaxLimit() {
        return this.m_unionMaxLimit;
    }

    public boolean isDistinct() {
        return this.m_distinct;
    }

    public SelectStatement getUnion() {
        return this.m_union;
    }

    public IFilterElement getFilter() {
        return this.m_filter;
    }

    @Override
    public String toString(SqlStatementToString visitor) {
        return visitor.toString(this);
    }
}

