/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.CompositeFilterElement;
import Xm.JavaUtils.Database.Counters;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DeleteLogger;
import Xm.JavaUtils.Database.DeleteStatementBuilder;
import Xm.JavaUtils.Database.ForeignKeys;
import Xm.JavaUtils.Database.InsertStatementBuilder;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SqlFilter;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.TableDefinition;
import Xm.JavaUtils.Database.TableInfo;
import Xm.JavaUtils.SingletonFileLogger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryHelper {
    static String COUNTER_RECOVERY_STARTPOINT = "RecoveryStartPoint";
    static SingletonFileLogger logger = SingletonFileLogger.GetInstance();
    TableInfo[] tableDefinitions;
    DeleteLogger deleteLogger;
    Counters counters = new Counters();

    public RecoveryHelper(TableInfo[] tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
        TableDefinition[] tablesDef = new TableDefinition[tableDefinitions.length];
        int i = 0;
        for (TableInfo table : tableDefinitions) {
            tablesDef[i++] = table.getTableDefinition();
        }
        this.deleteLogger = new DeleteLogger(tableDefinitions, null);
    }

    public long initRecovery(DbConnection localCon) throws SQLException, DbConnectException {
        long recoveryStartPoint = 0L;
        for (TableInfo tableDef : this.tableDefinitions) {
            Long startPoint = this.counters.queryLong(localCon, COUNTER_RECOVERY_STARTPOINT, tableDef.getName());
            if (startPoint == null) {
                recoveryStartPoint = Math.max(recoveryStartPoint, Math.max(DeleteLogger.getEffectiveCleanupSeqNum(localCon, tableDef.getName()), Math.max(this.maxSeqNum(localCon, tableDef.getName()), this.maxSeqNum(localCon, DeleteLogger.getDeleteLogTableName(tableDef.getName())))));
                this.counters.initLong(localCon, COUNTER_RECOVERY_STARTPOINT, tableDef.getName(), recoveryStartPoint);
                continue;
            }
            recoveryStartPoint = Math.max(recoveryStartPoint, startPoint);
        }
        return recoveryStartPoint;
    }

    public boolean sortParentFirst() {
        TableDefinition[] tablesDef = new TableDefinition[this.tableDefinitions.length];
        ArrayList<String> tables = new ArrayList<String>();
        for (int i = 0; i < this.tableDefinitions.length; ++i) {
            tablesDef[i] = this.tableDefinitions[i].getTableDefinition();
            tables.add(this.tableDefinitions[i].getName());
        }
        ForeignKeys foreignKeys = ForeignKeys.createCascadeDeleteForeignKeys(tablesDef);
        boolean sortable = RecoveryHelper.sortParentFirst(tables, foreignKeys);
        if (sortable) {
            block1: for (int i = 0; i < tables.size(); ++i) {
                for (int j = i; j < this.tableDefinitions.length; ++j) {
                    if (!((String)tables.get(i)).equals(this.tableDefinitions[j].getName())) continue;
                    if (i == j) continue block1;
                    TableInfo temp = this.tableDefinitions[i];
                    this.tableDefinitions[i] = this.tableDefinitions[j];
                    this.tableDefinitions[j] = temp;
                    continue block1;
                }
            }
        }
        return sortable;
    }

    public static boolean sortParentFirst(List<String> tables, ForeignKeys foreignKeys) {
        int i;
        for (i = 0; i < tables.size(); ++i) {
            if (!RecoveryHelper.isParentOf(tables.get(i), tables.get(i), foreignKeys)) continue;
            return false;
        }
        for (i = 0; i < tables.size() - 1; ++i) {
            for (int j = i + 1; j < tables.size(); ++j) {
                if (!RecoveryHelper.isParentOf(tables.get(j), tables.get(i), foreignKeys)) continue;
                if (RecoveryHelper.isParentOf(tables.get(i), tables.get(j), foreignKeys)) {
                    return false;
                }
                String temp = tables.get(i);
                tables.set(i, tables.get(j));
                tables.set(j, temp);
            }
        }
        return true;
    }

    private static boolean isParentOf(String parentTable, String childTable, ForeignKeys foreignKeys) {
        return RecoveryHelper.isParentOf(parentTable, childTable, foreignKeys, new TreeSet<String>());
    }

    private static boolean isParentOf(String parentTable, String childTable, ForeignKeys foreignKeys, Set<String> alreadyChecked) {
        Set childTables = foreignKeys.getFkTables(parentTable);
        if (childTables.contains(childTable)) {
            return true;
        }
        alreadyChecked.add(parentTable);
        for (String nextTable : childTables) {
            if (alreadyChecked.contains(nextTable) || !RecoveryHelper.isParentOf(nextTable, childTable, foreignKeys, alreadyChecked)) continue;
            return true;
        }
        return false;
    }

    public void scanUpdatedRecords(DbConnection localCon, DbConnection sourceCon) throws SQLException, DbConnectException {
        this.scanUpdatedRecords(localCon, sourceCon, -1L);
    }

    public void scanUpdatedRecords(DbConnection localCon, DbConnection sourceCon, long sourceMaxSeqNum) throws SQLException, DbConnectException {
        logger.LogWriteNormal("XMJU12-003", "RecoveryHelper.scanUpdatedRecords()");
        for (TableInfo tableDef : this.tableDefinitions) {
            this.scanUpdatedRecords(localCon, sourceCon, tableDef.getName(), sourceMaxSeqNum);
        }
        logger.LogWriteNormal("XMJU12-004", "RecoveryHelper.scanUpdatedRecords() Done");
    }

    private long maxSeqNum(DbConnection con, String table) throws SQLException, DbConnectException {
        SelectStatementBuilder selectSeqNum = new SelectStatementBuilder();
        selectSeqNum.addMax("SequenceNumber");
        selectSeqNum.addTable(new Table(table));
        ResultSet results = con.execute(selectSeqNum.build());
        results.next();
        return results.getLong(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanUpdatedRecords(DbConnection localCon, DbConnection sourceCon, String table, long sourceMaxSeqNum) throws SQLException, DbConnectException {
        DbConnection.Lock lock = null;
        try {
            lock = localCon.getLock();
            localCon.setAutoCommit(false);
            logger.LogWriteNormal("XMJU12-005", "Scanning table '" + table + "'");
            long localMaxSeqNum = this.maxSeqNum(localCon, table);
            CompositeFilterElement filter = sourceMaxSeqNum == -1L ? SqlFilter.greaterEqual(SqlFilter.column("SequenceNumber"), SqlFilter.value(localMaxSeqNum)) : SqlFilter.and(SqlFilter.greaterEqual(SqlFilter.column("SequenceNumber"), SqlFilter.value(localMaxSeqNum)), SqlFilter.lessEqual(SqlFilter.column("SequenceNumber"), SqlFilter.value(sourceMaxSeqNum)));
            SelectStatementBuilder selectSource = new SelectStatementBuilder();
            selectSource.addTable(new Table(table));
            selectSource.addColumn("*");
            selectSource.setFilter(filter);
            selectSource.addOrder("SequenceNumber");
            ResultSet selectedRows = sourceCon.execute(selectSource.build());
            int count = 0;
            ResultSetMetaData metaData = selectedRows.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (selectedRows.next()) {
                InsertStatementBuilder insertBuilder = new InsertStatementBuilder();
                insertBuilder.table(table);
                for (int col = 1; col <= columnCount; ++col) {
                    String columnName = metaData.getColumnName(col);
                    String columnValue = selectedRows.getString(columnName);
                    insertBuilder.addValue(columnName, columnValue);
                    insertBuilder.addUpdateValue(columnName, columnValue);
                }
                localCon.execute(insertBuilder.build());
                if (++count != 1000) continue;
                localCon.commit();
                count = 0;
            }
            localCon.commit();
            localCon.setAutoCommit(true);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public boolean checkForBruteForce(DbConnection localCon, DbConnection sourceCon) throws SQLException, DbConnectException {
        boolean bruteForceRequired = false;
        for (TableInfo tableDef : this.tableDefinitions) {
            bruteForceRequired |= this.checkForBruteForce(localCon, sourceCon, tableDef.getName(), this.maxSeqNum(localCon, tableDef.getName()));
        }
        return bruteForceRequired;
    }

    public boolean checkForBruteForce(DbConnection localCon, DbConnection sourceCon, long lastSeqNumSynchro) throws SQLException, DbConnectException {
        boolean bruteForceRequired = false;
        for (TableInfo tableDef : this.tableDefinitions) {
            bruteForceRequired |= this.checkForBruteForce(localCon, sourceCon, tableDef.getName(), lastSeqNumSynchro);
        }
        return bruteForceRequired;
    }

    private boolean checkForBruteForce(DbConnection localCon, DbConnection sourceCon, String table, long lastSeqNumSynchro) throws SQLException, DbConnectException {
        long startPoint;
        long localEffectiveCleanup = DeleteLogger.getEffectiveCleanupSeqNum(localCon, table);
        long sourceEffectiveCleanup = DeleteLogger.getEffectiveCleanupSeqNum(sourceCon, table);
        if ((sourceEffectiveCleanup != localEffectiveCleanup || sourceEffectiveCleanup > lastSeqNumSynchro) && (startPoint = this.counters.getLong(localCon, COUNTER_RECOVERY_STARTPOINT, table)) > 0L && startPoint <= sourceEffectiveCleanup) {
            logger.LogWriteNormal("XMJU12-010", "RecoveryHelper.checkForBruteForce() Brute force required for table " + table);
            this.clear(localCon, table);
            return true;
        }
        return false;
    }

    private void clear(DbConnection localCon, String table) throws SQLException, DbConnectException {
        DeleteStatementBuilder statement = new DeleteStatementBuilder();
        statement.addTable(table);
        localCon.execute(statement.build());
        DeleteLogger.purge(localCon, table);
        this.counters.setLong(localCon, COUNTER_RECOVERY_STARTPOINT, table, 0L);
    }

    public void scanDeletedRecords(DbConnection localCon, DbConnection sourceCon) throws SQLException, DbConnectException {
        logger.LogWriteNormal("XMJU12-007", "RecoveryHelper.checkForDeletedRecords()");
        for (TableInfo tableDef : this.tableDefinitions) {
            this.scanDeletedRecords(localCon, sourceCon, tableDef.getName());
        }
        logger.LogWriteNormal("XMJU12-008", "RecoveryHelper.checkForDeletedRecords() Done");
    }

    private void scanDeletedRecords(DbConnection localCon, DbConnection sourceCon, String table) throws SQLException, DbConnectException {
        logger.LogWriteNormal("XMJU12-007", "Scanning table '" + table + "'");
        String deleteLogTableName = DeleteLogger.getDeleteLogTableName(table);
        this.scanUpdatedRecords(localCon, sourceCon, deleteLogTableName, -1L);
        this.deleteLogger.reapply(localCon, table);
    }

    public void finalyzeRecovery(DbConnection localCon, DbConnection sourceCon) throws SQLException, DbConnectException {
        for (TableInfo tableDef : this.tableDefinitions) {
            this.finalyzeRecovery(localCon, sourceCon, tableDef.getName());
        }
    }

    private void finalyzeRecovery(DbConnection localCon, DbConnection sourceCon, String table) throws SQLException, DbConnectException {
        logger.LogWriteNormal("XMJU12-009", "Finalyzing recovery for table '" + table + "'");
        DeleteLogger.cleanupBySeqNum(localCon, table, DeleteLogger.getEffectiveCleanupSeqNum(sourceCon, table));
        this.counters.erase(localCon, COUNTER_RECOVERY_STARTPOINT, table);
    }
}

