/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DuplicateKeySqlException;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.SqlFilter;
import Xm.JavaUtils.Database.TableInfo;
import Xm.JavaUtils.Database.UpdateStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Record {
    private Map<String, Object> namedValues = new HashMap<String, Object>();
    private TableInfo tableInfo;

    public Record(TableInfo table) {
        this.tableInfo = table;
    }

    public void set(String column, Object value) {
        this.namedValues.put(column, value);
    }

    public Object get(String column) {
        return this.namedValues.get(column);
    }

    public Set<String> getColumns() {
        return this.namedValues.keySet();
    }

    public Set<Map.Entry<String, Object>> getEntries() {
        return this.namedValues.entrySet();
    }

    public String getTableName() {
        return this.tableInfo.getTableDefinition().getName();
    }

    public void insertOrUpdate(DbConnection connection) throws SQLException, DbConnectException {
        block3: {
            ArrayList<String> columns = new ArrayList<String>(this.namedValues.size());
            ArrayList<Object> values = new ArrayList<Object>(this.namedValues.size());
            for (Map.Entry<String, Object> entry : this.getEntries()) {
                columns.add(entry.getKey());
                values.add(entry.getValue());
            }
            try {
                connection.execute(new InsertStatement(this.getTableName(), columns, values));
            }
            catch (DuplicateKeySqlException e) {
                UpdateStatement update = new UpdateStatement(this.getTableName(), columns, values, this.getGloballyUniqueKeyFilter());
                if (connection.execute(update) != 0) break block3;
                throw e;
            }
        }
    }

    public boolean update(DbConnection connection) throws SQLException, DbConnectException {
        ArrayList<String> columns = new ArrayList<String>(this.namedValues.size());
        ArrayList<Object> values = new ArrayList<Object>(this.namedValues.size());
        for (Map.Entry<String, Object> entry : this.getEntries()) {
            columns.add(entry.getKey());
            values.add(entry.getValue());
        }
        return connection.execute(new UpdateStatement(this.getTableName(), columns, values, this.getGloballyUniqueKeyFilter())) != 0;
    }

    public IFilterElement getPrimaryKeyFilter() {
        return this.getFilter(this.tableInfo.getTableDefinition().getPrimaryKeys());
    }

    public IFilterElement getGloballyUniqueKeyFilter() {
        return this.getFilter(this.tableInfo.globallyUniqueKey());
    }

    private IFilterElement getFilter(List<String> columns) {
        IFilterElement filter = null;
        for (String keyColumn : columns) {
            Object value = this.get(keyColumn);
            if (value == null) {
                throw new IllegalStateException("Missing value for column " + keyColumn);
            }
            filter = SqlFilter.andIfNeeded(filter, SqlFilter.equal(SqlFilter.column(keyColumn), SqlFilter.value(value)));
        }
        return filter;
    }
}

