/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.ComponentInstancePackage.UnsupportedFacet;
import Xm.FaultTolerance.StatementExecutorPackage.DataFormatException;
import Xm.FaultTolerance.StatementExecutorPackage.NotPrimary;
import Xm.FaultTolerance.StatementExecutorPackage.RequestExecutionException;
import Xm.JavaUtils.Database.Aliased;
import Xm.JavaUtils.Database.Column;
import Xm.JavaUtils.Database.ColumnDefinition;
import Xm.JavaUtils.Database.Counters;
import Xm.JavaUtils.Database.CreateTableStatement;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DeleteLogger;
import Xm.JavaUtils.Database.DeleteStatementBuilder;
import Xm.JavaUtils.Database.DropTableStatement;
import Xm.JavaUtils.Database.ForeignKeyDefinition;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.ISource;
import Xm.JavaUtils.Database.IndexDefinition;
import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.InsertStatementBuilder;
import Xm.JavaUtils.Database.Join;
import Xm.JavaUtils.Database.OpGreater;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SqlFilter;
import Xm.JavaUtils.Database.StatementExecutorHelperI;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.TableDefinition;
import Xm.JavaUtils.Database.TableInfo;
import Xm.JavaUtils.Database.UniqueDefinition;
import Xm.JavaUtils.Database.UpdateStatementBuilder;
import Xm.JavaUtils.Database.Value;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionResolver {
    static String PARTITION_TABLE_SUFFIX = "_partition";
    static String CONFLICTS_TABLE_SUFFIX = "_conflicts";
    static String COLUMN_PARTITION_RESOLUTION_TIME = "PartitionResolutionTime";
    static String COLUMN_CONFLICT_TYPE = "ConflictType";
    static String COUNTER_RESOLUTION_IN_PROGRESS = "PartitionResolutionInProgress";
    static String COUNTER_LAST_LOCAL_CLEANUP = "PartitionResolutionLastLocalCleanup";
    TableInfo[] tables;
    TableInfo[] deleteLogTables;
    Counters counters = new Counters();

    public PartitionResolver(TableInfo[] tableDefinitions, TableInfo[] deleteLogTableDefinitions) {
        assert (tableDefinitions.length == deleteLogTableDefinitions.length);
        for (int i = 0; i < tableDefinitions.length; ++i) {
            assert (deleteLogTableDefinitions[i].getName().equals(DeleteLogger.getDeleteLogTableName(tableDefinitions[i].getName())));
        }
        this.tables = tableDefinitions;
        this.deleteLogTables = deleteLogTableDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPartitionResolution(DbConnection localCon, DbConnection sourceCon, long lastSeqNumSynchro) throws SQLException, DbConnectException {
        DbConnection.Lock lock = null;
        try {
            lock = localCon.getLock();
            localCon.setAutoCommit(false);
            for (int i = 0; i < this.tables.length; ++i) {
                TableInfo table = this.tables[i];
                this.createPartitionResolutionTable(localCon, table.getTableDefinition());
                this.createPartitionResolutionTable(localCon, this.deleteLogTables[i].getTableDefinition());
                if (this.counters.queryLong(localCon, COUNTER_RESOLUTION_IN_PROGRESS, table.getName()) != null) continue;
                long lastCleanUpSeqNum = DeleteLogger.getEffectiveCleanupSeqNum(localCon, table.getName());
                this.counters.initLong(localCon, COUNTER_LAST_LOCAL_CLEANUP, table.getName(), lastCleanUpSeqNum);
                boolean cleanupOccuredSincePartition = lastCleanUpSeqNum > lastSeqNumSynchro;
                this.copyRowsAffectedAfterPartition(localCon, table.getName(), lastSeqNumSynchro, cleanupOccuredSincePartition);
                this.copyRowsAffectedAfterPartition(localCon, DeleteLogger.getDeleteLogTableName(table.getName()), lastSeqNumSynchro, cleanupOccuredSincePartition);
                this.counters.initLong(localCon, COUNTER_RESOLUTION_IN_PROGRESS, table.getName(), 1L);
            }
            for (TableInfo table : this.tables) {
                long lastCleanUpSeqNum = this.counters.getLong(localCon, COUNTER_LAST_LOCAL_CLEANUP, table.getName());
                boolean cleanupOccuredSincePartition = lastCleanUpSeqNum > lastSeqNumSynchro;
                this.deleteRowsAffectedAfterPartition(localCon, table.getName(), lastSeqNumSynchro, cleanupOccuredSincePartition);
                this.deleteRowsAffectedAfterPartition(localCon, DeleteLogger.getDeleteLogTableName(table.getName()), lastSeqNumSynchro, cleanupOccuredSincePartition);
            }
            localCon.commit();
            localCon.setAutoCommit(true);
            lock.unlock();
            lock = null;
            for (TableInfo table : this.tables) {
                long lastCleanUpSeqNum = this.counters.getLong(localCon, COUNTER_LAST_LOCAL_CLEANUP, table.getName());
                if (lastCleanUpSeqNum > lastSeqNumSynchro) continue;
                this.fetchSourceRowsUnmodifiedLocalRowUpdated(localCon, sourceCon, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro);
                this.fetchSourceRowsUnmodifiedLocalRowUpdated(localCon, sourceCon, DeleteLogger.getDeleteLogTableName(table.getName()), table.globallyUniqueKey(), lastSeqNumSynchro);
                this.fetchSourceRowsUnmodifiedLocalRowMovedToDeleteLog(localCon, sourceCon, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro);
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void createPartitionResolutionTable(DbConnection localCon, TableDefinition tableDef) throws SQLException, DbConnectException {
        TableDefinition tableDefinition = new TableDefinition(tableDef.getName() + PARTITION_TABLE_SUFFIX);
        for (ColumnDefinition column : tableDef.getColumns()) {
            tableDefinition.addColumn(column);
        }
        for (String primaryKey : tableDef.getPrimaryKeys()) {
            tableDefinition.addPrimaryKey(primaryKey);
        }
        for (UniqueDefinition uniqueKey : tableDef.getUniques()) {
            tableDefinition.addUnique(uniqueKey);
        }
        for (IndexDefinition index : tableDef.getIndexes()) {
            tableDefinition.addIndex(index);
        }
        CreateTableStatement create = new CreateTableStatement(tableDefinition, false);
        localCon.execute(create);
    }

    private void copyRowsAffectedAfterPartition(DbConnection localCon, String table, long lastSeqNumSynchro, boolean cleanupOccuredSincePartition) throws SQLException, DbConnectException {
        DeleteStatementBuilder delete = new DeleteStatementBuilder();
        delete.addTable(table + PARTITION_TABLE_SUFFIX);
        localCon.execute(delete.build());
        InsertStatementBuilder insert = new InsertStatementBuilder();
        insert.table(table + PARTITION_TABLE_SUFFIX);
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addTable(new Table(table));
        select.addColumn("*");
        if (!cleanupOccuredSincePartition) {
            OpGreater filter = SqlFilter.greater(SqlFilter.column("SequenceNumber"), SqlFilter.value(lastSeqNumSynchro));
            select.setFilter(filter);
        }
        insert.setSelectClause(select.build());
        localCon.execute(insert.build());
    }

    private void deleteRowsAffectedAfterPartition(DbConnection localCon, String table, long lastSeqNumSynchro, boolean cleanupOccuredSincePartition) throws SQLException, DbConnectException {
        DeleteStatementBuilder delete = new DeleteStatementBuilder();
        delete.addTable(table);
        if (!cleanupOccuredSincePartition) {
            OpGreater filter = SqlFilter.greater(SqlFilter.column("SequenceNumber"), SqlFilter.value(lastSeqNumSynchro));
            delete.setFilter(filter);
        }
        localCon.execute(delete.build());
    }

    public void doPartitionResolution(DbConnection localCon, DbConnection sourceCon, StatementExecutorHelperI primaryInstance, long lastSeqNumSynchro) throws SQLException, DbConnectException, UnsupportedFacet, DataFormatException, NotPrimary, RequestExecutionException {
        long time = System.currentTimeMillis();
        for (TableInfo table : this.tables) {
            this.createPartitionConflictsTable(localCon, table);
            this.doSourceRowDeletedLocalRowInserted(localCon, primaryInstance, table.getName(), table.globallyUniqueKey(), table.getTableDefinition().getForeignKeys(), lastSeqNumSynchro, time);
            this.doSourceRowUpdatedLocalRowUpdated(localCon, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro, time);
            long lastCleanUpSeqNum = this.counters.getLong(localCon, COUNTER_LAST_LOCAL_CLEANUP, table.getName());
            if (lastCleanUpSeqNum > lastSeqNumSynchro) {
                this.doSourceRowUpdatedLocalRowDeleted(localCon, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro, time);
                this.doSourceRowUnmodifiedLocalRowDeleted(localCon, primaryInstance, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro, time);
            } else {
                this.doSourceRowUpdatedLocalRowMovedToDeleteLog(localCon, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro, time);
                this.doSourceRowUnmodifiedLocalRowMovedToDeleteLog(localCon, primaryInstance, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro, time);
            }
            this.doSourceRowUnmodifiedLocalRowUpdated(localCon, primaryInstance, table.getName(), table.globallyUniqueKey(), lastSeqNumSynchro, time);
        }
    }

    private void createPartitionConflictsTable(DbConnection localCon, TableInfo table) throws SQLException, DbConnectException {
        TableDefinition tableDefinition = new TableDefinition(table.getName() + CONFLICTS_TABLE_SUFFIX);
        for (ColumnDefinition column : table.getTableDefinition().getColumns()) {
            tableDefinition.addColumn(column);
        }
        tableDefinition.addColumn(ColumnDefinition.column(COLUMN_PARTITION_RESOLUTION_TIME, ColumnDefinition.Type.DATE, ColumnDefinition.NullRestriction.NOT_NULL));
        tableDefinition.addColumn(ColumnDefinition.column(COLUMN_CONFLICT_TYPE, ColumnDefinition.Type.STRING, ColumnDefinition.NullRestriction.NOT_NULL));
        for (IndexDefinition index : table.getTableDefinition().getIndexes()) {
            tableDefinition.addIndex(index);
        }
        tableDefinition.addIndex(IndexDefinition.index(COLUMN_CONFLICT_TYPE, COLUMN_CONFLICT_TYPE));
        CreateTableStatement create = new CreateTableStatement(tableDefinition, false);
        localCon.execute(create);
    }

    private void fetchSourceRowsUnmodifiedLocalRowUpdated(DbConnection localCon, DbConnection sourceCon, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro) throws SQLException, DbConnectException {
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addColumn(tableName + PARTITION_TABLE_SUFFIX + ".*");
        IFilterElement filter = null;
        select.addTable(Join.left((ISource)new Table(tableName + PARTITION_TABLE_SUFFIX), (ISource)new Table(tableName), globallyUniqueKey));
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.isNull(new Column(tableName + "." + partialKey)));
        }
        filter = this.addToFilter(filter, SqlFilter.greater(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        ResultSet selectedRows = localCon.execute(select.build());
        ArrayList<InsertStatement> inserts = new ArrayList<InsertStatement>();
        while (selectedRows.next()) {
            SelectStatementBuilder selectSource = new SelectStatementBuilder();
            selectSource.addColumn(tableName + ".*");
            IFilterElement filterSource = null;
            selectSource.addTable(new Table(tableName));
            for (String partialKey : globallyUniqueKey) {
                filterSource = this.addToFilter(filterSource, SqlFilter.equal(new Column(partialKey), new Value(selectedRows.getString(partialKey))));
            }
            filterSource = this.addToFilter(filterSource, SqlFilter.lessEqual(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
            selectSource.setFilter(filterSource);
            ResultSet selectedSourceRows = sourceCon.execute(selectSource.build());
            ResultSetMetaData metaData = selectedSourceRows.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (selectedSourceRows.next()) {
                InsertStatementBuilder insertBuilder = new InsertStatementBuilder();
                insertBuilder.table(tableName);
                for (int col = 1; col <= columnCount; ++col) {
                    String columnName = metaData.getColumnName(col);
                    String columnValue = selectedSourceRows.getString(columnName);
                    insertBuilder.addValue(columnName, columnValue);
                }
                inserts.add(insertBuilder.build());
            }
        }
        for (InsertStatement insert : inserts) {
            localCon.execute(insert);
        }
    }

    private void fetchSourceRowsUnmodifiedLocalRowMovedToDeleteLog(DbConnection localCon, DbConnection sourceCon, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro) throws SQLException, DbConnectException {
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addColumn(DeleteLogger.getDeleteLogTableName(tableName) + PARTITION_TABLE_SUFFIX + ".*");
        IFilterElement filter = null;
        select.addTable(Join.left((ISource)new Table(DeleteLogger.getDeleteLogTableName(tableName) + PARTITION_TABLE_SUFFIX), (ISource)new Table(tableName), globallyUniqueKey));
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.isNull(new Column(tableName + "." + partialKey)));
        }
        select.setFilter(filter);
        ResultSet selectedRows = localCon.execute(select.build());
        ArrayList<InsertStatement> inserts = new ArrayList<InsertStatement>();
        while (selectedRows.next()) {
            SelectStatementBuilder selectSource = new SelectStatementBuilder();
            selectSource.addColumn(tableName + ".*");
            IFilterElement filterSource = null;
            selectSource.addTable(new Table(tableName));
            for (String partialKey : globallyUniqueKey) {
                filterSource = this.addToFilter(filterSource, SqlFilter.equal(new Column(partialKey), new Value(selectedRows.getString(partialKey))));
            }
            filterSource = this.addToFilter(filterSource, SqlFilter.lessEqual(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
            selectSource.setFilter(filterSource);
            ResultSet selectedSourceRows = sourceCon.execute(selectSource.build());
            ResultSetMetaData metaData = selectedSourceRows.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (selectedSourceRows.next()) {
                InsertStatementBuilder insertBuilder = new InsertStatementBuilder();
                insertBuilder.table(tableName);
                for (int col = 1; col <= columnCount; ++col) {
                    String columnName = metaData.getColumnName(col);
                    String columnValue = selectedSourceRows.getString(columnName);
                    insertBuilder.addValue(columnName, columnValue);
                }
                inserts.add(insertBuilder.build());
            }
        }
        for (InsertStatement insert : inserts) {
            localCon.execute(insert);
        }
    }

    private void doSourceRowDeletedLocalRowWithParentConflict(DbConnection localCon, StatementExecutorHelperI primaryInstance, String tableName, List<String> globallyUniqueKey, List<ForeignKeyDefinition> foreignKeys, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException, DataFormatException, NotPrimary, RequestExecutionException {
        for (ForeignKeyDefinition foreignKey : foreignKeys) {
            InsertStatementBuilder insert = new InsertStatementBuilder();
            insert.table(tableName + CONFLICTS_TABLE_SUFFIX);
            SelectStatementBuilder select = new SelectStatementBuilder();
            select.addColumn(tableName + PARTITION_TABLE_SUFFIX + ".*");
            select.addColumn(new Aliased(new Value(new Timestamp(partitionResolutionTime)), COLUMN_PARTITION_RESOLUTION_TIME));
            select.addColumn(new Aliased(new Value(ConflictType.SOURCE_ROW_DELETED_LOCAL_ROW_UPDATED), COLUMN_CONFLICT_TYPE));
            IFilterElement onClause = null;
            for (int i = 0; i < foreignKey.getColumns().length; ++i) {
                onClause = this.addToFilter(onClause, SqlFilter.equal(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + foreignKey.getColumns()[i]), new Column(foreignKey.getReferencedTable() + CONFLICTS_TABLE_SUFFIX + "." + foreignKey.getReferencedColumns()[i])));
            }
            onClause = this.addToFilter(onClause, SqlFilter.equal(new Column(foreignKey.getReferencedTable() + CONFLICTS_TABLE_SUFFIX + "." + COLUMN_PARTITION_RESOLUTION_TIME), new Value(new Timestamp(partitionResolutionTime))));
            select.addTable(Join.left((ISource)Join.left((ISource)new Table(tableName + PARTITION_TABLE_SUFFIX), (ISource)new Table(tableName), globallyUniqueKey), (ISource)new Table(foreignKey.getReferencedTable() + CONFLICTS_TABLE_SUFFIX), onClause));
            IFilterElement filter = null;
            for (String partialKey : globallyUniqueKey) {
                filter = this.addToFilter(filter, SqlFilter.isNull(new Column(tableName + "." + partialKey)));
            }
            for (String referencedColumn : foreignKey.getReferencedColumns()) {
                filter = this.addToFilter(filter, SqlFilter.not(SqlFilter.isNull(new Column(foreignKey.getReferencedTable() + CONFLICTS_TABLE_SUFFIX + "." + referencedColumn))));
            }
            select.setFilter(filter);
            insert.setSelectClause(select.build());
            localCon.execute(insert.build());
        }
    }

    private void doSourceRowDeletedLocalRowInserted(DbConnection localCon, StatementExecutorHelperI primaryInstance, String tableName, List<String> globallyUniqueKey, List<ForeignKeyDefinition> foreignKeys, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException, DataFormatException, NotPrimary, RequestExecutionException {
        this.doSourceRowDeletedLocalRowWithParentConflict(localCon, primaryInstance, tableName, globallyUniqueKey, foreignKeys, lastSeqNumSynchro, partitionResolutionTime);
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addColumn(tableName + PARTITION_TABLE_SUFFIX + ".*");
        IFilterElement onClause = null;
        for (String partialKey : globallyUniqueKey) {
            onClause = this.addToFilter(onClause, SqlFilter.equal(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + partialKey), new Column(tableName + CONFLICTS_TABLE_SUFFIX + "." + partialKey)));
        }
        onClause = this.addToFilter(onClause, SqlFilter.equal(new Column(tableName + CONFLICTS_TABLE_SUFFIX + "." + COLUMN_PARTITION_RESOLUTION_TIME), new Value(new Timestamp(partitionResolutionTime))));
        select.addTable(Join.left((ISource)Join.left((ISource)new Table(tableName + PARTITION_TABLE_SUFFIX), (ISource)new Table(tableName), globallyUniqueKey), (ISource)new Table(tableName + CONFLICTS_TABLE_SUFFIX), onClause));
        IFilterElement filter = null;
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.isNull(new Column(tableName + "." + partialKey)));
            filter = this.addToFilter(filter, SqlFilter.isNull(new Column(tableName + CONFLICTS_TABLE_SUFFIX + "." + partialKey)));
        }
        filter = this.addToFilter(filter, SqlFilter.greater(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        ResultSet selectedRows = localCon.execute(select.build());
        ResultSetMetaData metaData = selectedRows.getMetaData();
        int columnCount = metaData.getColumnCount();
        while (selectedRows.next()) {
            InsertStatementBuilder insertBuilder = new InsertStatementBuilder();
            insertBuilder.table(tableName);
            for (int col = 1; col <= columnCount; ++col) {
                String columnName = metaData.getColumnName(col);
                String columnValue = selectedRows.getString(columnName);
                if (columnName.equalsIgnoreCase("SequenceNumber")) continue;
                insertBuilder.addValue(columnName, columnValue);
            }
            primaryInstance.execute(insertBuilder.build());
        }
    }

    private void doSourceRowUpdatedLocalRowUpdated(DbConnection localCon, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException {
        InsertStatementBuilder insert = new InsertStatementBuilder();
        insert.table(tableName + CONFLICTS_TABLE_SUFFIX);
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addColumn(tableName + PARTITION_TABLE_SUFFIX + ".*");
        select.addColumn(new Aliased(new Value(new Timestamp(partitionResolutionTime)), COLUMN_PARTITION_RESOLUTION_TIME));
        select.addColumn(new Aliased(new Value(ConflictType.SOURCE_ROW_UPDATED_LOCAL_ROW_UPDATED), COLUMN_CONFLICT_TYPE));
        IFilterElement filter = null;
        select.addTable(Join.left((ISource)new Table(tableName + PARTITION_TABLE_SUFFIX), (ISource)new Table(tableName), globallyUniqueKey));
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.not(SqlFilter.isNull(new Column(tableName + "." + partialKey))));
        }
        filter = this.addToFilter(filter, SqlFilter.greater(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        filter = this.addToFilter(filter, SqlFilter.greater(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        insert.setSelectClause(select.build());
        localCon.execute(insert.build());
    }

    private void doSourceRowUpdatedLocalRowDeleted(DbConnection localCon, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException {
        InsertStatementBuilder insert = new InsertStatementBuilder();
        insert.table(tableName + CONFLICTS_TABLE_SUFFIX);
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addColumn(tableName + ".*");
        select.addColumn(new Aliased(new Value(new Timestamp(partitionResolutionTime)), COLUMN_PARTITION_RESOLUTION_TIME));
        select.addColumn(new Aliased(new Value(ConflictType.SOURCE_ROW_UPDATED_LOCAL_ROW_DELETED), COLUMN_CONFLICT_TYPE));
        IFilterElement filter = null;
        select.addTable(Join.left((ISource)new Table(tableName), (ISource)new Table(tableName + PARTITION_TABLE_SUFFIX), globallyUniqueKey));
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.isNull(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + partialKey)));
        }
        filter = this.addToFilter(filter, SqlFilter.greater(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        insert.setSelectClause(select.build());
        localCon.execute(insert.build());
    }

    private void doSourceRowUnmodifiedLocalRowDeleted(DbConnection localCon, StatementExecutorHelperI primaryInstance, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException, UnsupportedFacet, DataFormatException, NotPrimary, RequestExecutionException {
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addTable(Join.left((ISource)new Table(tableName), (ISource)new Table(tableName + PARTITION_TABLE_SUFFIX), globallyUniqueKey));
        select.addColumn(tableName + ".*");
        IFilterElement filter = null;
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.isNull(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + partialKey)));
        }
        filter = this.addToFilter(filter, SqlFilter.lessEqual(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        ResultSet selectedRows = localCon.execute(select.build());
        ResultSetMetaData metaData = selectedRows.getMetaData();
        int columnCount = metaData.getColumnCount();
        while (selectedRows.next()) {
            DeleteStatementBuilder deleteBuilder = new DeleteStatementBuilder();
            deleteBuilder.addTable(tableName);
            filter = null;
            for (String partialKey : globallyUniqueKey) {
                filter = this.addToFilter(filter, SqlFilter.equal(new Column(partialKey), new Value(selectedRows.getString(partialKey))));
            }
            filter = this.addToFilter(filter, SqlFilter.lessEqual(new Column("SequenceNumber"), new Value(lastSeqNumSynchro)));
            deleteBuilder.setFilter(filter);
            int affectedRows = primaryInstance.execute(deleteBuilder.build());
            if (affectedRows != 0) continue;
            InsertStatementBuilder insertBuilder = new InsertStatementBuilder();
            insertBuilder.table(tableName + CONFLICTS_TABLE_SUFFIX);
            for (int col = 1; col <= columnCount; ++col) {
                String columnName = metaData.getColumnName(col);
                String columnValue = selectedRows.getString(columnName);
                insertBuilder.addValue(columnName, columnValue);
            }
            insertBuilder.addValue(COLUMN_PARTITION_RESOLUTION_TIME, new Timestamp(partitionResolutionTime));
            insertBuilder.addValue(COLUMN_CONFLICT_TYPE, ConflictType.SOURCE_ROW_UPDATED_LOCAL_ROW_DELETED);
            primaryInstance.execute(insertBuilder.build());
        }
    }

    private void doSourceRowUpdatedLocalRowMovedToDeleteLog(DbConnection localCon, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException {
        InsertStatementBuilder insert = new InsertStatementBuilder();
        insert.table(tableName + CONFLICTS_TABLE_SUFFIX);
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addColumn(tableName + ".*");
        select.addColumn(new Aliased(new Value(new Timestamp(partitionResolutionTime)), COLUMN_PARTITION_RESOLUTION_TIME));
        select.addColumn(new Aliased(new Value(ConflictType.SOURCE_ROW_UPDATED_LOCAL_ROW_DELETED), COLUMN_CONFLICT_TYPE));
        IFilterElement filter = null;
        select.addTable(Join.left((ISource)new Table(tableName), (ISource)new Table(DeleteLogger.getDeleteLogTableName(tableName) + PARTITION_TABLE_SUFFIX), globallyUniqueKey));
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.not(SqlFilter.isNull(new Column(DeleteLogger.getDeleteLogTableName(tableName) + PARTITION_TABLE_SUFFIX + "." + partialKey))));
        }
        filter = this.addToFilter(filter, SqlFilter.greater(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        insert.setSelectClause(select.build());
        localCon.execute(insert.build());
    }

    private void doSourceRowUnmodifiedLocalRowMovedToDeleteLog(DbConnection localCon, StatementExecutorHelperI primaryInstance, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException, UnsupportedFacet, DataFormatException, NotPrimary, RequestExecutionException {
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addTable(Join.left((ISource)new Table(tableName), (ISource)new Table(DeleteLogger.getDeleteLogTableName(tableName) + PARTITION_TABLE_SUFFIX), globallyUniqueKey));
        select.addColumn(tableName + ".*");
        IFilterElement filter = null;
        for (String partialKey : globallyUniqueKey) {
            filter = this.addToFilter(filter, SqlFilter.not(SqlFilter.isNull(new Column(DeleteLogger.getDeleteLogTableName(tableName) + PARTITION_TABLE_SUFFIX + "." + partialKey))));
        }
        filter = this.addToFilter(filter, SqlFilter.lessEqual(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        ResultSet selectedRows = localCon.execute(select.build());
        ResultSetMetaData metaData = selectedRows.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<InsertStatement> conflicts = new ArrayList<InsertStatement>();
        while (selectedRows.next()) {
            DeleteStatementBuilder deleteBuilder = new DeleteStatementBuilder();
            deleteBuilder.addTable(tableName);
            filter = null;
            for (String partialKey : globallyUniqueKey) {
                filter = this.addToFilter(filter, SqlFilter.equal(new Column(partialKey), new Value(selectedRows.getString(partialKey))));
            }
            filter = this.addToFilter(filter, SqlFilter.lessEqual(new Column("SequenceNumber"), new Value(lastSeqNumSynchro)));
            deleteBuilder.setFilter(filter);
            int affectedRows = primaryInstance.execute(deleteBuilder.build());
            if (affectedRows != 0) continue;
            InsertStatementBuilder insertBuilder = new InsertStatementBuilder();
            insertBuilder.table(tableName + CONFLICTS_TABLE_SUFFIX);
            for (int col = 1; col <= columnCount; ++col) {
                String columnName = metaData.getColumnName(col);
                String columnValue = selectedRows.getString(columnName);
                insertBuilder.addValue(columnName, columnValue);
            }
            insertBuilder.addValue(COLUMN_PARTITION_RESOLUTION_TIME, new Timestamp(partitionResolutionTime));
            insertBuilder.addValue(COLUMN_CONFLICT_TYPE, ConflictType.SOURCE_ROW_UPDATED_LOCAL_ROW_DELETED);
            conflicts.add(insertBuilder.build());
        }
        for (InsertStatement conflict : conflicts) {
            localCon.execute(conflict);
        }
    }

    private void doSourceRowUnmodifiedLocalRowUpdated(DbConnection localCon, StatementExecutorHelperI primaryInstance, String tableName, List<String> globallyUniqueKey, long lastSeqNumSynchro, long partitionResolutionTime) throws SQLException, DbConnectException, UnsupportedFacet, DataFormatException, NotPrimary, RequestExecutionException {
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addTable(Join.left((ISource)new Table(tableName + PARTITION_TABLE_SUFFIX), (ISource)new Table(tableName), globallyUniqueKey));
        select.addColumn(tableName + PARTITION_TABLE_SUFFIX + ".*");
        IFilterElement filter = null;
        filter = this.addToFilter(filter, SqlFilter.lessEqual(new Column(tableName + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        filter = this.addToFilter(filter, SqlFilter.greater(new Column(tableName + PARTITION_TABLE_SUFFIX + "." + "SequenceNumber"), new Value(lastSeqNumSynchro)));
        select.setFilter(filter);
        ResultSet selectedRows = localCon.execute(select.build());
        ResultSetMetaData metaData = selectedRows.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<InsertStatement> conflicts = new ArrayList<InsertStatement>();
        while (selectedRows.next()) {
            UpdateStatementBuilder updateBuilder = new UpdateStatementBuilder();
            updateBuilder.table(tableName);
            for (int col = 1; col <= columnCount; ++col) {
                String columnName = metaData.getColumnName(col);
                String columnValue = selectedRows.getString(columnName);
                if (columnName.equalsIgnoreCase("SequenceNumber") || globallyUniqueKey.contains(columnName)) continue;
                updateBuilder.addValue(columnName, columnValue);
            }
            filter = null;
            for (String partialKey : globallyUniqueKey) {
                filter = this.addToFilter(filter, SqlFilter.equal(new Column(partialKey), new Value(selectedRows.getString(partialKey))));
            }
            filter = this.addToFilter(filter, SqlFilter.lessEqual(new Column("SequenceNumber"), new Value(lastSeqNumSynchro)));
            updateBuilder.setFilter(filter);
            int affectedRows = primaryInstance.execute(updateBuilder.build());
            if (affectedRows != 0) continue;
            InsertStatementBuilder insertBuilder = new InsertStatementBuilder();
            insertBuilder.table(tableName + CONFLICTS_TABLE_SUFFIX);
            for (int col = 1; col <= columnCount; ++col) {
                String columnName = metaData.getColumnName(col);
                String columnValue = selectedRows.getString(columnName);
                insertBuilder.addValue(columnName, columnValue);
            }
            insertBuilder.addValue(COLUMN_PARTITION_RESOLUTION_TIME, new Timestamp(partitionResolutionTime));
            insertBuilder.addValue(COLUMN_CONFLICT_TYPE, ConflictType.SOURCE_ROW_UPDATED_LOCAL_ROW_UPDATED);
            conflicts.add(insertBuilder.build());
        }
        for (InsertStatement conflict : conflicts) {
            localCon.execute(conflict);
        }
    }

    private IFilterElement addToFilter(IFilterElement filter, IFilterElement newFilter) {
        if (filter == null) {
            return newFilter;
        }
        return SqlFilter.and(filter, newFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizePartitionResolution(DbConnection localCon) throws SQLException, DbConnectException {
        DbConnection.Lock lock = null;
        try {
            lock = localCon.getLock();
            localCon.setAutoCommit(false);
            for (int i = this.tables.length - 1; i >= 0; --i) {
                this.counters.erase(localCon, COUNTER_RESOLUTION_IN_PROGRESS, this.tables[i].getName());
                this.counters.erase(localCon, COUNTER_LAST_LOCAL_CLEANUP, this.tables[i].getName());
                this.dropTable(localCon, this.tables[i].getName() + PARTITION_TABLE_SUFFIX);
                this.dropTable(localCon, DeleteLogger.getDeleteLogTableName(this.tables[i].getName()) + PARTITION_TABLE_SUFFIX);
            }
            localCon.commit();
            localCon.setAutoCommit(true);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void dropTable(DbConnection localCon, String tableName) throws SQLException, DbConnectException {
        DropTableStatement drop = new DropTableStatement(tableName, false, true);
        localCon.execute(drop);
    }

    static class ConflictType {
        static String SOURCE_ROW_DELETED_LOCAL_ROW_UPDATED = "SourceRowDeletedLocalRowUpdated";
        static String SOURCE_ROW_MOVED_TO_DELETE_LOG_LOCAL_ROW_UPDATED = "SourceRowMovedToDeleteLogLocalRowUpdated";
        static String SOURCE_ROW_UPDATED_LOCAL_ROW_DELETED = "SourceRowUpdatedLocalRowDeleted";
        static String SOURCE_ROW_UPDATED_LOCAL_ROW_UPDATED = "SourceRowUpdatedLocalRowUpdated";

        ConflictType() {
        }
    }
}

