/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.BaseDbConnectionDecorator;
import Xm.JavaUtils.Database.ConnectionObserver;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.SqlWriteStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserveableConnection
extends BaseDbConnectionDecorator {
    private List<ConnectionObserver> connectionObservers;
    private List<SqlWriteStatement> accumulatedStatements;

    public ObserveableConnection(DbConnection underlyingConnection, List<ConnectionObserver> connectionObservers) {
        super(underlyingConnection);
        this.connectionObservers = connectionObservers;
        this.accumulatedStatements = new ArrayList<SqlWriteStatement>();
    }

    @Override
    public int execute(SqlWriteStatement statement) throws SQLException, DbConnectException {
        int ret = this.getConnection().execute(statement);
        this.accumulatedStatements.add(statement);
        if (this.getAutoCommit()) {
            this.sendStatements();
        }
        return ret;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException, DbConnectException {
        super.setAutoCommit(autoCommit);
        if (this.getAutoCommit()) {
            this.sendStatements();
        }
    }

    @Override
    public void commit() throws SQLException, DbConnectException {
        super.commit();
        this.sendStatements();
    }

    @Override
    public void rollback() throws SQLException, DbConnectException {
        super.rollback();
        this.accumulatedStatements.clear();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.accumulatedStatements.clear();
    }

    private void sendStatements() {
        for (ConnectionObserver co : this.connectionObservers) {
            for (SqlWriteStatement statement : this.accumulatedStatements) {
                co.postExecuteStatement(statement);
            }
        }
        this.accumulatedStatements.clear();
    }
}

