/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.Aliased;
import Xm.JavaUtils.Database.BatchStatement;
import Xm.JavaUtils.Database.Column;
import Xm.JavaUtils.Database.ColumnDefinition;
import Xm.JavaUtils.Database.CreateFunctionStatement;
import Xm.JavaUtils.Database.CreateTableStatement;
import Xm.JavaUtils.Database.CreateTriggerStatement;
import Xm.JavaUtils.Database.DeleteStatement;
import Xm.JavaUtils.Database.DropFunctionStatement;
import Xm.JavaUtils.Database.DropTableStatement;
import Xm.JavaUtils.Database.DropTriggerStatement;
import Xm.JavaUtils.Database.ForeignKeyDefinition;
import Xm.JavaUtils.Database.FullTextDefinition;
import Xm.JavaUtils.Database.FunctionCall;
import Xm.JavaUtils.Database.FunctionDefinition;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.IFilterElementToString;
import Xm.JavaUtils.Database.ISource;
import Xm.JavaUtils.Database.IndexDefinition;
import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.Join;
import Xm.JavaUtils.Database.LockTablesStatement;
import Xm.JavaUtils.Database.Match;
import Xm.JavaUtils.Database.NullValue;
import Xm.JavaUtils.Database.OpAnd;
import Xm.JavaUtils.Database.OpEqual;
import Xm.JavaUtils.Database.OpExists;
import Xm.JavaUtils.Database.OpGreater;
import Xm.JavaUtils.Database.OpGreaterEqual;
import Xm.JavaUtils.Database.OpIn;
import Xm.JavaUtils.Database.OpLess;
import Xm.JavaUtils.Database.OpLessEqual;
import Xm.JavaUtils.Database.OpLike;
import Xm.JavaUtils.Database.OpNot;
import Xm.JavaUtils.Database.OpNotEqual;
import Xm.JavaUtils.Database.OpNull;
import Xm.JavaUtils.Database.OpOr;
import Xm.JavaUtils.Database.ParameterDefinition;
import Xm.JavaUtils.Database.RenameTablesStatement;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SqlStatementToString;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.SubSelect;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.TableDefinition;
import Xm.JavaUtils.Database.TriggerDefinition;
import Xm.JavaUtils.Database.UniqueDefinition;
import Xm.JavaUtils.Database.UnlockTablesStatement;
import Xm.JavaUtils.Database.UpdateStatement;
import Xm.JavaUtils.Database.Value;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlStatementBuilder
implements SqlStatementToString,
IFilterElementToString {
    @Override
    public String toString(SelectStatement statement) {
        List<String> unionOrders;
        SelectStatement union;
        List<String> orders;
        List<String> groups;
        IFilterElement f;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ").append(statement.isDistinct() ? "DISTINCT " : "");
        this.appendToBuffer(statement.columns(), buffer, ", ");
        if (!statement.tables().isEmpty()) {
            buffer.append(" FROM ");
            ArrayList<String> l = new ArrayList<String>();
            Iterator<ISource> it = statement.tables().iterator();
            while (it.hasNext()) {
                l.add(it.next().toString(this));
            }
            this.appendCollectionToBuffer(l, buffer);
        }
        if ((f = statement.getFilter()) != null) {
            buffer.append(" WHERE ").append(f.toString(this));
        }
        if (!(groups = statement.groups()).isEmpty()) {
            buffer.append(" GROUP BY ");
            this.appendCollectionToBuffer(groups, buffer);
        }
        if (!(orders = statement.orders()).isEmpty()) {
            buffer.append(" ORDER BY ");
            this.appendCollectionToBuffer(orders, buffer);
        }
        if (statement.maxLimit() >= 0) {
            buffer.append(" LIMIT ");
            if (statement.beginLimit() >= 0) {
                buffer.append(statement.beginLimit());
                buffer.append(", ");
            }
            buffer.append(statement.maxLimit());
        }
        if ((union = statement.getUnion()) != null) {
            buffer.insert(0, "(");
            buffer.append(") UNION (");
            buffer.append(this.toString(union) + ")");
        }
        if (!(unionOrders = statement.getUnionOrders()).isEmpty()) {
            buffer.append(" ORDER BY ");
            this.appendCollectionToBuffer(unionOrders, buffer);
        }
        if (statement.getUnionMaxLimit() >= 0) {
            buffer.append(" LIMIT ");
            if (statement.getUnionBeginLimit() >= 0) {
                buffer.append(statement.getUnionBeginLimit());
                buffer.append(", ");
            }
            buffer.append(statement.getUnionMaxLimit());
        }
        return buffer.toString();
    }

    @Override
    public String toString(InsertStatement statement) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT ");
        if (statement.isIgnoreDuplicates()) {
            buffer.append("IGNORE ");
        }
        buffer.append("INTO ");
        buffer.append(statement.table());
        SelectStatement selectClause = statement.selectClause();
        if (selectClause != null) {
            if (!statement.columns().isEmpty()) {
                buffer.append(" (");
                this.appendCollectionToBuffer(statement.columns(), buffer);
                buffer.append(")");
            }
            buffer.append(" ");
            buffer.append(selectClause.toString(this));
        } else {
            buffer.append(" (");
            this.appendCollectionToBuffer(statement.columns(), buffer);
            buffer.append(") VALUES (");
            this.appendToBuffer(statement.values(), buffer, ", ");
            buffer.append(")");
        }
        if (statement.onDuplicateKeyUpdate()) {
            buffer.append(" ON DUPLICATE KEY UPDATE ");
            this.appendCollectionToBuffer(statement.onDuplicateKeyUpdateColumns(), this.formatToString(statement.onDuplicateKeyUpdateValues()), " = ", ", ", buffer);
        }
        return buffer.toString();
    }

    @Override
    public String toString(DeleteStatement statement) {
        IFilterElement whereClauses;
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ");
        this.appendCollectionToBuffer(statement.tables(), buffer);
        List<ISource> using = statement.using();
        if (!using.isEmpty()) {
            buffer.append(" USING ");
            ArrayList<String> using_clause = new ArrayList<String>();
            for (ISource source : using) {
                using_clause.add(source.toString(this));
            }
            this.appendCollectionToBuffer(using_clause, buffer);
        }
        if ((whereClauses = statement.getFilter()) != null) {
            buffer.append(" WHERE ").append(whereClauses.toString(this));
        }
        return buffer.toString();
    }

    @Override
    public String toString(UpdateStatement statement) {
        List<String> formattedValues = this.formatToString(statement.values());
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ");
        buffer.append(statement.table());
        buffer.append(" SET ");
        this.appendCollectionToBuffer(statement.columns(), formattedValues, " = ", ", ", buffer);
        IFilterElement f = statement.getFilter();
        if (f != null) {
            buffer.append(" WHERE ").append(f.toString(this));
        }
        return buffer.toString();
    }

    private static String getColumType(ColumnDefinition.Type type) {
        switch (type.getSqlType()) {
            case 4: {
                return "INT";
            }
            case -6: {
                return "TINYINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 1: {
                return (type != ColumnDefinition.Type.BOOLEAN ? "N" : "") + "CHAR(" + type.getColumnSize() + ")";
            }
            case 12: {
                return "NVARCHAR(" + type.getColumnSize() + ")";
            }
            case -1: {
                return "TEXT CHARACTER SET UTF8";
            }
            case 93: {
                return "DATETIME";
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getColumType(ColumnDefinition column) {
        if (column.getType() == ColumnDefinition.Type.ENUM) {
            StringBuffer buf = new StringBuffer("ENUM(");
            String[] values = column.getEnumValues();
            if (values != null && values.length != 0) {
                buf.append(MySqlStatementBuilder.getDbRepresentation(values[0]));
                for (int i = 1; i < values.length; ++i) {
                    buf.append(",").append(MySqlStatementBuilder.getDbRepresentation(values[i]));
                }
            }
            buf.append(")");
            return buf.toString();
        }
        return MySqlStatementBuilder.getColumType(column.getType());
    }

    private static String getColumn(ColumnDefinition column) {
        Value defaultValue;
        StringBuffer buffer = new StringBuffer();
        buffer.append(column.getName());
        buffer.append(" ");
        buffer.append(MySqlStatementBuilder.getColumType(column));
        if (column.getNull() == ColumnDefinition.NullRestriction.NOT_NULL) {
            buffer.append(" NOT NULL");
        }
        if ((defaultValue = column.getDefaultValue()) != null) {
            buffer.append(" DEFAULT ");
            Object obj = defaultValue.getLiteral();
            if (obj instanceof Boolean) {
                buffer.append(MySqlStatementBuilder.getDbRepresentation((Boolean)obj));
            } else if (obj instanceof String) {
                buffer.append(MySqlStatementBuilder.getDbRepresentation((String)obj));
            } else {
                buffer.append(obj.toString());
            }
        }
        return buffer.toString();
    }

    private static List<String> getColumns(List<ColumnDefinition> columnDefinitions) {
        ArrayList<String> columns = new ArrayList<String>();
        Iterator<ColumnDefinition> iter = columnDefinitions.iterator();
        while (iter.hasNext()) {
            columns.add(MySqlStatementBuilder.getColumn(iter.next()));
        }
        return columns;
    }

    private static String toOne(String[] columns) {
        if (columns.length == 0) {
            return "";
        }
        if (columns.length == 1) {
            return columns[0];
        }
        StringBuffer buffer = new StringBuffer(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            buffer.append(", ").append(columns[i]);
        }
        return buffer.toString();
    }

    private static String getForeignKey(ForeignKeyDefinition key) {
        ForeignKeyDefinition.OnUpdate onUpdateOption;
        StringBuffer buffer = new StringBuffer();
        buffer.append("FOREIGN KEY");
        if (!key.getName().equals("")) {
            buffer.append(" ").append(key.getName());
        }
        buffer.append(" (").append(MySqlStatementBuilder.toOne(key.getColumns())).append(")");
        buffer.append(" REFERENCES ");
        buffer.append(key.getReferencedTable());
        buffer.append(" (").append(MySqlStatementBuilder.toOne(key.getReferencedColumns())).append(")");
        ForeignKeyDefinition.OnDelete onDeleteOption = key.getOnDeleteOption();
        if (onDeleteOption != null) {
            if (onDeleteOption == ForeignKeyDefinition.OnDelete.CASCADE) {
                buffer.append(" ON DELETE CASCADE");
            } else if (onDeleteOption == ForeignKeyDefinition.OnDelete.SET_NULL) {
                buffer.append(" ON DELETE SET NULL");
            } else if (onDeleteOption == ForeignKeyDefinition.OnDelete.RESTRICT) {
                // empty if block
            }
        }
        if ((onUpdateOption = key.getOnUpdateOption()) != null) {
            if (onUpdateOption == ForeignKeyDefinition.OnUpdate.CASCADE) {
                buffer.append(" ON UPDATE CASCADE");
            } else if (onUpdateOption == ForeignKeyDefinition.OnUpdate.SET_NULL) {
                buffer.append(" ON UPDATE SET NULL");
            } else if (onUpdateOption == ForeignKeyDefinition.OnUpdate.RESTRICT) {
                // empty if block
            }
        }
        return buffer.toString();
    }

    private static List<String> getForeignKeys(List<ForeignKeyDefinition> foreignKeyDefinitions) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator<ForeignKeyDefinition> iter = foreignKeyDefinitions.iterator();
        while (iter.hasNext()) {
            keys.add(MySqlStatementBuilder.getForeignKey(iter.next()));
        }
        return keys;
    }

    private static String getIndex(IndexDefinition index) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("KEY");
        if (!index.getName().equals("")) {
            buffer.append(" ").append(index.getName());
        }
        buffer.append(" (").append(MySqlStatementBuilder.toOne(index.getColumns())).append(")");
        return buffer.toString();
    }

    private static List<String> getIndexes(List<IndexDefinition> indexDefinitions) {
        ArrayList<String> indexes = new ArrayList<String>();
        Iterator<IndexDefinition> iter = indexDefinitions.iterator();
        while (iter.hasNext()) {
            indexes.add(MySqlStatementBuilder.getIndex(iter.next()));
        }
        return indexes;
    }

    private static String getUnique(UniqueDefinition index) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UNIQUE");
        if (!index.getName().equals("")) {
            buffer.append(" ").append(index.getName());
        }
        buffer.append(" (").append(MySqlStatementBuilder.toOne(index.getColumns())).append(")");
        return buffer.toString();
    }

    private static List<String> getUniques(List<UniqueDefinition> uniqueDefinitions) {
        ArrayList<String> uniques = new ArrayList<String>();
        Iterator<UniqueDefinition> iter = uniqueDefinitions.iterator();
        while (iter.hasNext()) {
            uniques.add(MySqlStatementBuilder.getUnique(iter.next()));
        }
        return uniques;
    }

    private static String getFullText(FullTextDefinition fullText) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("FULLTEXT");
        if (!fullText.getName().equals("")) {
            buffer.append(" ").append(fullText.getName());
        }
        buffer.append(" (").append(MySqlStatementBuilder.toOne(fullText.getColumns())).append(")");
        return buffer.toString();
    }

    private static List<String> getFullTexts(List<FullTextDefinition> fullTextDefinitions) {
        ArrayList<String> fullTexts = new ArrayList<String>();
        Iterator<FullTextDefinition> iter = fullTextDefinitions.iterator();
        while (iter.hasNext()) {
            fullTexts.add(MySqlStatementBuilder.getFullText(iter.next()));
        }
        return fullTexts;
    }

    @Override
    public String toString(CreateTableStatement statement) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE ");
        if (statement.temporary()) {
            buffer.append("TEMPORARY ");
        }
        buffer.append("TABLE ");
        if (!statement.failIfExists()) {
            buffer.append("IF NOT EXISTS ");
        }
        TableDefinition table = statement.getTableDefinition();
        buffer.append(table.getName());
        String like = table.getLikeTable();
        if (like != null && !like.equals("")) {
            buffer.append(" LIKE ");
            buffer.append(like);
        } else {
            List<String> fullTexts;
            List<String> uniques;
            List<String> indexes;
            List<String> foreignKeys;
            List<String> primaryKeys;
            buffer.append(" (");
            List<String> columns = MySqlStatementBuilder.getColumns(table.getColumns());
            if (!columns.isEmpty()) {
                this.appendCollectionToBuffer(columns, buffer);
            }
            if (!(primaryKeys = table.getPrimaryKeys()).isEmpty()) {
                buffer.append(", PRIMARY KEY (");
                this.appendCollectionToBuffer(primaryKeys, buffer);
                buffer.append(")");
            }
            if (!(foreignKeys = MySqlStatementBuilder.getForeignKeys(table.getForeignKeys())).isEmpty()) {
                buffer.append(", ");
                this.appendCollectionToBuffer(foreignKeys, buffer);
            }
            if (!(indexes = MySqlStatementBuilder.getIndexes(table.getIndexes())).isEmpty()) {
                buffer.append(", ");
                this.appendCollectionToBuffer(indexes, buffer);
            }
            if (!(uniques = MySqlStatementBuilder.getUniques(table.getUniques())).isEmpty()) {
                buffer.append(", ");
                this.appendCollectionToBuffer(uniques, buffer);
            }
            if (!(fullTexts = MySqlStatementBuilder.getFullTexts(table.getFullTexts())).isEmpty()) {
                buffer.append(", ");
                this.appendCollectionToBuffer(fullTexts, buffer);
            }
            buffer.append(")");
            String storageEngine = table.getEngine() != null ? table.getEngine() : "INNODB";
            buffer.append(" ENGINE=").append(storageEngine);
        }
        return buffer.toString();
    }

    @Override
    public String toString(LockTablesStatement statement) {
        StringBuffer buffer = new StringBuffer("LOCK TABLES ");
        ArrayList<String> stringLockTypes = new ArrayList<String>();
        List<LockTablesStatement.LockType> lockTypes = statement.lockTypes();
        for (LockTablesStatement.LockType type : lockTypes) {
            if (type == LockTablesStatement.LockType.READ) {
                stringLockTypes.add("READ");
                continue;
            }
            stringLockTypes.add("WRITE");
        }
        this.appendCollectionToBuffer(statement.tables(), stringLockTypes, " ", ", ", buffer);
        return buffer.toString();
    }

    @Override
    public String toString(UnlockTablesStatement statement) {
        return "UNLOCK TABLES";
    }

    @Override
    public String toString(DropTableStatement statement) {
        StringBuffer buffer = new StringBuffer("DROP ");
        if (statement.temporary()) {
            buffer.append("TEMPORARY ");
        }
        buffer.append("TABLE ");
        if (statement.ifExists()) {
            buffer.append("IF EXISTS ");
        }
        buffer.append(statement.table());
        return buffer.toString();
    }

    @Override
    public String toString(RenameTablesStatement statement) {
        StringBuffer buffer = new StringBuffer("RENAME TABLE ");
        this.appendCollectionToBuffer(statement.oldNames(), statement.newNames(), " TO ", ", ", buffer);
        return buffer.toString();
    }

    @Override
    public String toString(BatchStatement statement) {
        SqlWriteStatement[] statements = statement.all();
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < statements.length; ++index) {
            if (index != 0) {
                buffer.append(" ");
            }
            buffer.append(statements[index].toString(this));
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public String toString(Table table) {
        return table.getName() + (table.getAlias().length() == 0 ? "" : " AS " + table.getAlias());
    }

    public String toString(ISource source) {
        if (source instanceof Table) {
            return this.toString((Table)source);
        }
        if (source instanceof Join) {
            return this.toString((Join)source);
        }
        if (source instanceof SubSelect) {
            return this.toString((SubSelect)source);
        }
        throw new IllegalArgumentException("Unexpected ISource subtype: " + source.getClass().getName());
    }

    @Override
    public String toString(Join join) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        buf.append(this.toString(join.getTable1()));
        if (join.getType() == Join.Type.STRAIGHT) {
            buf.append(" STRAIGHT_JOIN ");
        } else if (join.getType() == Join.Type.LEFT) {
            buf.append(" LEFT JOIN ");
        } else {
            buf.append(" JOIN ");
        }
        buf.append(this.toString(join.getTable2()));
        IFilterElement onClause = join.getOnClause();
        if (onClause != null) {
            buf.append(" ON ").append(onClause.toString(this));
        } else {
            List<String> using = join.getUsingClause();
            if (using != null) {
                buf.append(" USING (");
                this.appendCollectionToBuffer(using, buf);
                buf.append(")");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    private void appendCollectionToBuffer(Collection<String> col, StringBuffer buffer) {
        this.appendCollectionToBuffer(col, buffer, ", ");
    }

    private void appendCollectionToBuffer(Collection<String> col, StringBuffer buffer, String separator) {
        Iterator<String> iter = col.iterator();
        if (iter.hasNext()) {
            buffer.append(iter.next());
        }
        while (iter.hasNext()) {
            buffer.append(separator);
            buffer.append(iter.next());
        }
    }

    private void appendToBuffer(Collection<?> elements, StringBuffer buffer, String separator) {
        Iterator<?> iter = elements.iterator();
        if (iter.hasNext()) {
            buffer.append(this.formatToString(iter.next()));
        }
        while (iter.hasNext()) {
            buffer.append(separator);
            buffer.append(this.formatToString(iter.next()));
        }
    }

    private void appendCollectionToBuffer(Collection<String> col1, Collection<String> col2, String separator1, String separator2, StringBuffer buffer) {
        Iterator<String> iter1 = col1.iterator();
        Iterator<String> iter2 = col2.iterator();
        if (iter1.hasNext() && iter2.hasNext()) {
            buffer.append(iter1.next());
            buffer.append(separator1);
            buffer.append(iter2.next());
        }
        while (iter1.hasNext() && iter2.hasNext()) {
            buffer.append(separator2);
            buffer.append(iter1.next());
            buffer.append(separator1);
            buffer.append(iter2.next());
        }
    }

    public static String escapeCharacters(String value) {
        if (value == null) {
            return "";
        }
        StringBuffer escaped = new StringBuffer(value.length() * 2);
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    escaped.append("\\'");
                    continue block5;
                }
                case '\"': {
                    escaped.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block5;
                }
                default: {
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    private static String getDbRepresentation(boolean value) {
        return value ? "'1'" : "'0'";
    }

    private static String getDbRepresentation(Match value) {
        if (value != null) {
            return MySqlStatementBuilder.getDbRepresentation(value.getAgainst());
        }
        return "' '";
    }

    private static String getDbRepresentation(String value) {
        return "'" + MySqlStatementBuilder.escapeCharacters(value) + "'";
    }

    private static String getDbRepresentationForLike(String value) {
        StringBuffer formatted = new StringBuffer(value.length() * 2);
        formatted.append("'");
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    formatted.append("\\'");
                    continue block5;
                }
                case '\"': {
                    formatted.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    char next;
                    char c2 = next = i + 1 < value.length() ? value.charAt(i + 1) : (char)'\u0000';
                    if (next == '_' || next == '%') {
                        formatted.append(c);
                        continue block5;
                    }
                    formatted.append("\\\\\\\\");
                    continue block5;
                }
                default: {
                    formatted.append(c);
                }
            }
        }
        formatted.append("'");
        return formatted.toString();
    }

    private List<String> formatToString(List<Object> values) {
        ArrayList<String> formattedValues = new ArrayList<String>(values.size());
        for (Object value : values) {
            formattedValues.add(this.formatToString(value));
        }
        return formattedValues;
    }

    private String formatToString(Object obj) {
        if (obj instanceof IFilterElement) {
            return ((IFilterElement)obj).toString(this);
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        if (obj instanceof Long) {
            return obj.toString();
        }
        if (obj instanceof Boolean) {
            return MySqlStatementBuilder.getDbRepresentation((Boolean)obj);
        }
        if (obj instanceof String) {
            return MySqlStatementBuilder.getDbRepresentation((String)obj);
        }
        if (obj instanceof NullValue) {
            return "null";
        }
        if (obj instanceof Timestamp) {
            return MySqlStatementBuilder.getDbRepresentation(obj.toString());
        }
        throw new IllegalArgumentException("Type not supported: " + obj.getClass().getName());
    }

    @Override
    public String toString(Column column) {
        String table = column.getTable();
        return table == null ? column.getName() : table + "." + column.getName();
    }

    @Override
    public String toString(Value value) {
        if (value.getLiteral() instanceof Object[]) {
            List<Object> list = Arrays.asList((Object[])value.getLiteral());
            StringBuffer buffer = new StringBuffer();
            this.appendToBuffer(list, buffer, ", ");
            return buffer.toString();
        }
        return this.formatToString(value.getLiteral());
    }

    @Override
    public String toString(SubSelect element) {
        StringBuffer buf = new StringBuffer("(");
        buf.append(element.getSelect().toString(this)).append(")");
        if (element.getAlias() != null) {
            buf.append(" AS ").append(element.getAlias()).append(" ");
        }
        return buf.toString();
    }

    @Override
    public String toString(OpNull operator) {
        StringBuffer buffer = new StringBuffer();
        if (operator.getOp1() == null) {
            buffer.append(" IS NULL");
        } else {
            buffer.append(operator.getOp1().toString(this)).append(" IS NULL");
        }
        return buffer.toString();
    }

    @Override
    public String toString(OpEqual operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(" = ").append(operator.getOp2().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(OpNotEqual operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(" <> ").append(operator.getOp2().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(OpGreater operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(" > ").append(operator.getOp2().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(OpGreaterEqual operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(" >= ").append(operator.getOp2().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(OpIn operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(operator.getOp2() instanceof SubSelect ? " IN " : " IN (").append(operator.getOp2().toString(this)).append(operator.getOp2() instanceof SubSelect ? "" : ")");
        return buffer.toString();
    }

    @Override
    public String toString(OpLess operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(" < ").append(operator.getOp2().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(OpLessEqual operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(" <= ").append(operator.getOp2().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(OpLike operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(operator.getOp1().toString(this)).append(" LIKE ").append(this.forLike(operator.getOp2()));
        return buffer.toString();
    }

    private String forLike(IFilterElement element) {
        Object literal;
        if (element instanceof Value && (literal = ((Value)element).getLiteral()) instanceof String) {
            return MySqlStatementBuilder.getDbRepresentationForLike((String)literal);
        }
        return element.toString(this);
    }

    @Override
    public String toString(OpNot operator) {
        StringBuffer buffer = new StringBuffer();
        if (operator.getOp1() == null) {
            buffer.append(" NOT ");
        } else {
            buffer.append("NOT (").append(operator.getOp1().toString(this)).append(")");
        }
        return buffer.toString();
    }

    @Override
    public String toString(OpOr operator) {
        StringBuffer buffer = new StringBuffer();
        if (operator.getOp1() == null) {
            buffer.append(" OR ");
        } else {
            buffer.append('(').append(operator.getOp1().toString(this)).append(" OR ").append(operator.getOp2().toString(this)).append(')');
        }
        return buffer.toString();
    }

    @Override
    public String toString(OpAnd operator) {
        StringBuffer buffer = new StringBuffer();
        if (operator.getOp1() == null) {
            buffer.append(" AND ");
        } else {
            buffer.append('(').append(operator.getOp1().toString(this)).append(" AND ").append(operator.getOp2().toString(this)).append(')');
        }
        return buffer.toString();
    }

    @Override
    public String toString(OpExists operator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EXISTS ").append(operator.getOp1().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(Match match) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MATCH(");
        this.appendCollectionToBuffer(match.getColumns(), buffer);
        buffer.append(") AGAINST(");
        buffer.append(MySqlStatementBuilder.getDbRepresentation(match));
        if (match.isInBooleanMode()) {
            buffer.append(" IN BOOLEAN MODE");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String toString(Aliased aliased) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(aliased.getElement().toString(this));
        buffer.append(" AS ");
        buffer.append(aliased.getAlias());
        return buffer.toString();
    }

    @Override
    public String toString(CreateTriggerStatement statement) {
        TriggerDefinition trigger = statement.getTriggerDefinition();
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE TRIGGER ").append(trigger.getName());
        buffer.append(trigger.getTime() == TriggerDefinition.Time.BEFORE ? " BEFORE" : " AFTER");
        switch (trigger.getEvent()) {
            case DELETE: {
                buffer.append(" DELETE");
                break;
            }
            case UPDATE: {
                buffer.append(" UPDATE");
                break;
            }
            case INSERT: {
                buffer.append(" INSERT");
            }
        }
        buffer.append(" ON ").append(trigger.getTargetTable());
        buffer.append(" FOR EACH ROW ");
        buffer.append(trigger.getStatement().toString(this));
        return buffer.toString();
    }

    @Override
    public String toString(DropTriggerStatement statement) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DROP TRIGGER ").append(statement.getTriggerName());
        return buffer.toString();
    }

    @Override
    public String toString(FunctionCall call) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(call.getFunction().getName()).append("(");
        this.appendToBuffer(Arrays.asList(call.compileArgumentList()), buffer, ", ");
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String toString(CreateFunctionStatement statement) {
        FunctionDefinition func = statement.getFunction();
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE FUNCTION ").append(func.getName()).append(" (");
        int count = 0;
        for (ParameterDefinition param : func.getParameters()) {
            if (count++ > 0) {
                buffer.append(", ");
            }
            buffer.append("").append(param.getName()).append(" ").append(MySqlStatementBuilder.getColumType(param.getType()));
        }
        buffer.append(") RETURNS ").append(func.getReturnType()).append(" ");
        buffer.append(func.getBody());
        return buffer.toString();
    }

    @Override
    public String toString(DropFunctionStatement statement) {
        return "DROP FUNCTION " + (statement.getFailIfNotExist() ? "" : "IF EXISTS ") + statement.getName();
    }
}

