/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.AbstractDbConnection;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbInfo;
import Xm.JavaUtils.Database.DuplicateKeySqlException;
import Xm.JavaUtils.Database.ExtendedSqlException;
import Xm.JavaUtils.Database.ForeignKeySqlException;
import Xm.JavaUtils.Database.MySqlStatementBuilder;
import Xm.JavaUtils.Database.ResultSetGuard;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.SingletonFileLogger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQLDbConnection
extends AbstractDbConnection {
    private MySQLConnection m_connection;
    private MySqlStatementBuilder m_SqlStringBuilder;

    public MySQLDbConnection(DbInfo dbInfo) throws DbConnectException, SQLException {
        this(dbInfo, true);
    }

    public MySQLDbConnection(DbInfo dbInfo, boolean isStreamedConnection) throws DbConnectException, SQLException {
        this.m_connection = isStreamedConnection ? new MySQLStreamedConnection(dbInfo) : new MySQLConnection(dbInfo);
        this.m_SqlStringBuilder = new MySqlStatementBuilder();
        this.connect();
    }

    public DbInfo dbInfo() {
        return this.m_connection.getDbInfo();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException, DbConnectException {
        try {
            return this.retryGetMetaData();
        }
        catch (SQLException e) {
            MySQLDbConnection.throwBestException("getMetaData", e);
            throw e;
        }
    }

    private DatabaseMetaData retryGetMetaData() throws SQLException, DbConnectException {
        try {
            return this.tryGetMetaData();
        }
        catch (SQLException e) {
            this.assertRetryable(e);
            return this.tryGetMetaData();
        }
    }

    private DatabaseMetaData tryGetMetaData() throws SQLException, DbConnectException {
        return this.m_connection.getMetaData();
    }

    public synchronized ResultSet execute(SelectStatement statement) throws SQLException, DbConnectException {
        return this.executeSelect(statement.toString(this.m_SqlStringBuilder));
    }

    public synchronized ResultSet executeSelect(String query) throws SQLException, DbConnectException {
        try {
            return this.retryExecuteSelect(query);
        }
        catch (SQLException e) {
            MySQLDbConnection.throwBestException(query, e);
            throw e;
        }
    }

    private ResultSet retryExecuteSelect(String query) throws SQLException, DbConnectException {
        try {
            return this.tryExecuteSelect(query);
        }
        catch (SQLException e) {
            this.assertRetryable(e);
            return this.tryExecuteSelect(query);
        }
    }

    private ResultSet tryExecuteSelect(String query) throws SQLException, DbConnectException {
        String message = "(On " + this.dbInfo().host() + "): " + query;
        SingletonFileLogger.GetInstance().LogWriteLowLevel("XMJU24-004", message);
        return this.m_connection.execute(query);
    }

    public synchronized int execute(SqlWriteStatement statement) throws SQLException, DbConnectException {
        return this.executeUpdate(statement.toString(this.m_SqlStringBuilder));
    }

    public synchronized int executeUpdate(String query) throws SQLException, DbConnectException {
        try {
            return this.retryExecuteUpdate(query);
        }
        catch (SQLException e) {
            MySQLDbConnection.throwBestException(query, e);
            throw e;
        }
    }

    private int retryExecuteUpdate(String query) throws SQLException, DbConnectException {
        try {
            return this.tryExecuteUpdate(query);
        }
        catch (SQLException e) {
            this.assertRetryable(e);
            return this.tryExecuteUpdate(query);
        }
    }

    private int tryExecuteUpdate(String query) throws SQLException, DbConnectException {
        String message = "(On " + this.dbInfo().host() + "): " + query;
        SingletonFileLogger.GetInstance().LogWriteLowLevel("XMJU24-005", message);
        return this.m_connection.executeUpdate(query);
    }

    public synchronized boolean getAutoCommit() throws SQLException, DbConnectException {
        return this.m_connection.getAutoCommit();
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException, DbConnectException {
        try {
            boolean isCurrentlyAutoCommit = this.getAutoCommit();
            if (autoCommit != isCurrentlyAutoCommit) {
                if (!isCurrentlyAutoCommit && this.m_connection.needCommit()) {
                    this.rollback();
                }
                try {
                    this.m_connection.setAutoCommit(autoCommit);
                }
                catch (SQLException ex) {
                    this.assertRetryable(ex);
                    this.m_connection.setAutoCommit(autoCommit);
                }
            }
        }
        catch (SQLException e) {
            MySQLDbConnection.throwBestException("setAutoCommit", e);
            throw e;
        }
    }

    public synchronized void commit() throws SQLException, DbConnectException {
        try {
            this.m_connection.commit();
        }
        catch (SQLException e) {
            MySQLDbConnection.throwBestException("commit", e);
            throw e;
        }
    }

    public synchronized void rollback() throws SQLException, DbConnectException {
        try {
            this.m_connection.rollback();
        }
        catch (SQLException e) {
            MySQLDbConnection.throwBestException("rollback", e);
            throw e;
        }
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.m_connection.close();
    }

    public synchronized void closeActiveResultSet() throws SQLException {
        this.m_connection.closeActiveResultSet();
    }

    private void connect() throws DbConnectException, SQLException {
        try {
            this.m_connection.connect();
        }
        catch (SQLException e) {
            MySQLDbConnection.throwBestException("MySQLDbConnection connect", e);
            throw e;
        }
    }

    private static boolean isConnectionException(SQLException ex) {
        int errorCode = ex.getErrorCode();
        String sqlState = ex.getSQLState();
        String message = "SQLState = " + sqlState + ", ErrorCode = " + errorCode;
        if (sqlState != null && (sqlState.equalsIgnoreCase("08S01") || sqlState.equalsIgnoreCase("08003"))) {
            SingletonFileLogger.GetInstance().LogWriteWarning("XMJU24-445", "ConnectionException: " + message);
            return true;
        }
        SingletonFileLogger.GetInstance().LogWriteWarning("XMJU24-445", "SQLException: " + message);
        return false;
    }

    private static boolean isDuplicateKeyException(SQLException ex) {
        int code = ex.getErrorCode();
        return ex.getSQLState() != null && ex.getSQLState().equals("23000") && (code == 1062 || code == 1022 || code == 1169);
    }

    private static boolean isForeignKeyException(SQLException ex) {
        int code = ex.getErrorCode();
        return ex.getSQLState() != null && ex.getSQLState().equals("23000") && (code == 1216 || code == 1217 || code == 1451 || code == 1452);
    }

    private boolean isRetryable(SQLException ex) throws SQLException, DbConnectException {
        if ((MySQLDbConnection.isConnectionException(ex) || this.m_connection.isBroken(ex)) && this.getAutoCommit()) {
            SingletonFileLogger.GetInstance().LogWriteWarning("XMJU24-445", "Will try to reconnect");
            this.connect();
            return true;
        }
        return false;
    }

    private void assertRetryable(SQLException ex) throws SQLException, DbConnectException {
        if (!this.isRetryable(ex)) {
            throw ex;
        }
    }

    private static void throwBestException(String query, SQLException ex) throws SQLException, DbConnectException {
        if (MySQLDbConnection.isConnectionException(ex)) {
            throw new DbConnectException(ex.getMessage());
        }
        if (MySQLDbConnection.isDuplicateKeyException(ex)) {
            throw new DuplicateKeySqlException(query, ex);
        }
        if (MySQLDbConnection.isForeignKeyException(ex)) {
            throw new ForeignKeySqlException(query, ex);
        }
        throw new ExtendedSqlException(query, ex);
    }

    public DbConnection.Lock getLock() {
        return new DbConnection.Lock(){

            public void unlock() {
            }
        };
    }

    private static class MySQLStreamedConnection
    extends MySQLConnection {
        Statement m_jdbcStatement = null;
        ResultSet m_activeResultSet = null;

        public MySQLStreamedConnection(DbInfo dbInfo) {
            super(dbInfo);
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.closeActiveResultSet();
            return super.getMetaData();
        }

        public ResultSet execute(String sqlString) throws SQLException {
            this.closeActiveResultSet();
            this.m_activeResultSet = super.execute(this.m_jdbcStatement, sqlString);
            return this.m_activeResultSet;
        }

        public int executeUpdate(String query) throws SQLException {
            this.closeActiveResultSet();
            return super.executeUpdate(this.m_jdbcStatement, query);
        }

        public void commit() throws SQLException {
            this.closeActiveResultSet();
            super.commit();
        }

        public void rollback() throws SQLException {
            this.closeActiveResultSet();
            super.rollback();
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.closeActiveResultSet();
            super.setAutoCommit(autoCommit);
        }

        public void close() throws SQLException {
            this.noThrowCloseActiveResultSet();
            this.noThrowCloseStatement();
            super.close();
        }

        protected void preConnect() {
            this.noThrowCloseActiveResultSet();
            this.noThrowCloseStatement();
            super.preConnect();
        }

        protected void connect() throws DbConnectException, SQLException {
            super.connect();
            try {
                this.m_jdbcStatement = super.createStatement();
                this.m_jdbcStatement.setFetchSize(Integer.MIN_VALUE);
            }
            catch (SQLException e) {
                this.preConnect();
                throw e;
            }
        }

        public void closeActiveResultSet() throws SQLException {
            if (this.m_activeResultSet != null) {
                try {
                    this.m_activeResultSet.close();
                }
                catch (SQLException ex) {
                    SingletonFileLogger.GetInstance().LogWriteNormal("XMJU24-201", ex.getMessage());
                    throw ex;
                }
                finally {
                    this.m_activeResultSet = null;
                }
            }
        }

        private void noThrowCloseActiveResultSet() {
            try {
                this.closeActiveResultSet();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        private void closeStatement() throws SQLException {
            if (this.m_jdbcStatement != null) {
                this.m_jdbcStatement.close();
                this.m_jdbcStatement = null;
            }
        }

        private void noThrowCloseStatement() {
            try {
                this.closeStatement();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public boolean isBroken(SQLException ex) {
            if (this.m_activeResultSet == null && ex.getSQLState() == null && ex.getErrorCode() == 0) {
                SingletonFileLogger.GetInstance().LogWriteWarning("XMJU24-446", "Assuming DeadConnectionException: " + ex.getMessage());
                return true;
            }
            return super.isBroken(ex);
        }
    }

    private static class MySQLConnection {
        private DbInfo m_dbInfo;
        private Connection m_connection;
        private boolean m_isAutoCommit;
        private boolean m_needCommit;

        public MySQLConnection(DbInfo dbInfo) {
            this.m_dbInfo = dbInfo;
            this.m_connection = null;
            this.m_isAutoCommit = true;
            this.m_needCommit = false;
        }

        public DbInfo getDbInfo() {
            return this.m_dbInfo;
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return this.m_connection.getMetaData();
        }

        public ResultSet execute(String sqlString) throws SQLException {
            Statement statement = this.createStatement();
            try {
                ResultSet results = this.execute(statement, sqlString);
                return new ResultSetGuard(statement, results);
            }
            catch (SQLException ex) {
                this.close(statement);
                throw ex;
            }
        }

        protected ResultSet execute(Statement statement, String sqlString) throws SQLException {
            return statement.executeQuery(sqlString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int executeUpdate(String query) throws SQLException {
            Statement statement = this.createStatement();
            try {
                int n = this.executeUpdate(statement, query);
                return n;
            }
            finally {
                this.close(statement);
            }
        }

        protected int executeUpdate(Statement statement, String sqlString) throws SQLException {
            int result = statement.executeUpdate(sqlString);
            if (!this.getAutoCommit()) {
                this.m_needCommit = true;
            }
            return result;
        }

        public boolean getAutoCommit() {
            return this.m_isAutoCommit;
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.m_connection.setAutoCommit(autoCommit);
            this.m_isAutoCommit = this.m_connection.getAutoCommit();
        }

        public boolean needCommit() {
            return this.m_needCommit;
        }

        public void commit() throws SQLException {
            this.m_connection.commit();
            this.m_needCommit = false;
        }

        public void rollback() throws SQLException {
            this.m_connection.rollback();
            this.m_needCommit = false;
        }

        public void close() throws SQLException {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }

        public void closeActiveResultSet() throws SQLException {
        }

        protected Statement createStatement() throws SQLException {
            Statement statement = this.m_connection.createStatement();
            statement.setEscapeProcessing(false);
            return statement;
        }

        private void close(Statement stmt) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        protected void preConnect() {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_isAutoCommit = true;
            this.m_needCommit = false;
        }

        protected void connect() throws DbConnectException, SQLException {
            this.preConnect();
            try {
                this.m_connection = DriverManager.getConnection(MySQLConnection.getUrl(this.m_dbInfo), this.m_dbInfo.user(), this.m_dbInfo.password());
                this.m_connection.setTransactionIsolation(2);
                this.m_isAutoCommit = this.m_connection.getAutoCommit();
            }
            catch (SQLException e) {
                this.preConnect();
                String message = "connect - Exception with url '" + MySQLConnection.getUrl(this.m_dbInfo) + "' for user '" + this.m_dbInfo.user() + "'";
                SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU24-002", message);
                message = "connect - Exception: " + e.getMessage();
                throw new DbConnectException(message);
            }
        }

        private static String getUrl(DbInfo dbInfo) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("jdbc:mysql://");
            buffer.append(dbInfo.host());
            try {
                if (Integer.parseInt(dbInfo.port()) > 0) {
                    buffer.append(":");
                    buffer.append(Integer.parseInt(dbInfo.port()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            buffer.append("/");
            buffer.append(dbInfo.databaseName());
            buffer.append("?jdbcCompliantTruncation=false");
            return buffer.toString();
        }

        private static void loadDriver() {
            String driverName = "com.mysql.jdbc.Driver";
            try {
                Class.forName(driverName).newInstance();
            }
            catch (Exception e) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("loadDriver - Exception");
                String message = e.getMessage();
                if (message != null) {
                    buffer.append(": ");
                    buffer.append(message);
                }
                SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU24-001", buffer.toString());
            }
        }

        public boolean isBroken(SQLException ex) {
            return false;
        }

        static {
            MySQLConnection.loadDriver();
        }
    }
}

