/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.DatabaseInfo;
import Xm.FaultTolerance.DbComponentInstance;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.JdbcWrapper;
import Xm.JavaUtils.Database.LegacyDbReplicationComponent;
import Xm.JavaUtils.SingletonFileLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jacorb.util.Network;
import org.omg.CORBA.SystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyReplicatedDatabase {
    private DatabaseInfo m_LocalDatabaseInfo = null;
    private JdbcWrapper m_LocalDatabase = null;
    private Hashtable<String, JdbcWrapper> m_BackupDatabases = new Hashtable();
    private Hashtable<String, DbComponentInstance> m_BackupComponents = new Hashtable();
    private ArrayList<String> m_RecoveredDb = new ArrayList();
    private Set<String> m_applyAutoCommitOn;
    private SingletonFileLogger m_FileLogger = SingletonFileLogger.GetInstance();
    private LegacyDbReplicationComponent m_DbReplicationComponent = null;

    public LegacyReplicatedDatabase() {
        this.m_applyAutoCommitOn = new TreeSet<String>();
    }

    public void init(DatabaseInfo localDatabaseInfo, LegacyDbReplicationComponent replicationComponent) {
        this.m_LocalDatabaseInfo = localDatabaseInfo;
        LegacyReplicatedDatabase.fixDatabaseInfo(this.m_LocalDatabaseInfo);
        this.m_LocalDatabase = new JdbcWrapper(this.m_LocalDatabaseInfo.DbHost, this.m_LocalDatabaseInfo.DbName, this.m_LocalDatabaseInfo.DbUser, this.m_LocalDatabaseInfo.DbPassword, this.m_LocalDatabaseInfo.DbmsType, this.m_LocalDatabaseInfo.DbPort);
        this.m_DbReplicationComponent = replicationComponent;
    }

    private static void fixDatabaseInfo(DatabaseInfo info) {
        if (info.DbHost.equals("localhost")) {
            InetAddress localhost = null;
            try {
                localhost = Network.getLocalHost();
                if (localhost != null) {
                    info.DbHost = localhost.getHostAddress();
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public DatabaseInfo dbInfo() {
        return this.m_LocalDatabaseInfo;
    }

    public boolean isOracle() {
        if (this.m_LocalDatabase != null) {
            return this.m_LocalDatabase.IsOracle();
        }
        return false;
    }

    public boolean isMySql() {
        if (this.m_LocalDatabase != null) {
            return this.m_LocalDatabase.IsMySql();
        }
        return false;
    }

    public String validateColumnName(String name) {
        return this.m_LocalDatabase.ValidateColumnName(name);
    }

    public String limit(int offset, int count) {
        return JdbcWrapper.Limit(offset, count);
    }

    public synchronized void resetDatabases() {
        this.disconnectAll();
        this.m_BackupDatabases.clear();
        this.m_BackupComponents.clear();
        this.m_RecoveredDb.clear();
        this.m_applyAutoCommitOn.clear();
    }

    public synchronized void assertLocalDbConnection() throws DbConnectException {
        if (this.m_LocalDatabase == null) {
            throw new DbConnectException("No Local DbConnection");
        }
        this.m_LocalDatabase.AssertDbConnection();
    }

    private void disconnectBackup(String databaseId) {
        JdbcWrapper db = this.m_BackupDatabases.get(databaseId);
        if (db != null) {
            db.Disconnect();
        }
    }

    public synchronized void disconnectAll() {
        this.m_FileLogger.LogWriteLowLevel("XMJU23-001", "LegacyReplicatedDatabase - disconnectAll...");
        if (this.m_LocalDatabase != null) {
            this.m_LocalDatabase.Disconnect();
        }
        Enumeration<String> keys = this.m_BackupDatabases.keys();
        while (keys.hasMoreElements()) {
            this.disconnectBackup(keys.nextElement());
        }
        while (!this.m_RecoveredDb.isEmpty()) {
            this.disconnectBackup(this.m_RecoveredDb.remove(0));
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU23-001", "LegacyReplicatedDatabase - disconnectAll...Done");
    }

    public synchronized NamedDatabase getFirstBackup() {
        if (this.m_BackupDatabases.size() > 0) {
            Enumeration<String> keys = this.m_BackupDatabases.keys();
            while (keys.hasMoreElements()) {
                String guid = keys.nextElement();
                JdbcWrapper database = this.m_BackupDatabases.get(guid);
                if (database == null) continue;
                return new NamedDatabase(guid, database);
            }
        }
        return null;
    }

    public synchronized Vector<String> getBackupIds() {
        Vector<String> ids = new Vector<String>();
        Enumeration<String> keys = this.m_BackupDatabases.keys();
        while (keys.hasMoreElements()) {
            ids.add(keys.nextElement());
        }
        return ids;
    }

    public synchronized boolean addBackup(DbComponentInstance recoveredDb) {
        DatabaseInfo db_info = recoveredDb.DbInfo();
        if (!this.isAlreadyInTheList(db_info)) {
            JdbcWrapper TempJdbc = new JdbcWrapper(db_info.DbHost, db_info.DbName, db_info.DbUser, db_info.DbPassword, db_info.DbmsType, db_info.DbPort);
            String strDatabaseId = recoveredDb.DatabaseId();
            this.m_BackupComponents.put(strDatabaseId, recoveredDb);
            this.m_BackupDatabases.put(strDatabaseId, TempJdbc);
            this.m_RecoveredDb.add(strDatabaseId);
            this.m_applyAutoCommitOn.add(strDatabaseId);
            return true;
        }
        return false;
    }

    private boolean isAlreadyInTheList(DatabaseInfo dbInfo) {
        if (LegacyReplicatedDatabase.databaseInfoEquals(dbInfo, this.m_LocalDatabaseInfo)) {
            return true;
        }
        try {
            Enumeration<String> keys = this.m_BackupComponents.keys();
            while (keys.hasMoreElements()) {
                DbComponentInstance instance = this.m_BackupComponents.get(keys.nextElement());
                if (instance == null || !LegacyReplicatedDatabase.databaseInfoEquals(dbInfo, instance.DbInfo())) continue;
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    private static boolean databaseInfoEquals(DatabaseInfo db1, DatabaseInfo db2) {
        return db1.DbHost.equals(db2.DbHost) && db1.DbName.equals(db2.DbName) && db1.DbUser.equals(db2.DbUser) && db1.DbPassword.equals(db2.DbPassword) && db1.DbmsType.equals(db2.DbmsType) && db1.DbPort.equals(db2.DbPort);
    }

    public synchronized void removeBackup(String databaseId) {
        this.disconnectBackup(databaseId);
        this.m_BackupComponents.remove(databaseId);
        this.m_BackupDatabases.remove(databaseId);
        this.m_applyAutoCommitOn.remove(databaseId);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.m_LocalDatabase.GetMetaData();
        }
        catch (DbConnectException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw new SQLException(ex.getMessage());
        }
    }

    public ResultSet executeQuery(String query) throws SQLException {
        try {
            return this.m_LocalDatabase.ExecuteQuery(query);
        }
        catch (DbConnectException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw new SQLException(ex.getMessage());
        }
        catch (SQLException e) {
            throw e;
        }
    }

    public int executeUpdate(String query) throws SQLException {
        int affected = 0;
        try {
            affected = this.m_LocalDatabase.ExecuteUpdate(query);
        }
        catch (DbConnectException e) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw new SQLException(e.getMessage());
        }
        catch (SQLException e) {
            throw e;
        }
        this.executeJobOnBackups(new UpdateJob(query));
        return affected;
    }

    private synchronized void applyAutoCommitIfNeeded(String databaseId, JdbcWrapper db) throws SQLException, DbConnectException {
        if (this.m_applyAutoCommitOn.remove(databaseId)) {
            db.SetAutoCommit(this.getAutoCommit());
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.m_LocalDatabase.GetAutoCommit();
        }
        catch (DbConnectException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw new SQLException(ex.getMessage());
        }
        catch (SQLException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw ex;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.m_LocalDatabase.SetAutoCommit(autoCommit);
        }
        catch (DbConnectException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw new SQLException(ex.getMessage());
        }
        catch (SQLException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw ex;
        }
        finally {
            this.executeJobOnBackups(new SetAutoCommitJob(autoCommit));
        }
    }

    public void commit() throws SQLException {
        try {
            this.m_LocalDatabase.Commit();
        }
        catch (DbConnectException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw new SQLException(ex.getMessage());
        }
        catch (SQLException ex) {
            throw ex;
        }
        this.executeJobOnBackups(new CommitJob());
    }

    public void rollback() throws SQLException {
        try {
            this.m_LocalDatabase.Rollback();
        }
        catch (DbConnectException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw new SQLException(ex.getMessage());
        }
        catch (SQLException ex) {
            this.m_DbReplicationComponent.AssociatedDatabaseFailed();
            throw ex;
        }
        finally {
            this.executeJobOnBackups(new RollbackJob());
        }
    }

    private void executeJobOnBackups(Job job) {
        this.m_RecoveredDb.clear();
        Enumeration<String> keys = this.m_BackupDatabases.keys();
        Vector<String> updatedDb = new Vector<String>();
        while (keys.hasMoreElements()) {
            String databaseId = keys.nextElement();
            if (!updatedDb.contains(databaseId)) {
                this.executeJobOnBackup(job, databaseId);
                updatedDb.add(databaseId);
            }
            while (!this.m_RecoveredDb.isEmpty()) {
                databaseId = this.m_RecoveredDb.remove(0);
                if (updatedDb.contains(databaseId)) continue;
                this.executeJobOnBackup(job, databaseId);
                updatedDb.add(databaseId);
            }
        }
    }

    private void executeJobOnBackup(Job job, String databaseId) {
        this.m_FileLogger.LogWriteLowLevel("XMJU23-002", "LegacyReplicatedDatabase - executeJobOnBackup...");
        JdbcWrapper db = this.m_BackupDatabases.get(databaseId);
        if (db != null) {
            try {
                this.applyAutoCommitIfNeeded(databaseId, db);
                job.executeOn(db);
            }
            catch (DbConnectException ex) {
                this.notifyFailureAndRemoveDatabase(databaseId);
            }
            catch (SQLException e) {
                this.notifyFailureAndRemoveDatabase(databaseId);
            }
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU23-002", "LegacyReplicatedDatabase - executeJobOnBackup...Done");
    }

    private void notifyFailureAndRemoveDatabase(String databaseId) {
        DbComponentInstance failedInstance = this.m_BackupComponents.get(databaseId);
        this.removeBackup(databaseId);
        String dbHost = "";
        try {
            DatabaseInfo info = failedInstance.DbInfo();
            dbHost = info.DbHost;
            failedInstance.AssociatedDatabaseFailed();
        }
        catch (SystemException e) {
            this.m_FileLogger.LogWriteWarning("XMJU23-003", "CORBA.SystemException while trying to notify a failure: " + e.toString());
        }
        this.m_FileLogger.LogWriteWarning("XMJU23-004", "SQL Exception happened on database located at " + dbHost);
        this.m_FileLogger.LogWriteWarning("XMJU23-004", "The component on this computer has been notified");
    }

    public synchronized DbEnumeration getDbEnumeration() {
        return new DbEnumeration();
    }

    private static class RollbackJob
    implements Job {
        private RollbackJob() {
        }

        public void executeOn(JdbcWrapper db) throws SQLException, DbConnectException {
            db.Rollback();
        }
    }

    private static class CommitJob
    implements Job {
        private CommitJob() {
        }

        public void executeOn(JdbcWrapper db) throws SQLException, DbConnectException {
            db.Commit();
        }
    }

    private static class SetAutoCommitJob
    implements Job {
        private boolean autoCommit;

        public SetAutoCommitJob(boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        public void executeOn(JdbcWrapper db) throws SQLException, DbConnectException {
            db.SetAutoCommit(this.autoCommit);
        }
    }

    private static class UpdateJob
    implements Job {
        private String update;

        public UpdateJob(String update) {
            this.update = update;
        }

        public void executeOn(JdbcWrapper db) throws SQLException, DbConnectException {
            db.ExecuteUpdate(this.update);
        }
    }

    static interface Job {
        public void executeOn(JdbcWrapper var1) throws SQLException, DbConnectException;
    }

    public class DbEnumeration
    implements Enumeration {
        private int m_NextIndex;
        private List<JdbcWrapper> m_Databases;
        private List<String> m_DatabasesGuid;

        private DbEnumeration() {
            this.reset();
        }

        public synchronized void reset() {
            this.m_NextIndex = 0;
            this.m_DatabasesGuid = new Vector(LegacyReplicatedDatabase.this.m_BackupDatabases.keySet());
            this.m_Databases = new Vector(LegacyReplicatedDatabase.this.m_BackupDatabases.values());
        }

        public synchronized boolean hasMoreElements() {
            return this.m_NextIndex < this.m_Databases.size();
        }

        public synchronized Object nextElement() {
            if (this.hasMoreElements()) {
                return this.m_Databases.get(this.m_NextIndex++);
            }
            throw new NoSuchElementException();
        }

        public synchronized void currentDbFailed() {
            int current = this.m_NextIndex - 1;
            if (current >= 0 && current < this.m_Databases.size()) {
                LegacyReplicatedDatabase.this.notifyFailureAndRemoveDatabase(this.m_DatabasesGuid.remove(current));
                this.m_Databases.remove(current);
                this.m_NextIndex = current;
            }
        }
    }

    public static class NamedDatabase {
        private String m_id;
        private JdbcWrapper m_database;

        public NamedDatabase(String id, JdbcWrapper database) {
            this.m_id = id;
            this.m_database = database;
        }

        public String id() {
            return this.m_id;
        }

        public JdbcWrapper database() {
            return this.m_database;
        }
    }
}

