/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.DbComponentInstance;
import Xm.FaultTolerance.DbSynchronizationFailed;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbVersionMismatchException;
import Xm.JavaUtils.Database.JdbcWrapper;
import Xm.JavaUtils.Database.LegacyReplicatedDatabase;
import Xm.JavaUtils.NtService;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.UnreconciliablePartitionException;
import Xm.JavaUtils.ValidatorI;
import Xm.JavaUtils.Validators;
import Xm.JavaUtils.Version;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.omg.CORBA.SystemException;

public abstract class LegacyDbSynchronizer {
    protected JdbcWrapper m_LocalDatabase;
    protected JdbcWrapper m_SourceDatabase;
    protected SingletonFileLogger m_FileLogger;
    protected ValidatorI m_ServiceActive = Validators.ServiceIsNotStopping();

    public LegacyDbSynchronizer(JdbcWrapper LocalDb) {
        this.m_FileLogger = SingletonFileLogger.GetInstance();
        this.m_LocalDatabase = LocalDb;
    }

    public abstract boolean OnAddHost();

    public void ReconcileFromPartition() throws UnreconciliablePartitionException {
        throw new UnreconciliablePartitionException();
    }

    protected abstract void LogBeginningOfPartition() throws SQLException, DbConnectException;

    protected abstract void DoSynchronizeWithoutLock() throws SQLException, DbConnectException, DbSynchronizationFailed;

    protected abstract String[] TablesToLock() throws SQLException, DbConnectException;

    protected abstract void DoSynchronizeWithLock() throws SQLException, DbConnectException, DbSynchronizationFailed;

    protected abstract void DoBecomePrimary(LegacyReplicatedDatabase.DbEnumeration var1) throws DbConnectException, SQLException;

    public void Synchronize(JdbcWrapper SourceDatabase, String SourceGuid, DbComponentInstance PrimaryInstance, DbComponentInstance RecoveringInstance) throws DbSynchronizationFailed, DbConnectException, DbVersionMismatchException, UnreconciliablePartitionException {
        String LOG_GUARD = "LegacyDbSynchronizer::Synchronize...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-007", "LegacyDbSynchronizer::Synchronize...");
        this.m_SourceDatabase = SourceDatabase;
        boolean source_locked = false;
        try {
            this.AssertSameDatabaseVersion();
            this.DoSynchronizeWithoutLock();
            this.LockSource(this.TablesToLock());
            source_locked = true;
            this.DoSynchronizeWithLock();
            PrimaryInstance.NotifyRecovered(RecoveringInstance, SourceGuid);
            this.UnlockSource();
            source_locked = false;
            this.m_FileLogger.LogWriteLowLevel("XMJU20-008", "LegacyDbSynchronizer::Synchronize...Done");
        }
        catch (SQLException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-009", "LegacyDbSynchronizer::Synchronize...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU20-009", "SQLException: " + e.getMessage());
            throw new DbSynchronizationFailed(e.getMessage() == null ? "" : e.getMessage());
        }
        catch (DbConnectException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-010", "LegacyDbSynchronizer::Synchronize...Error: DbConnectException");
            throw e;
        }
        catch (SystemException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-011", "LegacyDbSynchronizer::Synchronize...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU20-011", "CORBA.SystemException: " + e.toString());
            throw e;
        }
        finally {
            try {
                if (source_locked) {
                    this.UnlockSource();
                }
            }
            catch (SQLException ex) {
            }
            catch (DbConnectException ex) {}
        }
    }

    public void BecomePrimary(LegacyReplicatedDatabase.DbEnumeration db_enumeration) throws DbConnectException, SQLException {
        this.DoBecomePrimary(db_enumeration);
    }

    protected void SynchronizeLastLine(String TableName2, String UniqueIdColumnName, boolean DeleteExtraLine, LegacyReplicatedDatabase.DbEnumeration db_enumeration) throws DbConnectException, SQLException {
        long local_max;
        this.m_SourceDatabase = this.m_LocalDatabase;
        String sql_max_query = "SELECT MAX(" + UniqueIdColumnName + ") FROM " + TableName2;
        ResultSet max_result = this.m_LocalDatabase.ExecuteQuery(sql_max_query);
        max_result.next();
        long lowest_max = local_max = max_result.getLong(1);
        long highest_max = local_max;
        db_enumeration.reset();
        while (db_enumeration.hasMoreElements()) {
            try {
                JdbcWrapper current_db = (JdbcWrapper)db_enumeration.nextElement();
                max_result = current_db.ExecuteQuery(sql_max_query);
                max_result.next();
                long max = max_result.getLong(1);
                if (max > highest_max) {
                    highest_max = max;
                    this.m_SourceDatabase = current_db;
                }
                lowest_max = Math.min(lowest_max, max);
            }
            catch (DbConnectException e) {
                db_enumeration.currentDbFailed();
            }
            catch (SQLException e) {
                db_enumeration.currentDbFailed();
            }
        }
        if (highest_max == lowest_max) {
            return;
        }
        String sql_select = "SELECT * FROM " + TableName2 + " WHERE " + UniqueIdColumnName + " = " + highest_max;
        String sql_delete = "DELETE FROM " + TableName2 + " WHERE " + UniqueIdColumnName + " = " + highest_max;
        switch ((int)(highest_max - local_max)) {
            case 0: {
                if (!DeleteExtraLine) break;
                this.m_LocalDatabase.ExecuteUpdate(sql_delete);
                break;
            }
            case 1: {
                if (DeleteExtraLine) break;
                this.AddMissingRecords(TableName2, this.m_SourceDatabase.ExecuteQuery(sql_select), this.m_LocalDatabase);
                break;
            }
            default: {
                throw new SQLException("Local table " + TableName2 + " has more than one record to update");
            }
        }
        db_enumeration.reset();
        block15: while (db_enumeration.hasMoreElements()) {
            try {
                JdbcWrapper current_db = (JdbcWrapper)db_enumeration.nextElement();
                max_result = current_db.ExecuteQuery(sql_max_query);
                max_result.next();
                long max = max_result.getLong(1);
                switch ((int)(highest_max - max)) {
                    case 0: {
                        if (!DeleteExtraLine) continue block15;
                        current_db.ExecuteUpdate(sql_delete);
                        continue block15;
                    }
                    case 1: {
                        if (DeleteExtraLine) continue block15;
                        this.AddMissingRecords(TableName2, this.m_SourceDatabase.ExecuteQuery(sql_select), current_db);
                        continue block15;
                    }
                }
                db_enumeration.currentDbFailed();
            }
            catch (DbConnectException e) {
                db_enumeration.currentDbFailed();
            }
            catch (SQLException e) {
                db_enumeration.currentDbFailed();
            }
        }
    }

    protected int AddMissingRecords(String TableName2, ResultSet Results, JdbcWrapper Database2) throws SQLException, DbConnectException {
        String LOG_GUARD = "DbBackupUpdater - AddMissingRecords in table " + TableName2 + "...";
        this.m_FileLogger.LogWriteNormal("XMJU20-016", LOG_GUARD);
        StringBuffer sql_begin_buffer = new StringBuffer(250);
        sql_begin_buffer.append("INSERT INTO ").append(TableName2).append(" (");
        ResultSetMetaData table_meta_data = Results.getMetaData();
        int nb_columns = table_meta_data.getColumnCount();
        for (int i = 0; i < nb_columns; ++i) {
            sql_begin_buffer.append("`");
            sql_begin_buffer.append(table_meta_data.getColumnName(i + 1));
            sql_begin_buffer.append("`, ");
        }
        String sql_begin = sql_begin_buffer.substring(0, sql_begin_buffer.length() - 2) + ") VALUES(";
        int nb_records_added = 0;
        while (Results.next() && !NtService.GetInstance().IsStopping()) {
            StringBuffer sql_query = new StringBuffer(1024);
            sql_query.append(sql_begin);
            for (int i = 0; i < nb_columns; ++i) {
                String source_value = Results.getString(i + 1);
                if (Results.wasNull()) {
                    sql_query.append("null, ");
                    continue;
                }
                sql_query.append("'");
                sql_query.append(JdbcWrapper.AddSlashes(source_value));
                sql_query.append("', ");
            }
            Database2.ExecuteUpdate(sql_query.substring(0, sql_query.length() - 2) + ")");
            ++nb_records_added;
        }
        this.m_FileLogger.LogWriteNormal("XMJU20-017", LOG_GUARD + "Done");
        return nb_records_added;
    }

    protected int AddMissingRecords(String TableName2, ResultSet Results) throws SQLException, DbConnectException {
        return this.AddMissingRecords(TableName2, Results, this.m_LocalDatabase);
    }

    protected boolean IsResultIdentical(ResultSet Result1, ResultSet Result2, int NbColumns) throws SQLException {
        boolean is_identical = true;
        for (int i = 1; is_identical && i <= NbColumns; ++i) {
            String value1 = Result1.getString(i);
            String value2 = Result2.getString(i);
            if (value1 != null && value2 != null) {
                is_identical = value1.equals(value2);
                continue;
            }
            if (value1 != null) {
                is_identical = value1.equals("") || value1.equals("0");
                continue;
            }
            if (value2 == null) continue;
            is_identical = value2.equals("") || value2.equals("0");
        }
        return is_identical;
    }

    private void LockSource(String[] TableNames) throws SQLException, DbConnectException {
        String LOG_GUARD = "LegacyDbSynchronizer::LockSource...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-012", "LegacyDbSynchronizer::LockSource...");
        String sql_query = "LOCK TABLES ";
        for (int i = 0; i < TableNames.length; ++i) {
            sql_query = sql_query + TableNames[i] + " READ, ";
        }
        sql_query = sql_query.substring(0, sql_query.length() - 2);
        this.m_SourceDatabase.ExecuteUpdate(sql_query);
        this.m_FileLogger.LogWriteLowLevel("XMJU20-013", "LegacyDbSynchronizer::LockSource...Done");
    }

    private void UnlockSource() throws SQLException, DbConnectException {
        String LOG_GUARD = "LegacyDbSynchronizer::UnlockSource...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-014", "LegacyDbSynchronizer::UnlockSource...");
        this.m_SourceDatabase.ExecuteUpdate("UNLOCK TABLES");
        this.m_FileLogger.LogWriteLowLevel("XMJU20-015", "LegacyDbSynchronizer::UnlockSource...Done");
    }

    private void AssertSameDatabaseVersion() throws DbVersionMismatchException, DbConnectException {
        String LOG_GUARD = "LegacyDbSynchronizer::ValidateVersion...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-000", "LegacyDbSynchronizer::ValidateVersion...");
        Version local_version = null;
        try {
            local_version = this.GetVersion(this.m_LocalDatabase);
            if (local_version == null) {
                this.m_FileLogger.LogWriteFatalError("XMJU20-001", "LegacyDbSynchronizer::ValidateVersion...Error");
                this.m_FileLogger.LogWriteFatalError("XMJU20-001", "Unable to get local database version");
                throw new DbVersionMismatchException("Unable to get local database version");
            }
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-002", "LegacyDbSynchronizer::ValidateVersion...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU20-002", "Unable to connect to local database");
            throw ex;
        }
        Version source_version = null;
        try {
            source_version = this.GetVersion(this.m_SourceDatabase);
            if (source_version == null) {
                this.m_FileLogger.LogWriteFatalError("XMJU20-003", "LegacyDbSynchronizer::ValidateVersion...Error");
                this.m_FileLogger.LogWriteFatalError("XMJU20-003", "Unable to get source database version");
                throw new DbVersionMismatchException("Unable to get source database version");
            }
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-004", "LegacyDbSynchronizer::ValidateVersion...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU20-004", "Unable to connect to source database");
            throw ex;
        }
        if (local_version.compareTo(source_version) != 0) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-005", "LegacyDbSynchronizer::ValidateVersion...Error");
            StringBuffer buf = new StringBuffer();
            buf.append("Database version mismatch: cannot synchronize the local database (");
            buf.append(local_version.toString());
            buf.append(") with the source database (");
            buf.append(source_version.toString());
            buf.append(")");
            this.m_FileLogger.LogWriteFatalError("XMJU20-005", buf.toString());
            throw new DbVersionMismatchException(buf.toString());
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU20-006", "LegacyDbSynchronizer::ValidateVersion...Done");
    }

    private Version GetVersion(JdbcWrapper Database2) throws DbConnectException {
        Version version = null;
        try {
            String sql_string = "SELECT DatabaseVersion FROM Version";
            ResultSet result = Database2.ExecuteQuery(sql_string);
            result.next();
            String version_string = result.getString(1);
            if (!result.wasNull()) {
                version = Version.fromString(version_string);
            }
            result.close();
        }
        catch (SQLException ex) {
        }
        catch (NullPointerException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return version;
    }

    class PartitionBeginningFinder
    extends Thread {
        private LegacyDbSynchronizer m_Synchronizer;

        PartitionBeginningFinder(LegacyDbSynchronizer Synchronizer) {
            this.m_Synchronizer = Synchronizer;
            this.setName("PartitionBeginningFinder");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LegacyDbSynchronizer.this.m_FileLogger.LogWriteNormal("XMJU20-021", "A system partition has been detected, looking for beginning of partition in tables");
                this.m_Synchronizer.LogBeginningOfPartition();
                LegacyDbSynchronizer.this.m_FileLogger.LogWriteNormal("XMJU20-022", "Finished looking for beginning of partition in tables");
            }
            catch (SQLException e) {
                LegacyDbSynchronizer.this.m_FileLogger.LogWriteNormal("XMJU20-023", "SQLException: " + e.getMessage());
            }
            catch (DbConnectException e) {
                LegacyDbSynchronizer.this.m_FileLogger.LogWriteNormal("XMJU20-024", "DbConnectException");
            }
            finally {
                if (Validators.ServiceIsNotStopping().Validate()) {
                    NtService.GetInstance().StopService();
                }
            }
        }
    }
}

