/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.ComponentGroupInfo;
import Xm.FaultTolerance.ComponentInstanceInfo;
import Xm.FaultTolerance.ComponentInstanceMembership;
import Xm.FaultTolerance.ComponentInstancePackage.InstanceFailed;
import Xm.FaultTolerance.ComponentInstancePackage.InstanceFailedCause;
import Xm.FaultTolerance.ComponentInstancePackage.NoGroupMemberActive;
import Xm.FaultTolerance.ComponentInstancePackage.UnknownGroup;
import Xm.FaultTolerance.ComponentInstancePackage.UnsupportedFacet;
import Xm.FaultTolerance.ComponentInstanceStatus;
import Xm.FaultTolerance.DatabaseInfo;
import Xm.FaultTolerance.DbComponentInstance;
import Xm.FaultTolerance.DbComponentInstanceHelper;
import Xm.FaultTolerance.DbComponentInstancePOA;
import Xm.FaultTolerance.DbSynchronizationFailed;
import Xm.FaultTolerance.Heartbeat.Monitor;
import Xm.FaultTolerance.Heartbeat.Subscription;
import Xm.FaultTolerance.Heartbeat.UnsupportedInterval;
import Xm.FaultTolerance.PartGroupInfo;
import Xm.FaultTolerance.System;
import Xm.FaultTolerance.SystemHelper;
import Xm.FaultTolerance.SystemPackage.Initializing;
import Xm.FaultTolerance.SystemPackage.LocationAlreadyActive;
import Xm.FaultTolerance.SystemPackage.UnknownType;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbVersionMismatchException;
import Xm.JavaUtils.Database.JdbcWrapper;
import Xm.JavaUtils.Database.LegacyDbSynchronizer;
import Xm.JavaUtils.Database.LegacyReplicatedDatabase;
import Xm.JavaUtils.Database.ReplicaStateImpl;
import Xm.JavaUtils.DirectoryHelper;
import Xm.JavaUtils.HostList;
import Xm.JavaUtils.JavaRegistry;
import Xm.JavaUtils.NtService;
import Xm.JavaUtils.Port;
import Xm.JavaUtils.ReplicatedService;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.UnreconciliablePartitionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.FT.Property;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class LegacyDbReplicationComponent
extends DbComponentInstancePOA {
    private static final int INITIAL_WAIT_TIME = 500;
    private static final int MAX_WAIT_TIME = 32000;
    private ReplicatedService m_Service;
    private String m_strServiceGuid;
    private LegacyReplicatedDatabase m_Dbs;
    private NameComponent[] m_LocationId;
    private NameComponent[] m_ComponentGroupId;
    private Property[] m_ComponentDescription;
    private String m_strComponentType;
    private String m_strComponentName;
    private System m_ReplicationManager;
    private boolean m_bIsPrimary;
    private boolean m_bIsAlive;
    private DbComponentInstance m_PrimaryInstance;
    private LegacyDbSynchronizer m_DbSynchronizer;
    private boolean m_bTerminate;
    private int m_iTimeToWait;
    private SingletonFileLogger m_FileLogger;
    private ORB m_Orb;
    private POA m_Poa;
    private byte[] m_ObjectId;
    private ReplicaStateImpl replicaState;
    private HostList.HostListIterator m_HostIterator = new HostList().createIterator();

    public LegacyDbReplicationComponent(int iServiceType) {
        this.replicaState = new ReplicaStateImpl(iServiceType);
        this.m_strComponentType = LegacyDbReplicationComponent.getComponentType(iServiceType);
        this.m_strComponentName = LegacyDbReplicationComponent.getComponentName(iServiceType);
        this.m_bIsPrimary = false;
        this.m_bTerminate = false;
        this.m_bIsAlive = true;
        this.m_Dbs = new LegacyReplicatedDatabase();
        this.m_iTimeToWait = 500;
        this.m_Service = null;
        this.m_strServiceGuid = null;
        this.m_LocationId = null;
        this.m_ComponentGroupId = null;
        this.m_ComponentDescription = null;
        this.m_Orb = null;
        this.m_Poa = null;
        this.m_ObjectId = null;
        this.m_ReplicationManager = null;
        this.m_PrimaryInstance = null;
        this.m_FileLogger = SingletonFileLogger.GetInstance();
    }

    private static String getComponentType(int serviceType) {
        switch (serviceType) {
            case 0: {
                return "Archive";
            }
            case 1: {
                return "CompanyConfig";
            }
        }
        return "";
    }

    private static String getComponentName(int serviceType) {
        switch (serviceType) {
            case 0: {
                return "Archive";
            }
            case 1: {
                return "CompanyConfig";
            }
        }
        return "";
    }

    private static NameComponent[] getLocationId(String serviceName, String componentName) {
        String hostGuid = JavaRegistry.GetRegistryString(3, "SOFTWARE\\Interstar Technologies\\XMedius\\Guids", "Host");
        NameComponent[] locationId = new NameComponent[3];
        locationId[0] = new NameComponent();
        locationId[0].kind = "Host";
        locationId[0].id = hostGuid;
        locationId[1] = new NameComponent();
        locationId[1].kind = "Service";
        locationId[1].id = serviceName;
        locationId[2] = new NameComponent();
        locationId[2].kind = "ComponentId";
        locationId[2].id = componentName;
        return locationId;
    }

    private static Property[] getComponentDescription(ORB orb) {
        Property[] description = new Property[]{new Property()};
        description[0].nam = new NameComponent[1];
        description[0].nam[0] = new NameComponent();
        description[0].nam[0].id = "Version";
        description[0].nam[0].kind = "PropertyName";
        description[0].val = orb.create_any();
        description[0].val.insert_string("4.5");
        return description;
    }

    private void Activate() throws InstanceFailed {
        String strType = "";
        try {
            this.m_Dbs.assertLocalDbConnection();
            this.m_FileLogger.LogWriteLowLevel("XMJU02-006", "LegacyDbReplicationComponent - Database reached");
            if (!this.PrepareDatabase()) {
                this.m_FileLogger.LogWriteFatalError("XMJU02-094", "LegacyDbReplicationComponent - Database preparation failed");
                this.CloseAllDbConnections();
                throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "Database preparation failed");
            }
            if (this.m_bIsPrimary) {
                strType = "primary";
                this.m_FileLogger.LogWriteLowLevel("XMJU02-007", "LegacyDbReplicationComponent - Starting the real application...");
                this.m_DbSynchronizer.BecomePrimary(this.m_Dbs.getDbEnumeration());
                this.m_Service.StartPrimary();
                this.m_FileLogger.LogWriteLowLevel("XMJU02-008", "LegacyDbReplicationComponent - Starting the real application...Done");
            } else {
                strType = "backup";
                this.m_FileLogger.LogWriteLowLevel("XMJU02-009", "Starting database recovery");
                this.Recover();
                this.m_FileLogger.LogWriteLowLevel("XMJU02-010", "Database recovery...done");
            }
            this.m_FileLogger.LogWriteNormal("XMJU02-011", "LegacyDbReplicationComponent - Initializing as a " + strType + " component...Done");
        }
        catch (DbSynchronizationFailed ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-012", "LegacyDbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-012", ex.Message);
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, ex.Message);
        }
        catch (UnreconciliablePartitionException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-099", "LegacyDbReplicationComponent - Initializing as a " + strType + " component...Error");
            throw new InstanceFailed(InstanceFailedCause.SYSTEM_PARTITION_DETECTED, "The system has been partitioned, contact Tech Support");
        }
        catch (DbVersionMismatchException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-093", "LegacyDbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-093", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.VERSION_MISMATCH, ex.getMessage());
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-095", "LegacyDbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-095", "LegacyDbReplicationComponent - Database unreachable");
            this.m_FileLogger.LogWriteFatalError("XMJU02-095", ex.getMessage());
            this.CloseAllDbConnections();
            throw new PERSIST_STORE();
        }
        catch (SQLException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-109", "LegacyDbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-109", ex.getMessage());
            this.CloseAllDbConnections();
            throw new PERSIST_STORE();
        }
    }

    private synchronized void AmortizedSleep() {
        try {
            this.wait(this.m_iTimeToWait);
            this.m_iTimeToWait *= 2;
            if (this.m_iTimeToWait > 32000) {
                this.m_iTimeToWait = 32000;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String StringifyMembershipAndStatus(ComponentInstanceMembership Membership2, ComponentInstanceStatus Status2) {
        String status;
        String membership;
        switch (Membership2.value()) {
            case 0: {
                membership = "Primary";
                break;
            }
            case 1: {
                membership = "Backup";
                break;
            }
            case 2: {
                membership = "StandBy";
                break;
            }
            case 3: {
                membership = "None";
                break;
            }
            default: {
                membership = "";
            }
        }
        switch (Status2.value()) {
            case 0: {
                status = "Fault";
                break;
            }
            case 1: {
                status = "Recovering";
                break;
            }
            case 2: {
                status = "Active";
                break;
            }
            default: {
                status = "";
            }
        }
        return "Status: " + status + " - Membership: " + membership;
    }

    private void UpdateBackupAndPrimaryLists(ComponentGroupInfo NewInfo) {
        Vector<String> toRemove = this.m_Dbs.getBackupIds();
        try {
            this.m_FileLogger.LogWriteNormal("XMJU02-019", "LegacyDbReplicationComponent - Updating group (" + NewInfo.Instances.length + " instances)");
            for (int i = 0; i < NewInfo.Instances.length; ++i) {
                this.m_FileLogger.LogWriteNormal("XMJU02-020", "LegacyDbReplicationComponent - Updating group (processing instance " + i + " - " + LegacyDbReplicationComponent.StringifyMembershipAndStatus(NewInfo.Instances[i].Membership, NewInfo.Instances[i].Status) + ")");
                DbComponentInstance tempInstance = DbComponentInstanceHelper.narrow(NewInfo.Instances[i].TheComponent);
                if (tempInstance == null) {
                    if (NewInfo.Instances[i].Membership == ComponentInstanceMembership.MEMBER_PRIMARY) {
                        this.m_FileLogger.LogWriteNormal("XMJU02-021", "LegacyDbReplicationComponent - Updating group (MEMBER_PRIMARY is null)");
                        this.m_PrimaryInstance = null;
                        continue;
                    }
                    boolean bPrimaryFound = false;
                    for (int z = 0; z < NewInfo.Instances.length; ++z) {
                        if (NewInfo.Instances[z].Membership != ComponentInstanceMembership.MEMBER_PRIMARY) continue;
                        bPrimaryFound = true;
                        break;
                    }
                    if (bPrimaryFound) continue;
                    this.m_FileLogger.LogWriteNormal("XMJU02-022", "LegacyDbReplicationComponent - Updating group (NO PRIMARY: MEMBER_PRIMARY is null)");
                    this.m_PrimaryInstance = null;
                    continue;
                }
                this.m_FileLogger.LogWriteNormal("XMJU02-104", "LegacyDbReplicationComponent - Updating group - Getting instance database Id");
                if (NewInfo.Instances[i].Status == ComponentInstanceStatus.STATUS_FAULT || NewInfo.Instances[i].Status != ComponentInstanceStatus.STATUS_ACTIVE) continue;
                if (NewInfo.Instances[i].Membership == ComponentInstanceMembership.MEMBER_PRIMARY) {
                    this.m_PrimaryInstance = tempInstance;
                    continue;
                }
                if (NewInfo.Instances[i].Membership == ComponentInstanceMembership.MEMBER_BACKUP) {
                    String tempDatabaseId = tempInstance.DatabaseId();
                    if (tempDatabaseId.equals(this.DatabaseId())) continue;
                    toRemove.remove(tempDatabaseId);
                    if (!this.m_Dbs.addBackup(tempInstance)) continue;
                    this.m_FileLogger.LogWriteNormal("XMJU02-026", "LegacyDbReplicationComponent - Adding a backup to the list");
                    continue;
                }
                if (NewInfo.Instances[i].Membership != ComponentInstanceMembership.MEMBER_STANDBY) continue;
            }
            while (!toRemove.isEmpty()) {
                this.m_FileLogger.LogWriteLowLevel("XMJU02-031", "LegacyDbReplicationComponent - RemoveBackupDatabase...");
                String strCurrentKey = toRemove.remove(0);
                this.m_Dbs.removeBackup(strCurrentKey);
                this.m_FileLogger.LogWriteLowLevel("XMJU02-032", "LegacyDbReplicationComponent - RemoveBackupDatabase...Done");
            }
            if (this.m_PrimaryInstance != null) {
                this.m_FileLogger.LogWriteLowLevel("XMJU02-033", "LegacyDbReplicationComponent - Check if we are primary...");
                String primary_component_guid = this.m_PrimaryInstance.DatabaseId();
                this.m_bIsPrimary = this.m_strServiceGuid.equals(primary_component_guid);
                this.m_FileLogger.LogWriteLowLevel("XMJU02-034", "LegacyDbReplicationComponent - Check if we are primary...Done");
            }
        }
        catch (SystemException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-029", "System exception: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveComponentGroupId(NameComponent[] GroupId) {
        File TheDir = new File(DirectoryHelper.GetDataFolder("Replication/" + this.m_strComponentType));
        File TheFile = new File(TheDir.getPath() + "/GroupId.dat");
        FileOutputStream ofstream = null;
        ObjectOutputStream object_stream = null;
        try {
            TheDir.mkdirs();
            TheFile.createNewFile();
            ofstream = new FileOutputStream(TheFile);
            object_stream = new ObjectOutputStream(ofstream);
            object_stream.writeObject(GroupId);
            object_stream.flush();
        }
        catch (IOException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-031", "LegacyDbReplicationComponent - SaveComponentGroupId - IOException: " + e.getMessage());
        }
        finally {
            try {
                if (object_stream != null) {
                    object_stream.close();
                }
                if (ofstream != null) {
                    ofstream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameComponent[] LoadComponentGroupId(String componentType) {
        File TheFile = new File(DirectoryHelper.GetDataFolder("Replication/" + componentType) + "/GroupId.dat");
        FileInputStream ifstream = null;
        ObjectInputStream object_stream = null;
        try {
            if (TheFile.exists()) {
                ifstream = new FileInputStream(TheFile);
                object_stream = new ObjectInputStream(ifstream);
                NameComponent[] nameComponentArray = (NameComponent[])object_stream.readObject();
                return nameComponentArray;
            }
        }
        catch (ClassNotFoundException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-032", "LegacyDbReplicationComponent - LoadComponentGroupId - ClassNotFoundException: " + e.getMessage());
        }
        catch (IOException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-033", "LegacyDbReplicationComponent - LoadComponentGroupId - IOException: " + e.getMessage());
        }
        finally {
            try {
                if (object_stream != null) {
                    object_stream.close();
                }
                if (ifstream != null) {
                    ifstream.close();
                }
            }
            catch (IOException e) {}
        }
        return new NameComponent[0];
    }

    private void RestartComponent() {
        this.m_FileLogger.LogWriteWarning("XMJU02-096", "LegacyDbReplicationComponent - Database connection lost");
        this.ComponentStopping();
        switch (this.ComponentStarting()) {
            case 1: {
                this.m_FileLogger.LogWriteLowLevel("XMJU02-097", "LegacyDbReplicationComponent - Re-initialization...Done");
                break;
            }
            case 2: {
                this.m_FileLogger.LogWriteFatalError("XMJU02-106", "LegacyDbReplicationComponent - Re-initialization...Failed");
                this.m_FileLogger.LogWriteFatalError("XMJU02-106", "Pretending to be restarted to let another thread find beginning of the partition");
                break;
            }
            default: {
                this.m_FileLogger.LogWriteFatalError("XMJU02-107", "LegacyDbReplicationComponent - Re-initialization...Failed");
                NtService.GetInstance().StopService();
            }
        }
    }

    private int ComponentStarting() {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-037", "LegacyDbReplicationComponent - ComponentStarting...");
        try {
            if (!this.m_bTerminate && this.m_ObjectId == null) {
                this.m_ObjectId = this.m_Poa.activate_object((Servant)this);
                this.m_FileLogger.LogWriteNormal("XMJU02-001", "LegacyDbReplicationComponent object activated with POA");
            }
        }
        catch (ServantAlreadyActive e) {
        }
        catch (WrongPolicy e) {
            // empty catch block
        }
        while (!this.m_bTerminate) {
            try {
                this.m_bIsAlive = false;
                this.m_ReplicationManager.ComponentStarting(this.m_LocationId, this.m_strComponentType, this.m_ComponentDescription, DbComponentInstanceHelper.narrow(this.m_Poa.servant_to_reference((Servant)this)));
                this.m_bIsAlive = true;
                this.m_FileLogger.LogWriteLowLevel("XMJU02-048", "LegacyDbReplicationComponent - ComponentStarting...Done");
                return 1;
            }
            catch (UnknownType e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-038", "UnknownType: " + e.toString());
                return 4;
            }
            catch (LocationAlreadyActive e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-039", "LocationAlreadyActive: " + e.toString());
                return 5;
            }
            catch (Initializing e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-040", "Could not initialize with FaultTolerance(" + e.What + ") - Will retry later");
                this.AmortizedSleep();
            }
            catch (InstanceFailed e) {
                this.m_FileLogger.LogWriteFatalError("XMJU02-041", "LegacyDbReplicationComponent - ComponentStarting...Error");
                this.m_FileLogger.LogWriteFatalError("XMJU02-041", e.What);
                if (e.Cause == InstanceFailedCause.SYSTEM_PARTITION_DETECTED) {
                    return 2;
                }
                return 3;
            }
            catch (PERSIST_STORE e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-042", "Cannot connect to the local database.  Is local database server running ?  Will retry later.");
                this.AmortizedSleep();
            }
            catch (SystemException e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-043", "System exception: " + e.toString());
                this.m_FileLogger.LogWriteWarning("XMJU02-045", "Is FaultTolerance Running? - Will try to reconnect");
                this.AmortizedSleep();
                this.RenewReplicationManager();
            }
            catch (UserException e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-046", "User exception: " + e.toString());
                this.m_FileLogger.LogWriteWarning("XMJU02-046", "Can't tell the Replication Manager we're running? - Will retry");
                this.AmortizedSleep();
            }
        }
        return 6;
    }

    private void ComponentStopping() {
        this.replicaState.changeState(0);
        if (this.m_bIsPrimary) {
            this.m_PrimaryInstance = null;
        }
        do {
            try {
                this.m_ReplicationManager.ComponentStopping(this.m_LocationId, this.m_strComponentType, this.m_ComponentDescription);
                break;
            }
            catch (SystemException e) {
            }
            catch (UserException userException) {
                // empty catch block
            }
            this.RenewReplicationManager();
        } while (!this.m_bTerminate);
    }

    private static String getCorbalocForReplicationManager(String host) {
        StringBuffer corbaloc = new StringBuffer();
        corbaloc.append("corbaloc:iiop:");
        corbaloc.append(host);
        corbaloc.append(":");
        corbaloc.append(Port.FaultTolerancePort());
        corbaloc.append("/");
        corbaloc.append("FtSystem45");
        return corbaloc.toString();
    }

    private void RenewReplicationManager() {
        String host = this.m_HostIterator.current();
        while (!this.m_bTerminate) {
            String corbaloc = LegacyDbReplicationComponent.getCorbalocForReplicationManager(host);
            this.m_FileLogger.LogWriteLowLevel("XMJU02-049", "LegacyDbReplicationComponent - RenewReplicationManager (" + corbaloc + ")...");
            try {
                this.m_ReplicationManager = SystemHelper.narrow(this.m_Orb.string_to_object(corbaloc));
                if (null != this.m_ReplicationManager) {
                    Any timeout_value = this.m_Orb.create_any();
                    timeout_value.insert_ulonglong(864000000000L);
                    Policy policy = this.m_Orb.create_policy(32, timeout_value);
                    this.m_ReplicationManager = SystemHelper.narrow(this.m_ReplicationManager._set_policy_override(new Policy[]{policy}, SetOverrideType.SET_OVERRIDE));
                    this.m_FileLogger.LogWriteLowLevel("XMJU02-053", "LegacyDbReplicationComponent - RenewReplicationManager (" + corbaloc + ")...Done");
                    break;
                }
                this.m_FileLogger.LogWriteFatalError("XMJU02-051", "Can't connect to ReplicationManager - Is FaultTolerance running? - Waiting to retry connection");
            }
            catch (SystemException e) {
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", e.toString());
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", "Can't connect to ReplicationManager on host " + host + " - Is FaultTolerance running? - Waiting to retry connection");
            }
            catch (PolicyError e) {
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", e.toString());
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", "Failed to apply timeout policy on ReplicationManager");
            }
            if ((host = this.m_HostIterator.nextOrRefreshAndNull()) != null) continue;
            this.AmortizedSleep();
            host = this.m_HostIterator.current();
        }
    }

    private boolean NameComponentArrayEquals(NameComponent[] nc1, NameComponent[] nc2) {
        boolean is_equal = nc1.length == nc2.length;
        for (int i = 0; is_equal && i < nc1.length; ++i) {
            is_equal = nc1[i].id.equals(nc2[i].id) && nc1[i].kind.equals(nc2[i].kind);
        }
        return is_equal;
    }

    private void Recover() throws DbSynchronizationFailed, DbVersionMismatchException, DbConnectException, UnreconciliablePartitionException {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-054", "LegacyDbReplicationComponent - Recover...");
        if (!this.m_bIsPrimary) {
            LegacyReplicatedDatabase.NamedDatabase source = this.m_Dbs.getFirstBackup();
            if (source == null) {
                DatabaseInfo PrimaryDatabaseInfo = this.m_PrimaryInstance.DbInfo();
                JdbcWrapper database = new JdbcWrapper(PrimaryDatabaseInfo.DbHost, PrimaryDatabaseInfo.DbName, PrimaryDatabaseInfo.DbUser, PrimaryDatabaseInfo.DbPassword, PrimaryDatabaseInfo.DbmsType, PrimaryDatabaseInfo.DbPort);
                source = new LegacyReplicatedDatabase.NamedDatabase(this.m_PrimaryInstance.DatabaseId(), database);
            }
            DbComponentInstance this_instance = null;
            try {
                this_instance = DbComponentInstanceHelper.narrow(this.m_Poa.servant_to_reference((Servant)this));
            }
            catch (UserException ex) {
                this.m_FileLogger.LogWriteWarning("XMJU02-103", "LegacyDbReplicationComponent - Recover...Error - " + ex.getMessage());
                throw new DbSynchronizationFailed(ex.getMessage() == null ? "" : ex.getMessage());
            }
            this.m_DbSynchronizer.Synchronize(source.database(), source.id(), this.m_PrimaryInstance, this_instance);
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU02-055", "LegacyDbReplicationComponent - Recover...Done");
    }

    public boolean Init(ReplicatedService TheService, String strServiceGuid, String strServiceName, LegacyDbSynchronizer Synchronizer, DatabaseInfo LocalDatabaseInfo, ORB orb) {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-000", "LegacyDbReplicationComponent - Initialization...");
        this.m_Orb = orb;
        this.m_DbSynchronizer = Synchronizer;
        try {
            this.m_Poa = POAHelper.narrow((Object)this.m_Orb.resolve_initial_references("RootPOA"));
            this.m_Poa.the_POAManager().activate();
        }
        catch (InvalidName e) {
        }
        catch (AdapterInactive e) {
            // empty catch block
        }
        this.m_Service = TheService;
        this.m_strServiceGuid = strServiceGuid;
        this.m_ComponentGroupId = this.LoadComponentGroupId(this.m_strComponentType);
        this.m_LocationId = LegacyDbReplicationComponent.getLocationId(strServiceName, this.m_strComponentName);
        this.m_ComponentDescription = LegacyDbReplicationComponent.getComponentDescription(this.m_Orb);
        this.m_Dbs.init(LocalDatabaseInfo, this);
        this.RenewReplicationManager();
        switch (this.ComponentStarting()) {
            case 1: {
                this.m_FileLogger.LogWriteLowLevel("XMJU02-002", "LegacyDbReplicationComponent - Initialization...Done");
                return true;
            }
            case 2: {
                this.m_FileLogger.LogWriteFatalError("XMJU02-108", "LegacyDbReplicationComponent - Initialization...Failed");
                this.m_FileLogger.LogWriteFatalError("XMJU02-108", "Pretending to be started to let another thread find beginning of the partition");
                return true;
            }
        }
        this.m_FileLogger.LogWriteFatalError("XMJU02-003", "LegacyDbReplicationComponent - Initialization...Failed");
        NtService.GetInstance().StopService();
        return false;
    }

    public synchronized void Stop() {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-004", "LegacyDbReplicationComponent - Stop called");
        this.m_bTerminate = true;
        this.notifyAll();
        try {
            if (null != this.m_ReplicationManager) {
                this.m_ReplicationManager.ComponentStopping(this.m_LocationId, this.m_strComponentType, this.m_ComponentDescription);
            }
        }
        catch (SystemException e) {
        }
        catch (UserException userException) {
            // empty catch block
        }
        this.CloseAllDbConnections();
    }

    public synchronized boolean ChangeActiveState(int NewState) {
        return this.replicaState.changeState(NewState) != NewState;
    }

    public boolean PrepareDatabase() throws DbConnectException {
        return this.m_Service.PrepareDatabase();
    }

    public ResultSet ExecuteQuery(String Query) throws SQLException {
        return this.m_Dbs.executeQuery(Query);
    }

    public synchronized int ExecuteUpdate(String Query) throws SQLException {
        return this.m_Dbs.executeUpdate(Query);
    }

    public synchronized boolean GetAutoCommit() throws SQLException {
        return this.m_Dbs.getAutoCommit();
    }

    public synchronized void SetAutoCommit(boolean autoCommit) throws SQLException {
        this.m_Dbs.setAutoCommit(autoCommit);
    }

    public synchronized void Commit() throws SQLException {
        this.m_Dbs.commit();
    }

    public synchronized void Rollback() throws SQLException {
        this.m_Dbs.rollback();
    }

    public void CloseAllDbConnections() {
        this.m_Dbs.disconnectAll();
    }

    public boolean IsOracle() {
        return this.m_Dbs.isOracle();
    }

    public boolean IsMySql() {
        return this.m_Dbs.isMySql();
    }

    public DatabaseMetaData GetMetaData() throws SQLException {
        return this.m_Dbs.getMetaData();
    }

    public static String AddSlashes(String strText) {
        return JdbcWrapper.AddSlashes(strText);
    }

    public String ValidateColumnName(String strInitialName) {
        return this.m_Dbs.validateColumnName(strInitialName);
    }

    public String Limit(int Offset2, int NbRecords) {
        return this.m_Dbs.limit(Offset2, NbRecords);
    }

    public Subscription RegisterMonitor(Monitor TheMonitor, long Interval) throws UnsupportedInterval {
        throw new NO_IMPLEMENT();
    }

    public boolean is_alive() {
        return this.m_bIsAlive;
    }

    public void Fault() {
        this.m_FileLogger.LogWriteWarning("XMJU02-014", "Fault called from Replication Manager");
        this.AssociatedDatabaseFailed();
    }

    public Object[] InitGroup(NameComponent[] GroupId, String[] PartIds) throws InstanceFailed {
        this.m_FileLogger.LogWriteNormal("XMJU02-015", "LegacyDbReplicationComponent - Initializing as a primary component...");
        this.m_ComponentGroupId = GroupId;
        this.SaveComponentGroupId(this.m_ComponentGroupId);
        this.m_bIsPrimary = true;
        this.m_Dbs.resetDatabases();
        try {
            this.m_PrimaryInstance = DbComponentInstanceHelper.narrow(this.m_Poa.servant_to_reference((Servant)this));
            this.replicaState.changeState(0);
            this.Activate();
            this.replicaState.changeState(1);
        }
        catch (InstanceFailed ex) {
            this.m_FileLogger.LogWriteWarning("XMJU02-098", "LegacyDbReplicationComponent - Initializing as a primary component...Error - Should not come here - Xm.FaultTolerance.ComponentInstancePackage.InstanceFailed");
        }
        catch (UserException ex) {
            this.m_FileLogger.LogWriteWarning("XMJU02-100", "LegacyDbReplicationComponent - Initializing as a primary component...Error - " + ex.getMessage());
        }
        return this.m_Service.GetObjects(PartIds);
    }

    public Object[] JoinGroup(ComponentGroupInfo GroupInfo, String[] PartIds) throws InstanceFailed, NoGroupMemberActive {
        this.m_FileLogger.LogWriteNormal("XMJU02-016", "LegacyDbReplicationComponent - Initializing as a backup component...");
        if (!this.NameComponentArrayEquals(this.m_ComponentGroupId, GroupInfo.GroupId)) {
            if (!this.m_DbSynchronizer.OnAddHost()) {
                throw new InstanceFailed("", InstanceFailedCause.SYNCHRONIZATION_FAILED, "Could not backup the database on this AddHost operation");
            }
            this.m_ComponentGroupId = GroupInfo.GroupId;
            this.SaveComponentGroupId(this.m_ComponentGroupId);
        }
        this.m_bIsPrimary = false;
        this.m_Dbs.resetDatabases();
        this.UpdateBackupAndPrimaryLists(GroupInfo);
        this.replicaState.changeState(0);
        this.Activate();
        this.replicaState.changeState(2);
        return this.m_Service.GetObjects(PartIds);
    }

    public Object[] MergeIntoGroup(ComponentGroupInfo GroupInfo, String[] PartIds, ComponentInstanceInfo[] ExpectedViewFromSystem) throws InstanceFailed, NoGroupMemberActive {
        this.m_FileLogger.LogWriteNormal("XMJU02-112", "LegacyDbReplicationComponent - MergeIntoGroup (delagates to JoinGroup)");
        return this.JoinGroup(GroupInfo, PartIds);
    }

    public Object[] RestartGroup(ComponentGroupInfo GroupInfo, String[] PartIds) throws InstanceFailed, UnknownGroup {
        this.m_FileLogger.LogWriteNormal("XMJU02-017", "LegacyDbReplicationComponent - Reinitializing as a primary component...");
        this.m_ComponentGroupId = GroupInfo.GroupId;
        this.SaveComponentGroupId(this.m_ComponentGroupId);
        this.m_bIsPrimary = true;
        this.m_Dbs.resetDatabases();
        try {
            this.m_PrimaryInstance = DbComponentInstanceHelper.narrow(this.m_Poa.servant_to_reference((Servant)this));
        }
        catch (UserException ex) {
            this.m_FileLogger.LogWriteWarning("XMJU02-101", "LegacyDbReplicationComponent - Reinitializing as a primary component...Error - " + ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, ex.getMessage() == null ? "" : ex.getMessage());
        }
        this.UpdateBackupAndPrimaryLists(GroupInfo);
        this.replicaState.changeState(0);
        this.Activate();
        this.replicaState.changeState(1);
        return this.m_Service.GetObjects(PartIds);
    }

    public void GroupUpdate(ComponentGroupInfo NewInfo, PartGroupInfo[] PartRefs) {
        this.m_FileLogger.LogWriteNormal("XMJU02-018", "LegacyDbReplicationComponent - Received a GroupUpdate");
        if (this.replicaState.currentState() == 1) {
            this.UpdateBackupAndPrimaryLists(NewInfo);
        }
        this.m_FileLogger.LogWriteNormal("XMJU02-030", "LegacyDbReplicationComponent - GroupUpdate processed");
    }

    public Object[] GetPartReferences(String[] PartIds) throws InstanceFailed {
        return this.m_Service.GetObjects(PartIds);
    }

    public Object GetFacet(String FacetId) throws UnsupportedFacet {
        throw new NO_IMPLEMENT("Should not be called, the primary does all the work");
    }

    public String DatabaseId() {
        return this.m_strServiceGuid;
    }

    public DatabaseInfo DbInfo() {
        return this.m_Dbs.dbInfo();
    }

    public void NotifyRecovered(DbComponentInstance RecoveredDb, String SourceGuid) {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-034", "LegacyDbReplicationComponent - Another Database recovered, adding to our backup list...");
        if (this.m_Dbs.addBackup(RecoveredDb)) {
            this.m_FileLogger.LogWriteLowLevel("XMJU02-035", "LegacyDbReplicationComponent - Another Database recovered, adding to our backup list...Done");
        }
    }

    public void AssociatedDatabaseFailed() {
        if (!this.m_bTerminate && this.ChangeActiveState(0)) {
            this.CloseAllDbConnections();
            class ComponentStartingThread
            extends Thread {
                private LegacyDbReplicationComponent m_Obj = null;

                public ComponentStartingThread(LegacyDbReplicationComponent Obj) {
                    this.setName("ComponentStartingThread");
                    this.m_Obj = Obj;
                }

                public void run() {
                    this.m_Obj.RestartComponent();
                }
            }
            ComponentStartingThread exec = new ComponentStartingThread(this);
            exec.start();
        }
    }

    static {
        java.lang.System.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.Xm.JavaUtils.ComponentInterceptorInitializer", "Xm.JavaUtils.ComponentInterceptorInitializer");
    }

    private static interface StartingState {
        public static final int STARTED = 1;
        public static final int PARTITION_DETECTED = 2;
        public static final int INSTANCE_FAILED = 3;
        public static final int UNKNOWN_TYPE = 4;
        public static final int ALREADY_ACTIVE = 5;
        public static final int SHUTTING_DOWN = 6;
    }
}

