/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.IFilterElementToString;
import Xm.JavaUtils.Database.IFilterElementVisitor;
import Xm.JavaUtils.Database.ISource;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Join
implements ISource {
    private static final long serialVersionUID = -8448170061278768565L;
    private Type type;
    private ISource table1;
    private ISource table2;
    private IFilterElement onClause;
    private List<String> usingClause;

    private Join(Type type, ISource table1, ISource table2, IFilterElement onClause, List<String> usingClause) {
        this.type = type;
        this.table1 = table1;
        this.table2 = table2;
        this.onClause = onClause;
        this.usingClause = usingClause;
    }

    public static Join left(ISource table1, ISource table2, IFilterElement clause) {
        return new Join(Type.LEFT, table1, table2, clause, null);
    }

    public static Join left(ISource table1, ISource table2, List<String> using) {
        return new Join(Type.LEFT, table1, table2, null, using);
    }

    public static Join inner(ISource table1, ISource table2, IFilterElement clause) {
        return new Join(Type.INNER, table1, table2, clause, null);
    }

    public static Join inner(ISource table1, ISource table2, List<String> using) {
        return new Join(Type.INNER, table1, table2, null, using);
    }

    public static Join straight(ISource table1, ISource table2, IFilterElement clause) {
        return new Join(Type.STRAIGHT, table1, table2, clause, null);
    }

    public Type getType() {
        return this.type;
    }

    public ISource getTable1() {
        return this.table1;
    }

    public ISource getTable2() {
        return this.table2;
    }

    public IFilterElement getOnClause() {
        return this.onClause;
    }

    public List<String> getUsingClause() {
        return this.usingClause;
    }

    @Override
    public String toString(IFilterElementToString visitor) {
        return visitor.toString(this);
    }

    @Override
    public void accept(IFilterElementVisitor visitor) {
        visitor.visit(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INNER,
        STRAIGHT,
        LEFT;

    }
}

