/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbInfo;
import Xm.JavaUtils.Database.MySQLDbConnection;
import Xm.JavaUtils.SingletonFileLogger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JdbcWrapper {
    private DbInfo dbInfo;
    private String dbmsType;
    private MySQLDbConnection connection;

    public JdbcWrapper(String DbHost, String DbName, String DbUser, String DbPassword, String DbmsType, String DbPort) {
        this.dbInfo = new DbInfo(DbHost, DbPort, DbName, DbUser, DbPassword);
        this.dbmsType = DbmsType.toLowerCase();
        this.connection = null;
    }

    public void finalize() {
        this.Disconnect();
    }

    public synchronized void Pause() {
        this.Disconnect();
    }

    public boolean IsOracle() {
        return this.dbmsType.equals("oracle");
    }

    public boolean IsMySql() {
        return this.dbmsType.equals("mysql");
    }

    private boolean IsConnected() {
        return this.connection != null;
    }

    public synchronized void Connect() throws DbConnectException {
        if (this.IsConnected()) {
            return;
        }
        try {
            if (!this.IsMySql()) {
                throw new DbConnectException("JdbcWrapper Connect - DBMS not supported: " + this.dbmsType);
            }
            this.connection = new MySQLDbConnection(this.dbInfo, false);
        }
        catch (DbConnectException ex) {
            SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU11-002", "JdbcWrapper Connect - DbConnectException: " + ex.getMessage());
            throw ex;
        }
        catch (SQLException ex) {
            SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU11-002", "JdbcWrapper Connect - SQLException: " + ex.getMessage());
            throw new DbConnectException("JdbcWrapper Connect Exception - " + ex.getMessage());
        }
    }

    public synchronized void Disconnect() {
        if (this.IsConnected()) {
            try {
                MySQLDbConnection temp = this.connection;
                this.connection = null;
                temp.close();
            }
            catch (Exception e) {
                SingletonFileLogger.GetInstance().LogWriteWarning("XMJU11-003", "Database disconnection: " + e.getMessage());
            }
        }
    }

    public synchronized void AssertDbConnection() throws DbConnectException {
        this.Disconnect();
        this.Connect();
    }

    public synchronized DatabaseMetaData GetMetaData() throws SQLException, DbConnectException {
        this.Connect();
        try {
            return this.connection.getMetaData();
        }
        catch (DbConnectException ex) {
            this.Disconnect();
            throw ex;
        }
    }

    public static String AddSlashes(String strText) {
        if (strText == null) {
            return "";
        }
        StringBuffer strNewText = new StringBuffer(strText.length() * 2);
        block5: for (int i = 0; i < strText.length(); ++i) {
            char c = strText.charAt(i);
            switch (c) {
                case '\'': {
                    strNewText.append("\\'");
                    continue block5;
                }
                case '\"': {
                    strNewText.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    strNewText.append("\\\\");
                    continue block5;
                }
                default: {
                    strNewText.append(c);
                }
            }
        }
        return strNewText.toString();
    }

    public static String MySQLValidateColumnName(String name) {
        name = name.trim();
        String temp = name.substring(0, Math.min(64, name.length()));
        return JdbcWrapper.AddSlashes(temp);
    }

    public static String OracleValidateColumnName(String name) {
        String temp = "";
        if (!Character.isLetter((name = name.trim()).charAt(0))) {
            temp = temp + "z";
        }
        name = name.replace(' ', '_');
        for (int i = 0; i < name.length(); ++i) {
            temp = Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '_' ? temp + name.charAt(i) : temp + "_";
        }
        temp = temp.substring(0, Math.min(30, temp.length()));
        return JdbcWrapper.AddSlashes(temp);
    }

    public String ValidateColumnName(String strInitialName) {
        if (this.IsOracle()) {
            return JdbcWrapper.OracleValidateColumnName(strInitialName);
        }
        return JdbcWrapper.MySQLValidateColumnName(strInitialName);
    }

    public static String Limit(long Offset2, long NbRecords) {
        return " LIMIT " + Offset2 + "," + NbRecords;
    }

    public synchronized ResultSet ExecuteQuery(String Query) throws SQLException, DbConnectException {
        this.Connect();
        try {
            return this.connection.executeSelect(Query);
        }
        catch (DbConnectException ex) {
            this.Disconnect();
            throw ex;
        }
    }

    public synchronized int ExecuteUpdate(String Query) throws SQLException, DbConnectException {
        this.Connect();
        try {
            return this.connection.executeUpdate(Query);
        }
        catch (DbConnectException ex) {
            this.Disconnect();
            throw ex;
        }
    }

    public synchronized boolean GetAutoCommit() throws SQLException, DbConnectException {
        this.Connect();
        try {
            return this.connection.getAutoCommit();
        }
        catch (DbConnectException ex) {
            this.Disconnect();
            throw ex;
        }
    }

    public synchronized void SetAutoCommit(boolean autoCommit) throws SQLException, DbConnectException {
        this.Connect();
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (DbConnectException ex) {
            this.Disconnect();
            throw ex;
        }
    }

    public synchronized void Commit() throws SQLException, DbConnectException {
        if (!this.IsConnected()) {
            throw new DbConnectException("Not connected");
        }
        try {
            this.connection.commit();
        }
        catch (DbConnectException ex) {
            this.Disconnect();
            throw ex;
        }
    }

    public synchronized void Rollback() throws SQLException, DbConnectException {
        if (!this.IsConnected()) {
            throw new DbConnectException("Not connected");
        }
        try {
            this.connection.rollback();
        }
        catch (DbConnectException ex) {
            this.Disconnect();
            throw ex;
        }
    }
}

