/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database.JavaCorbaConversion;

import Xm.JavaUtils.Database.BatchStatement;
import Xm.JavaUtils.Database.CreateFunctionStatement;
import Xm.JavaUtils.Database.CreateTableStatement;
import Xm.JavaUtils.Database.CreateTriggerStatement;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DeleteStatement;
import Xm.JavaUtils.Database.DropFunctionStatement;
import Xm.JavaUtils.Database.DropTableStatement;
import Xm.JavaUtils.Database.DropTriggerStatement;
import Xm.JavaUtils.Database.ISource;
import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.JavaCorbaConversion.BaseVisitorImpl;
import Xm.JavaUtils.Database.JavaCorbaConversion.ExpressionConverter;
import Xm.JavaUtils.Database.JavaCorbaConversion.NamedPropertyConverter;
import Xm.JavaUtils.Database.JavaCorbaConversion.ReplicateMediaStoreProperty;
import Xm.JavaUtils.Database.LockTablesStatement;
import Xm.JavaUtils.Database.RenameTablesStatement;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.SqlWriteStatementVisitor;
import Xm.JavaUtils.Database.UnlockTablesStatement;
import Xm.JavaUtils.Database.UpdateStatement;
import Xm.Sql.Statement;
import Xm.Sql.StatementCommonData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StatementConverter {
    private NamedPropertyConverter m_NamedPropertyConverter = new NamedPropertyConverter();
    private ExpressionConverter m_ExpressionConverter = new ExpressionConverter();

    public SqlWriteStatement toStatement(Statement statement) {
        switch (statement.discriminator().value()) {
            case 0: {
                return this.toInsertStatement(statement);
            }
            case 1: {
                return this.toUpdateStatement(statement);
            }
            case 2: {
                return this.toDeleteStatement(statement);
            }
        }
        throw new IllegalArgumentException("Invalid statement type " + statement.discriminator().value());
    }

    public Statement toStatement(SqlWriteStatement statement) {
        StatementVisitor visitor = new StatementVisitor();
        try {
            statement.accept(visitor);
        }
        catch (SQLException e) {
        }
        catch (DbConnectException dbConnectException) {
            // empty catch block
        }
        return visitor.getResult();
    }

    private InsertStatement toInsertStatement(Statement statement) {
        Xm.Sql.InsertStatement s = statement.TheInsertStatement();
        InsertStatement ret = new InsertStatement(s.Common.Name, null, this.m_NamedPropertyConverter.toColumnList(s.Data), this.m_NamedPropertyConverter.toValueList(s.Data), null, null, ReplicateMediaStoreProperty.createPropertiesWith(s.Common.replicateMediaStore), false);
        return ret;
    }

    private UpdateStatement toUpdateStatement(Statement statement) {
        Xm.Sql.UpdateStatement s = statement.TheUpdateStatement();
        UpdateStatement ret = new UpdateStatement(s.Common.Name, this.m_NamedPropertyConverter.toColumnList(s.SetData), this.m_NamedPropertyConverter.toValueList(s.SetData), this.m_ExpressionConverter.toFilter(s.WhereData), ReplicateMediaStoreProperty.createPropertiesWith(s.Common.replicateMediaStore));
        return ret;
    }

    private DeleteStatement toDeleteStatement(Statement statement) {
        Xm.Sql.DeleteStatement s = statement.TheDeleteStatement();
        List<String> tables = Arrays.asList(s.Common.Name);
        DeleteStatement ret = new DeleteStatement(tables, new ArrayList<ISource>(), this.m_ExpressionConverter.toFilter(s.WhereData), -1, -1, ReplicateMediaStoreProperty.createPropertiesWith(s.Common.replicateMediaStore));
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatementVisitor
    extends BaseVisitorImpl<Statement>
    implements SqlWriteStatementVisitor {
        private Statement m_Result;

        private StatementVisitor() {
        }

        @Override
        public Statement getResult() {
            return this.m_Result;
        }

        @Override
        public void visit(InsertStatement statement) {
            Xm.Sql.InsertStatement s = new Xm.Sql.InsertStatement();
            s.Common = new StatementCommonData(statement.table(), ReplicateMediaStoreProperty.get(statement.getProperties()));
            s.Data = StatementConverter.this.m_NamedPropertyConverter.toNamedPropertyArray(statement.columns(), statement.values());
            this.m_Result = new Statement();
            this.m_Result.TheInsertStatement(s);
        }

        @Override
        public void visit(UpdateStatement statement) {
            Xm.Sql.UpdateStatement s = new Xm.Sql.UpdateStatement();
            s.Common = new StatementCommonData(statement.table(), ReplicateMediaStoreProperty.get(statement.getProperties()));
            s.SetData = StatementConverter.this.m_NamedPropertyConverter.toNamedPropertyArray(statement.columns(), statement.values());
            s.WhereData = StatementConverter.this.m_ExpressionConverter.toExpression(statement.getFilter());
            this.m_Result = new Statement();
            this.m_Result.TheUpdateStatement(s);
        }

        @Override
        public void visit(DeleteStatement statement) {
            Xm.Sql.DeleteStatement s = new Xm.Sql.DeleteStatement();
            s.Common = new StatementCommonData(statement.tables().get(0), ReplicateMediaStoreProperty.get(statement.getProperties()));
            s.WhereData = StatementConverter.this.m_ExpressionConverter.toExpression(statement.getFilter());
            this.m_Result = new Statement();
            this.m_Result.TheDeleteStatement(s);
        }

        @Override
        public void visit(CreateTableStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(LockTablesStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(UnlockTablesStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(DropTableStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(RenameTablesStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(BatchStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(CreateTriggerStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(DropTriggerStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(CreateFunctionStatement statement) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(DropFunctionStatement statement) {
            this.unsupportedVisit();
        }
    }
}

