/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database.JavaCorbaConversion;

import Xm.FaxArchive.OffsiteReplication.IsNull;
import Xm.FaxArchive.OffsiteReplication.NamedColumn;
import Xm.FaxArchive.OffsiteReplication.NullableDate;
import Xm.FaxArchive.OffsiteReplication.NullableString;
import Xm.FaxArchive.OffsiteReplication.RecordSet;
import Xm.FaxArchive.OffsiteReplication.TypedColumn;
import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.JavaCorbaConversion.ReplicateMediaStoreProperty;
import Xm.JavaUtils.Database.NullValue;
import Xm.JavaUtils.Database.Record;
import Xm.JavaUtils.Database.TableInfo;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordSetConverter {
    private List<String> excludedColumns = new ArrayList<String>();
    private List<String> m_excludedDuplicateKeyColumns = new ArrayList<String>();
    private String siteIdColumn;

    public void setSiteIdColumn(String siteIdColumn) {
        this.siteIdColumn = siteIdColumn;
    }

    public void addColumnToExclude(String columnsName) {
        this.excludedColumns.add(columnsName);
    }

    public void addDuplicateKeyColumnToExclude(String columnName) {
        this.m_excludedDuplicateKeyColumns.add(columnName);
    }

    public RecordSet toRecordSet(ResultSet resultSet, boolean allReplicateMediaStore) throws IllegalResultSetException, SQLException {
        return this.toRecordSet(resultSet, allReplicateMediaStore, null);
    }

    public RecordSet toRecordSet(ResultSet resultSet, List<String> sitesToReplicateMediaStore) throws IllegalResultSetException, SQLException {
        return this.toRecordSet(resultSet, false, sitesToReplicateMediaStore);
    }

    private static boolean containsIgnoreCase(List<String> list, String string) {
        for (String item : list) {
            if (!item.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private RecordSet toRecordSet(ResultSet resultSet, boolean allReplicateMediaStore, List<String> sitesToReplicateMediaStore) throws IllegalResultSetException, SQLException {
        RecordSet ret = new RecordSet();
        ResultSetMetaData meta = resultSet.getMetaData();
        ret.TableName = meta.getTableName(1);
        ArrayList<NamedColumn> data = new ArrayList<NamedColumn>();
        ArrayList dataList = new ArrayList();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            if (RecordSetConverter.containsIgnoreCase(this.excludedColumns, meta.getColumnName(i))) continue;
            NamedColumn namedColumn = new NamedColumn();
            namedColumn.Name = meta.getColumnName(i);
            data.add(namedColumn);
            dataList.add(new ArrayList());
        }
        ret.NumRecords = 0;
        ArrayList<Boolean> replicateMediaStore = new ArrayList<Boolean>();
        while (resultSet.next()) {
            ++ret.NumRecords;
            int dest_data_index = 0;
            for (int source_data_index = 1; source_data_index <= meta.getColumnCount(); ++source_data_index) {
                String sourceColumn = meta.getColumnName(source_data_index);
                if (sourceColumn.equals(this.siteIdColumn) && sitesToReplicateMediaStore != null) {
                    Boolean b = sitesToReplicateMediaStore.contains((String)this.getObjectFromResultSet((ResultSetMetaData)meta, (ResultSet)resultSet, (int)source_data_index).object);
                    replicateMediaStore.add(b);
                }
                if (RecordSetConverter.containsIgnoreCase(this.excludedColumns, sourceColumn)) continue;
                ((ArrayList)dataList.get(dest_data_index++)).add(this.getObjectFromResultSet(meta, resultSet, source_data_index));
            }
        }
        ret.replicateMediaStore = new boolean[ret.NumRecords];
        if (this.siteIdColumn != null) {
            if (sitesToReplicateMediaStore == null) {
                Arrays.fill(ret.replicateMediaStore, allReplicateMediaStore);
            } else {
                Boolean[] booleanArray = replicateMediaStore.toArray(new Boolean[0]);
                for (int i = 0; i < booleanArray.length; ++i) {
                    ret.replicateMediaStore[i] = booleanArray[i];
                }
            }
        }
        for (int i = 0; i < data.size(); ++i) {
            ((NamedColumn)data.get((int)i)).Data = this.toTypedColumn((List)dataList.get(i));
        }
        ret.Data = data.toArray(new NamedColumn[0]);
        return ret;
    }

    public List<InsertStatement> toInsertStatementList(RecordSet recordSet, boolean addOnDuplicateKeyUpdate) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (NamedColumn c : recordSet.Data) {
            columnNames.add(c.Name);
        }
        ArrayList<InsertStatement> ret = new ArrayList<InsertStatement>();
        for (int i = 0; i < recordSet.NumRecords; ++i) {
            List<Object> valueLists = RecordSetConverter.toListObject(recordSet.Data, i);
            ArrayList<String> onDuplicateKeyUpdateColumns = null;
            ArrayList<Object> onDuplicateKeyUpdateValues = null;
            if (addOnDuplicateKeyUpdate) {
                onDuplicateKeyUpdateColumns = new ArrayList<String>();
                onDuplicateKeyUpdateValues = new ArrayList<Object>();
                for (int col = 0; col < columnNames.size(); ++col) {
                    if (this.m_excludedDuplicateKeyColumns.contains(columnNames.get(col))) continue;
                    onDuplicateKeyUpdateColumns.add((String)columnNames.get(col));
                    onDuplicateKeyUpdateValues.add(valueLists.get(col));
                }
            }
            ret.add(new InsertStatement(recordSet.TableName, null, columnNames, valueLists, onDuplicateKeyUpdateColumns, onDuplicateKeyUpdateValues, ReplicateMediaStoreProperty.createPropertiesWith(recordSet.replicateMediaStore[i]), false));
        }
        return ret;
    }

    private ResultSetObject getObjectFromResultSet(ResultSetMetaData meta, ResultSet resultSet, int index) throws SQLException, IllegalResultSetException {
        Object o = null;
        Class<?> c = null;
        try {
            c = Class.forName(meta.getColumnClassName(index));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalResultSetException("Cannot find class with name " + meta.getColumnClassName(index) + " at index " + index, e);
        }
        if (c == Boolean.class) {
            o = resultSet.getBoolean(index);
        } else if (c == Integer.class) {
            o = resultSet.getInt(index);
        } else if (c == String.class) {
            o = resultSet.getString(index);
        } else if (c == Timestamp.class) {
            o = resultSet.getTimestamp(index);
        } else if (c == BigInteger.class) {
            o = resultSet.getLong(index);
        } else {
            throw new IllegalResultSetException("Invalid class " + c + " at index " + index);
        }
        return new ResultSetObject(o, c);
    }

    private TypedColumn toTypedColumn(List<ResultSetObject> list) {
        TypedColumn ret = new TypedColumn();
        if (list.isEmpty()) {
            return ret;
        }
        Class<?> c = list.get((int)0).object_class;
        if (c == Boolean.class) {
            boolean[] data = new boolean[list.size()];
            for (int j = 0; j < data.length; ++j) {
                data[j] = (Boolean)list.get((int)j).object;
            }
            ret.boolean_column(data);
        } else if (c == Integer.class) {
            int[] data = new int[list.size()];
            for (int j = 0; j < data.length; ++j) {
                data[j] = (Integer)list.get((int)j).object;
            }
            ret.long_column(data);
        } else if (c == String.class) {
            NullableString[] data = new NullableString[list.size()];
            for (int j = 0; j < data.length; ++j) {
                String s = (String)list.get((int)j).object;
                data[j] = new NullableString();
                if (s != null) {
                    data[j].TheString(s);
                    continue;
                }
                data[j].__default(IsNull.eNull);
            }
            ret.wstring_column(data);
        } else if (c == Timestamp.class) {
            NullableDate[] data = new NullableDate[list.size()];
            for (int j = 0; j < data.length; ++j) {
                Timestamp t = (Timestamp)list.get((int)j).object;
                data[j] = new NullableDate();
                if (t != null) {
                    data[j].TheDate((int)(t.getTime() / 1000L));
                    continue;
                }
                data[j].__default(IsNull.eNull);
            }
            ret.nullable_date_column(data);
        } else if (c == BigInteger.class) {
            int[] data = new int[list.size()];
            for (int j = 0; j < data.length; ++j) {
                data[j] = ((Long)list.get((int)j).object).intValue();
            }
            ret.long_column(data);
        } else {
            throw new IllegalArgumentException("Invalid class " + c);
        }
        return ret;
    }

    private static List<Object> toListObject(NamedColumn[] columns, int index) {
        ArrayList<Object> ret = new ArrayList<Object>();
        block7: for (NamedColumn c : columns) {
            switch (c.Data.discriminator().value()) {
                case 3: {
                    ret.add(c.Data.boolean_column()[index]);
                    continue block7;
                }
                case 1: {
                    ret.add(c.Data.long_column()[index]);
                    continue block7;
                }
                case 2: {
                    NullableString s = c.Data.wstring_column()[index];
                    if (s.discriminator() == IsNull.eNotNull) {
                        ret.add(s.TheString());
                        continue block7;
                    }
                    ret.add(NullValue.getInstance());
                    continue block7;
                }
                case 5: {
                    ret.add(new Timestamp((long)c.Data.date_column()[index] * 1000L));
                    continue block7;
                }
                case 8: {
                    NullableDate d = c.Data.nullable_date_column()[index];
                    if (d.discriminator() == IsNull.eNotNull) {
                        ret.add(new Timestamp((long)d.TheDate() * 1000L));
                        continue block7;
                    }
                    ret.add(NullValue.getInstance());
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Invalid property type " + c.Data.discriminator().value());
                }
            }
        }
        return ret;
    }

    public static List<Record> toRecordList(RecordSet recordSet, TableInfo tableInfo) {
        ArrayList<Record> records = new ArrayList<Record>(recordSet.NumRecords);
        for (int i = 0; i < recordSet.NumRecords; ++i) {
            Record record = new Record(tableInfo);
            List<Object> values = RecordSetConverter.toListObject(recordSet.Data, i);
            assert (values.size() == recordSet.Data.length);
            for (int j = 0; j < values.size(); ++j) {
                record.set(recordSet.Data[j].Name, values.get(j));
            }
            records.add(record);
        }
        return records;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultSetObject {
        public Object object;
        public Class<?> object_class;

        public ResultSetObject(Object obj, Class<?> obj_class) {
            this.object = obj;
            this.object_class = obj_class;
        }
    }

    public static class IllegalResultSetException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalResultSetException(String message) {
            super(message);
        }

        public IllegalResultSetException(Throwable cause) {
            super(cause);
        }

        public IllegalResultSetException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

