/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database.JavaCorbaConversion;

import Xm.JavaUtils.Database.NullValue;
import Xm.NamedProperty;
import Xm.PropertyType;
import Xm.TypedValue;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedPropertyConverter {
    public String toColumn(NamedProperty property) {
        return property.Name;
    }

    public Object toValue(TypedValue typedValue) {
        switch (typedValue.discriminator().value()) {
            case 3: {
                return new Boolean(typedValue.boolean_value());
            }
            case 1: {
                return new Integer(typedValue.long_value());
            }
            case 2: {
                return typedValue.wstring_value();
            }
            case 5: {
                return new Timestamp((long)typedValue.date_value() * 1000L);
            }
            case 0: {
                return NullValue.getInstance();
            }
        }
        throw new IllegalArgumentException("Invalid value " + typedValue.discriminator().value());
    }

    public TypedValue toTypedValue(Object value) {
        TypedValue ret = new TypedValue();
        if (value == NullValue.getInstance()) {
            ret.__default(PropertyType.ptInvalid);
        } else {
            Class<?> inputClass = value.getClass();
            if (inputClass == Integer.class) {
                ret.long_value((Integer)value);
            } else if (inputClass == Timestamp.class) {
                ret.date_value((int)(((Timestamp)value).getTime() / 1000L));
            } else if (inputClass == Boolean.class) {
                ret.boolean_value((Boolean)value);
            } else if (inputClass == String.class) {
                ret.wstring_value((String)value);
            } else {
                throw new IllegalArgumentException("Invalid class " + inputClass);
            }
        }
        return ret;
    }

    public NamedProperty toNamedProperty(String column, Object value) {
        NamedProperty ret = new NamedProperty();
        ret.Name = column;
        ret.Value = this.toTypedValue(value);
        return ret;
    }

    public NamedProperty[] toNamedPropertyArray(List<String> columns, List<Object> values) {
        NamedProperty[] properties = new NamedProperty[columns.size()];
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = this.toNamedProperty(columns.get(i), values.get(i));
        }
        return properties;
    }

    public List<String> toColumnList(NamedProperty[] properties) {
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < properties.length; ++i) {
            columns.add(this.toColumn(properties[i]));
        }
        return columns;
    }

    public List<Object> toValueList(NamedProperty[] properties) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < properties.length; ++i) {
            values.add(this.toValue(properties[i].Value));
        }
        return values;
    }
}

