/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database.JavaCorbaConversion;

import Xm.List;
import Xm.Records;
import Xm.TypedColumn;
import Xm.TypedValue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListConverter<MappedClass> {
    private Class<MappedClass> structClass;
    private String idMapping;
    private Map<String, String> mapping = new TreeMap<String, String>();
    private ArrayList<String> properties = new ArrayList();
    private Map<String, ListConverter<?>> sublistMapping = new TreeMap();

    public ListConverter(Class<MappedClass> structClass) {
        this.structClass = structClass;
    }

    public java.util.List<MappedClass> toJavaList(List list) throws InstantiationException, IllegalAccessException, UserException, InvocationTargetException, NoSuchMethodException {
        Records records = list.GetAllRecords(this.properties.toArray(new String[0]));
        ArrayList<MappedClass> ret = new ArrayList<MappedClass>();
        if (records.Ids.length != 0) {
            assert (records.Columns.length == this.properties.size());
            for (int i = 0; i < records.Ids.length; ++i) {
                MappedClass row_element = this.structClass.newInstance();
                if (this.idMapping != null) {
                    PropertyUtils.setSimpleProperty(row_element, (String)this.idMapping, (Object)records.Ids[i]);
                }
                for (int j = 0; j < records.Columns.length; ++j) {
                    String property = this.properties.get(j);
                    String field = this.mapping.get(property);
                    if (field == null) {
                        throw new IllegalArgumentException("Property " + property + " not mapped");
                    }
                    if (this.sublistMapping.get(property) != null) {
                        List sublist = list.GetListInterface(records.Ids[i], property);
                        java.util.List<?> l = this.sublistMapping.get(property).toJavaList(sublist);
                        PropertyUtils.setSimpleProperty(row_element, (String)field, l);
                        continue;
                    }
                    this.set(row_element, field, records.Columns[j], i);
                }
                ret.add(row_element);
            }
        }
        return ret;
    }

    public TypedValue[] toTypedValues(MappedClass entity) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        TypedValue[] values = new TypedValue[this.properties.size()];
        for (int index = 0; index < this.properties.size(); ++index) {
            String field = this.mapping.get(this.properties.get(index));
            Object value = PropertyUtils.getSimpleProperty(entity, (String)field);
            values[index] = new TypedValue();
            if (value instanceof String) {
                values[index].wstring_value((String)value);
                continue;
            }
            if (value instanceof Long) {
                values[index].long_value(((Long)value).intValue());
                continue;
            }
            if (value instanceof Boolean) {
                values[index].boolean_value((Boolean)value);
                continue;
            }
            throw new IllegalArgumentException("Property type " + this.properties.get(index) + " not supported");
        }
        return values;
    }

    public String[] getProperties() {
        return this.properties.toArray(new String[0]);
    }

    public long getId(MappedClass entity) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
        if (this.idMapping != null) {
            return (Long)PropertyUtils.getSimpleProperty(entity, (String)this.idMapping);
        }
        throw new NoSuchFieldException("id");
    }

    public void setIdMapping(String field) throws NoSuchFieldException {
        this.idMapping = field;
    }

    public void addMapping(String propertyName, String field) throws NoSuchFieldException {
        this.mapping.put(propertyName, field);
        this.properties.add(propertyName);
    }

    public void addSublistMapping(String propertyName, String field, ListConverter<?> converter) throws NoSuchFieldException {
        this.addMapping(propertyName, field);
        this.sublistMapping.put(propertyName, converter);
    }

    private void set(MappedClass rowElement, String field, TypedColumn column, int rowIndex) throws InvocationTargetException, NoSuchMethodException {
        try {
            switch (column.discriminator().value()) {
                case 2: {
                    PropertyUtils.setSimpleProperty(rowElement, (String)field, (Object)column.wstring_column()[rowIndex]);
                    break;
                }
                case 1: {
                    PropertyUtils.setSimpleProperty(rowElement, (String)field, (Object)column.long_column()[rowIndex]);
                    break;
                }
                case 3: {
                    PropertyUtils.setSimpleProperty(rowElement, (String)field, (Object)column.boolean_column()[rowIndex]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Property type " + column.discriminator().value() + " not supported");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

