/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database.JavaCorbaConversion;

import Xm.JavaUtils.Database.Aliased;
import Xm.JavaUtils.Database.Column;
import Xm.JavaUtils.Database.CompositeFilterElement;
import Xm.JavaUtils.Database.FunctionCall;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.IFilterElementVisitor;
import Xm.JavaUtils.Database.JavaCorbaConversion.BaseVisitorImpl;
import Xm.JavaUtils.Database.JavaCorbaConversion.NamedPropertyConverter;
import Xm.JavaUtils.Database.Join;
import Xm.JavaUtils.Database.Match;
import Xm.JavaUtils.Database.OpAnd;
import Xm.JavaUtils.Database.OpEqual;
import Xm.JavaUtils.Database.OpExists;
import Xm.JavaUtils.Database.OpGreater;
import Xm.JavaUtils.Database.OpGreaterEqual;
import Xm.JavaUtils.Database.OpIn;
import Xm.JavaUtils.Database.OpLess;
import Xm.JavaUtils.Database.OpLessEqual;
import Xm.JavaUtils.Database.OpLike;
import Xm.JavaUtils.Database.OpNot;
import Xm.JavaUtils.Database.OpNotEqual;
import Xm.JavaUtils.Database.OpNull;
import Xm.JavaUtils.Database.OpOr;
import Xm.JavaUtils.Database.SqlFilter;
import Xm.JavaUtils.Database.SubSelect;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.Value;
import Xm.Sql.Expression;
import Xm.Sql.Operand;
import Xm.Sql.OperandType;
import Xm.Sql.Operator;

public class ExpressionConverter {
    private NamedPropertyConverter m_NamedPropertyConverter = new NamedPropertyConverter();

    public Expression toExpression(IFilterElement element) {
        if (element != null) {
            ExpressionVisitor visitor = new ExpressionVisitor();
            element.accept(visitor);
            return visitor.getResult();
        }
        return this.getNullExpression();
    }

    public CompositeFilterElement toFilter(Expression expression) {
        IFilterElement leftOp = this.toFilter(expression.LeftOp);
        IFilterElement rightOp = this.toFilter(expression.RightOp);
        switch (expression.Type.value()) {
            case 0: {
                return SqlFilter.equal(leftOp, rightOp);
            }
            case 2: {
                return SqlFilter.lessEqual(leftOp, rightOp);
            }
            case 1: {
                return SqlFilter.like(leftOp, rightOp);
            }
            case 3: {
                return SqlFilter.and(leftOp, rightOp);
            }
            case 4: {
                return SqlFilter.or(leftOp, rightOp);
            }
            case 5: {
                return null;
            }
            case 6: {
                return SqlFilter.in(leftOp, rightOp);
            }
        }
        throw new IllegalArgumentException("Invalid operator " + expression.Type.value());
    }

    private IFilterElement toFilter(Operand op) {
        switch (op.discriminator().value()) {
            case 1: {
                String[] array = op.TheColumn().split("\\.", 2);
                if (array.length == 1) {
                    return SqlFilter.column(array[0]);
                }
                return SqlFilter.column(array[0], array[1]);
            }
            case 2: {
                Object value = this.m_NamedPropertyConverter.toValue(op.TheValue());
                return SqlFilter.value(value);
            }
            case 0: {
                assert (op.TheExpression().length == 1);
                return this.toFilter(op.TheExpression()[0]);
            }
            case 4: {
                return SqlFilter.value(op.TheStringSeq());
            }
        }
        throw new IllegalArgumentException("Invalid operand type " + op.discriminator().value());
    }

    private Expression getNullExpression() {
        Operand nullOp = new Operand();
        nullOp.__default(OperandType.otNoOperand);
        return new Expression(nullOp, nullOp, Operator.otNoOperator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionVisitor
    extends BaseVisitorImpl<Expression>
    implements IFilterElementVisitor {
        private Expression expression;
        private Operand operand;

        private ExpressionVisitor() {
        }

        @Override
        public Expression getResult() {
            return this.expression;
        }

        @Override
        public void visit(OpEqual operator) {
            this.expression = this.toExpression(operator, Operator.otEquals);
        }

        @Override
        public void visit(OpLessEqual operator) {
            this.expression = this.toExpression(operator, Operator.otLessEquals);
        }

        @Override
        public void visit(OpLike operator) {
            this.expression = this.toExpression(operator, Operator.otLike);
        }

        @Override
        public void visit(OpAnd operator) {
            this.expression = this.toExpression(operator, Operator.otAnd);
        }

        @Override
        public void visit(OpOr operator) {
            this.expression = this.toExpression(operator, Operator.otOr);
        }

        @Override
        public void visit(OpIn operator) {
            this.expression = this.toExpression(operator, Operator.otIn);
        }

        private Expression toExpression(CompositeFilterElement element, Operator type) {
            Expression ret = new Expression();
            ret.Type = type;
            ret.LeftOp = this.toOperand(element.getOp1());
            ret.RightOp = this.toOperand(element.getOp2());
            return ret;
        }

        private Operand toOperand(IFilterElement element) {
            Operand ret;
            this.operand = null;
            element.accept(this);
            if (this.operand != null) {
                ret = this.operand;
                this.operand = null;
            } else {
                ret = new Operand();
                ret.TheExpression(new Expression[]{this.expression});
            }
            return ret;
        }

        @Override
        public void visit(Value value) {
            this.operand = new Operand();
            if (value.getLiteral().getClass() == String[].class) {
                this.operand.TheStringSeq((String[])value.getLiteral());
            } else {
                this.operand.TheValue(ExpressionConverter.this.m_NamedPropertyConverter.toTypedValue(value.getLiteral()));
            }
        }

        @Override
        public void visit(Column column) {
            this.operand = new Operand();
            String columnName = column.getTable() == null ? column.getName() : column.getTable() + "." + column.getName();
            this.operand.TheColumn(columnName);
        }

        @Override
        public void visit(SubSelect select) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(OpNull operator) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(OpNotEqual operator) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(OpLess operator) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(OpGreater operator) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(OpGreaterEqual operator) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(OpNot operator) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(OpExists operator) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(Match match) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(Aliased aliased) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(Table table) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(Join join) {
            this.unsupportedVisit();
        }

        @Override
        public void visit(FunctionCall call) {
            this.unsupportedVisit();
        }
    }
}

