/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.NullValue;
import Xm.JavaUtils.Database.SelectStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertStatementBuilder {
    private String m_table;
    private List<String> m_columns;
    private List<Object> m_values;
    private SelectStatement m_selectClause;
    private List<String> m_onDuplicateKeyUpdateColumns;
    private List<Object> m_onDuplicateKeyUpdateValues;
    private Map<String, Object> m_properties;
    private boolean m_ignoreDuplicates;

    public InsertStatementBuilder() {
        this.m_columns = new ArrayList<String>();
        this.m_values = new ArrayList<Object>();
        this.m_onDuplicateKeyUpdateColumns = new ArrayList<String>();
        this.m_onDuplicateKeyUpdateValues = new ArrayList<Object>();
        this.m_properties = new HashMap<String, Object>();
        this.m_ignoreDuplicates = false;
    }

    public InsertStatementBuilder(InsertStatement statement) {
        this.m_table = statement.table();
        this.m_columns = statement.columns();
        this.m_values = statement.values();
        this.m_selectClause = statement.selectClause();
        this.m_onDuplicateKeyUpdateColumns = statement.onDuplicateKeyUpdateColumns();
        this.m_onDuplicateKeyUpdateValues = statement.onDuplicateKeyUpdateValues();
        this.m_properties = statement.cloneProperties();
        this.m_ignoreDuplicates = statement.isIgnoreDuplicates();
    }

    public void applyProperties(Map<String, Object> properties) {
        this.m_properties.putAll(properties);
    }

    public void table(String table) {
        this.m_table = table;
    }

    public void clearValues() {
        this.m_columns.clear();
        this.m_values.clear();
    }

    public void addValue(String column, int value) {
        this.m_columns.add(column);
        this.m_values.add(new Integer(value));
    }

    public void addValue(String column, long value) {
        this.m_columns.add(column);
        this.m_values.add(new Long(value));
    }

    public void addValue(String column, boolean value) {
        this.m_columns.add(column);
        this.m_values.add(new Boolean(value));
    }

    public void addValue(String column, String value) {
        if (value == null) {
            this.addNullValue(column);
        } else {
            this.m_columns.add(column);
            this.m_values.add(value);
        }
    }

    public void addNullValue(String column) {
        this.m_columns.add(column);
        this.m_values.add(NullValue.getInstance());
    }

    public void addValue(String column, Object value) {
        if (value == null) {
            this.addNullValue(column);
        } else {
            this.m_columns.add(column);
            this.m_values.add(value);
        }
    }

    private void eraseValue(String columnName, List<String> columns, List<Object> values) {
        int index = 0;
        Iterator<String> iter = columns.iterator();
        while (iter.hasNext()) {
            if (iter.next().equalsIgnoreCase(columnName)) {
                iter.remove();
                values.remove(index);
            }
            ++index;
        }
    }

    public void eraseValue(String column) {
        this.eraseValue(column, this.m_columns, this.m_values);
    }

    public void eraseUpdateValue(String column) {
        this.eraseValue(column, this.m_onDuplicateKeyUpdateColumns, this.m_onDuplicateKeyUpdateValues);
    }

    public void setSelectClause(SelectStatement selectClause) {
        this.m_selectClause = selectClause;
    }

    public void setSelectClause(SelectStatement selectClause, List<String> columns) {
        this.m_selectClause = selectClause;
        this.m_columns = columns;
    }

    public void clearUpdateValues() {
        this.m_onDuplicateKeyUpdateColumns.clear();
        this.m_onDuplicateKeyUpdateValues.clear();
    }

    public void addUpdateValue(String column, int value) {
        this.m_onDuplicateKeyUpdateColumns.add(column);
        this.m_onDuplicateKeyUpdateValues.add(new Integer(value));
    }

    public void addUpdateValue(String column, long value) {
        this.m_onDuplicateKeyUpdateColumns.add(column);
        this.m_onDuplicateKeyUpdateValues.add(new Long(value));
    }

    public void addUpdateValue(String column, boolean value) {
        this.m_onDuplicateKeyUpdateColumns.add(column);
        this.m_onDuplicateKeyUpdateValues.add(new Boolean(value));
    }

    public void addUpdateValue(String column, String value) {
        if (value == null) {
            this.addNullUpdateValue(column);
        } else {
            this.m_onDuplicateKeyUpdateColumns.add(column);
            this.m_onDuplicateKeyUpdateValues.add(value);
        }
    }

    public void addNullUpdateValue(String column) {
        this.m_onDuplicateKeyUpdateColumns.add(column);
        this.m_onDuplicateKeyUpdateValues.add(NullValue.getInstance());
    }

    public void addUpdateValue(String column, Object value) {
        if (value == null) {
            this.addNullUpdateValue(column);
        } else {
            this.m_onDuplicateKeyUpdateColumns.add(column);
            this.m_onDuplicateKeyUpdateValues.add(value);
        }
    }

    public InsertStatement build() {
        return new InsertStatement(this.m_table, this.m_selectClause, this.m_columns, this.m_values, this.m_onDuplicateKeyUpdateColumns, this.m_onDuplicateKeyUpdateValues, this.m_properties, this.m_ignoreDuplicates);
    }

    public List<Object> getValues() {
        return this.m_values;
    }

    public List<Object> getUpdateValues() {
        return this.m_onDuplicateKeyUpdateValues;
    }

    public void setIgnoreDuplicates(boolean value) {
        this.m_ignoreDuplicates = value;
    }
}

