/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SqlStatementToString;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.SqlWriteStatementVisitor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InsertStatement
extends SqlWriteStatement {
    private static final long serialVersionUID = 6012983282226531272L;
    private final String m_table;
    private final List<String> m_columns;
    private final List<Object> m_values;
    private final SelectStatement m_selectClause;
    private final List<String> m_onDuplicateKeyUpdateColumns;
    private final List<Object> m_onDuplicateKeyUpdateValues;
    private final boolean m_ignoreDuplicates;

    public InsertStatement(String table, List<String> columns, List<Object> values) {
        this(table, null, columns, values, null, null, null, false);
    }

    public InsertStatement(String table, List<String> columns, List<Object> values, List<String> onDuplicateKeyUpdateColumns, List<Object> onDuplicateKeyUpdateValues) {
        this(table, null, columns, values, onDuplicateKeyUpdateColumns, onDuplicateKeyUpdateValues, null, false);
    }

    public InsertStatement(String table, SelectStatement selectClause) {
        this(table, selectClause, null, null, null, null, null, false);
    }

    public InsertStatement(String table, SelectStatement selectClause, List<String> columns, List<Object> values, List<String> onDuplicateKeyUpdateColumns, List<Object> onDuplicateKeyUpdateValues) {
        this(table, selectClause, columns, values, onDuplicateKeyUpdateColumns, onDuplicateKeyUpdateValues, null, false);
    }

    public InsertStatement(String table, SelectStatement selectClause, List<String> columns, List<Object> values, List<String> onDuplicateKeyUpdateColumns, List<Object> onDuplicateKeyUpdateValues, Map<String, Object> properties, boolean ignoreDuplicates) {
        super(properties);
        this.m_table = table;
        this.m_columns = columns != null ? new ArrayList<String>(columns) : new ArrayList();
        this.m_values = values != null ? new ArrayList<Object>(values) : new ArrayList();
        this.m_selectClause = selectClause;
        this.m_onDuplicateKeyUpdateColumns = onDuplicateKeyUpdateColumns != null ? new ArrayList<String>(onDuplicateKeyUpdateColumns) : new ArrayList();
        this.m_onDuplicateKeyUpdateValues = onDuplicateKeyUpdateValues != null ? new ArrayList<Object>(onDuplicateKeyUpdateValues) : new ArrayList();
        this.m_ignoreDuplicates = ignoreDuplicates;
    }

    public String table() {
        return this.m_table;
    }

    public List<String> columns() {
        return new ArrayList<String>(this.m_columns);
    }

    public List<Object> values() {
        return new ArrayList<Object>(this.m_values);
    }

    public SelectStatement selectClause() {
        return this.m_selectClause;
    }

    public boolean onDuplicateKeyUpdate() {
        return !this.m_onDuplicateKeyUpdateColumns.isEmpty();
    }

    public List<String> onDuplicateKeyUpdateColumns() {
        return this.m_onDuplicateKeyUpdateColumns;
    }

    public List<Object> onDuplicateKeyUpdateValues() {
        return this.m_onDuplicateKeyUpdateValues;
    }

    @Override
    public String toString(SqlStatementToString visitor) {
        return visitor.toString(this);
    }

    @Override
    public void accept(SqlWriteStatementVisitor visitor) throws SQLException, DbConnectException {
        visitor.visit(this);
    }

    public boolean isIgnoreDuplicates() {
        return this.m_ignoreDuplicates;
    }
}

