/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.FunctionCall;
import Xm.JavaUtils.Database.FunctionDefinition;
import Xm.JavaUtils.Database.ParameterDefinition;
import java.util.Map;
import java.util.TreeMap;

public class FunctionCallBuilder {
    private FunctionDefinition function;
    private Map<String, Object> args = new TreeMap<String, Object>();

    public FunctionCallBuilder(FunctionDefinition function) {
        this.function = function;
    }

    public FunctionCallBuilder(FunctionCall call) {
        this.function = call.getFunction();
        this.args.putAll(call.getArguments());
    }

    public FunctionCallBuilder setParam(String name, Object value) {
        boolean found = false;
        for (ParameterDefinition param : this.function.getParameters()) {
            if (!param.getName().equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Undefined parameter: " + name);
        }
        this.args.put(name, value);
        return this;
    }

    public FunctionCallBuilder setParam(ParameterDefinition param, Object value) {
        return this.setParam(param.getName(), value);
    }

    public FunctionCall build() {
        return new FunctionCall(this.function, this.args);
    }
}

